/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import ru.sscc.matrix.RectBandedMatrix;
import ru.sscc.matrix.SymBandedMatrix;
import ru.sscc.spline.base.OrderedPreparator;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;

public class NonuniformPreparator
extends OrderedPreparator {
    private float[] points;

    public NonuniformPreparator(float[] fArray, int n, int n2) {
        this.points = fArray;
        this.h = this.calculateH(n, n2);
    }

    public void calculateA(SymBandedMatrix symBandedMatrix) {
        int n;
        int n2;
        this.ensureValidMatrix(symBandedMatrix, false);
        if (symBandedMatrix.nRows == 0) {
            return;
        }
        int n3 = symBandedMatrix.halfWidth;
        int n4 = this.h.bandWidth - 1;
        int n5 = this.h.isToeplitz() ? 0 : n4 + 1;
        int n6 = 2 * n4 - 1;
        int n7 = this.h.nColumns;
        int n8 = this.h.nRows;
        double d = (double)(1 - 2 * (n4 & 1)) / RealMath.factorial(n6);
        RealPointer realPointer = symBandedMatrix.getContainer().getPointer();
        RealPointer realPointer2 = this.h.getContainer().getPointer();
        RealMath.assign(realPointer, 0.0, n3 * symBandedMatrix.nRows);
        int n9 = 1;
        int n10 = 0;
        int n11 = 0;
        while (n9 < n7) {
            n2 = Math.max(n9 - n4, 0);
            int n12 = n9 - n2;
            if (n2 > 0) {
                n10 += n5;
                n11 += n3;
            }
            realPointer2.reset(n10 + n12, n4);
            n = 0;
            while (n < n12) {
                realPointer.reset(n11 + n, n3 - 1);
                RealMath.addVector(realPointer, realPointer2, RealMath.power((double)this.points[n9] - (double)this.points[n + n2], n6) * d, Math.min(n + 1, n8 - n2));
                ++n;
            }
            ++n9;
        }
        n9 = n8;
        n11 = 0;
        n10 = 0;
        while (n9 > 0) {
            realPointer.reset(n11, 1);
            realPointer2.reset(n10, 1);
            n2 = Math.min(n4, n9);
            n = 0;
            while (n < n2) {
                realPointer.set(RealMath.innerProduct(realPointer, realPointer2, n4 - n));
                ++n;
                realPointer.next();
                realPointer2.shift(n5);
            }
            --n9;
            n11 += n3;
            n10 += n5;
        }
    }

    private RectBandedMatrix calculateH(int n, int n2) {
        int n3;
        if (n2 <= 0 || n2 > n) {
            throw new IllegalArgumentException("Nonpositive difference order");
        }
        if (n2 == 1) {
            return new RectBandedMatrix(new DoubleContainer(new double[]{-1.0, 1.0}), n - 1, 2, true);
        }
        int n4 = n2 + 1;
        double[] dArray = new double[n4 * (n - 1)];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n - 1) {
            double d = 1.0 / ((double)this.points[n5 + 1] - (double)this.points[n5]);
            dArray[n6 + 1] = d;
            dArray[n6] = -d;
            ++n5;
            n6 += n4;
        }
        int n7 = 2;
        while (n7 < n2) {
            n5 = 0;
            n6 = 0;
            while (n5 < n - n7) {
                double d = (double)n7 / ((double)this.points[n5 + n7] - (double)this.points[n5]);
                int n8 = n6++;
                dArray[n8] = dArray[n8] * -d;
                n3 = 1;
                while (n3 < n7) {
                    dArray[n6] = (dArray[n6 + n2] - dArray[n6]) * d;
                    ++n3;
                    ++n6;
                }
                dArray[n6] = dArray[n6 + n2] * d;
                ++n5;
                n6 += n4 - n7;
            }
            ++n7;
        }
        n5 = 0;
        n6 = 0;
        while (n5 < n - n2) {
            dArray[n6] = -dArray[n6];
            n3 = 1;
            ++n6;
            while (n3 < n2) {
                dArray[n6] = dArray[n6 + n2] - dArray[n6];
                ++n3;
                ++n6;
            }
            dArray[n6] = dArray[n6 + n2];
            ++n5;
            ++n6;
        }
        return new RectBandedMatrix(new DoubleContainer(dArray), n - n2, n4, false);
    }
}

