/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.BoundingBox;
import ru.sscc.util.data.FloatPointer;
import ru.sscc.util.data.FloatSVecVector;
import ru.sscc.util.data.FloatVector;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.RealVectors;

public final class FloatSRefVectors
extends RealVectors {
    float[] vectors;
    short[] ref;

    public FloatSRefVectors(float[] fArray, short[] sArray, int n) {
        this(fArray, sArray, n, sArray.length);
    }

    public FloatSRefVectors(float[] fArray, short[] sArray, int n, int n2) {
        super(n, n2);
        this.vectors = fArray;
        this.ref = sArray;
    }

    public double add(int n, int n2, double d) {
        int n3 = this.pos((char)this.ref[n]) + n2;
        float f = (float)((double)this.vectors[n3] + d);
        this.vectors[n3] = f;
        return f;
    }

    public void assign(RealPointer realPointer, int n) {
        RealMath.assign(realPointer, this.vectors, this.pos((char)this.ref[n]), 1, this.dimension);
    }

    public BoundingBox boundingBox() {
        BoundingBox boundingBox = new BoundingBox(this.dimension);
        int n = 0;
        while (n < this.size) {
            boundingBox.enlargeBy(this.vectors, this.pos((char)this.ref[n]));
            ++n;
        }
        return boundingBox;
    }

    public double get(int n, int n2) {
        return this.vectors[this.pos((char)this.ref[n]) + n2];
    }

    public RealVector getComponent(int n) {
        return new FloatSVecVector(this.vectors, this.ref, this.size, n, this.dimension);
    }

    public RealPointer getPointer(int n) {
        return new FloatPointer(this.vectors, this.pos((char)this.ref[n]), 1);
    }

    public RealVector getVector(int n) {
        return new FloatVector(this.vectors, this.dimension, this.pos((char)this.ref[n]), 1);
    }

    public boolean inBox(int n, BoundingBox boundingBox) {
        return boundingBox.contains(this.vectors, this.pos((char)this.ref[n]));
    }

    public double mul(int n, int n2, double d) {
        int n3 = this.pos((char)this.ref[n]) + n2;
        float f = (float)((double)this.vectors[n3] * d);
        this.vectors[n3] = f;
        return f;
    }

    public int offset(int n) {
        return this.pos((char)this.ref[n]);
    }

    public double set(int n, int n2, double d) {
        this.vectors[this.pos((int)((char)this.ref[n])) + n2] = (float)d;
        return d;
    }

    public double squaredDistance(int n, RealPointer realPointer) {
        return RealMath.squaredDistance(realPointer, this.vectors, this.pos((char)this.ref[n]), this.dimension);
    }
}

