/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.BoundingBox;
import ru.sscc.util.data.FloatPointer;
import ru.sscc.util.data.FloatVector;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.RealVectors;

public final class FloatVectors
extends RealVectors {
    float[] vectors;

    public FloatVectors(int n, int n2) {
        this(new float[n * n2], n, n2);
    }

    public FloatVectors(float[] fArray, int n) {
        this(fArray, n, fArray.length / n);
    }

    public FloatVectors(float[] fArray, int n, int n2) {
        super(n, n2);
        this.vectors = fArray;
    }

    public double add(int n, int n2, double d) {
        int n3 = this.pos(n) + n2;
        float f = (float)((double)this.vectors[n3] + d);
        this.vectors[n3] = f;
        return f;
    }

    public void assign(RealPointer realPointer, int n) {
        RealMath.assign(realPointer, this.vectors, this.pos(n), 1, this.dimension);
    }

    public BoundingBox boundingBox() {
        BoundingBox boundingBox = new BoundingBox(this.dimension);
        int n = 0;
        while (n < this.size) {
            boundingBox.enlargeBy(this.vectors, this.pos(n));
            ++n;
        }
        return boundingBox;
    }

    public double get(int n, int n2) {
        return this.vectors[this.pos(n) + n2];
    }

    public RealVector getComponent(int n) {
        return new FloatVector(this.vectors, this.size, n, this.dimension);
    }

    public RealPointer getPointer(int n) {
        return new FloatPointer(this.vectors, this.pos(n), 1);
    }

    public RealVector getVector(int n) {
        return new FloatVector(this.vectors, this.dimension, this.pos(n), 1);
    }

    public boolean inBox(int n, BoundingBox boundingBox) {
        return boundingBox.contains(this.vectors, this.pos(n));
    }

    public double mul(int n, int n2, double d) {
        int n3 = this.pos(n) + n2;
        float f = (float)((double)this.vectors[n3] * d);
        this.vectors[n3] = f;
        return f;
    }

    public int offset(int n) {
        return this.pos(n);
    }

    public double set(int n, int n2, double d) {
        this.vectors[this.pos((int)n) + n2] = (float)d;
        return d;
    }

    public double squaredDistance(int n, RealPointer realPointer) {
        return RealMath.squaredDistance(realPointer, this.vectors, this.pos(n), this.dimension);
    }
}

