/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Objects;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.FATSDataset;
import org.nyet.ecuxplot.Filter;
import org.nyet.logfile.Dataset;

public class ECUxChartFactory {
    private static void addAxis(XYPlot plot, String label, XYDataset dataset, int series, boolean lines, boolean shapes) {
        NumberAxis axis = new NumberAxis(label);
        axis.setAutoRangeIncludesZero(false);
        plot.setRangeAxis(1, (ValueAxis)axis);
        plot.setDataset(1, dataset);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer(lines, shapes));
    }

    private static JFreeChart create2AxisXYLineChart() {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)new DefaultXYDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        ECUxChartFactory.addAxis(plot, "", (XYDataset)new DefaultXYDataset(), 1, true, false);
        return chart;
    }

    private static JFreeChart create2AxisScatterPlot() {
        JFreeChart chart = ChartFactory.createScatterPlot((String)"", (String)"", (String)"", (XYDataset)new DefaultXYDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        ECUxChartFactory.addAxis(plot, "", (XYDataset)new DefaultXYDataset(), 1, false, true);
        return chart;
    }

    public static JFreeChart create2AxisChart(boolean scatter) {
        JFreeChart chart = scatter ? ECUxChartFactory.create2AxisScatterPlot() : ECUxChartFactory.create2AxisXYLineChart();
        XYPlot plot = chart.getXYPlot();
        ((NumberAxis)plot.getRangeAxis(0)).setAutoRangeIncludesZero(false);
        plot.getRangeAxis(1).setLabelFont(plot.getRangeAxis(0).getLabelFont());
        return chart;
    }

    public static void setChartStyle(JFreeChart chart, boolean lines, boolean shapes) {
        XYPlot plot = chart.getXYPlot();
        for (int i = 0; i < plot.getDatasetCount(); ++i) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer(i);
            renderer.setBaseLinesVisible(lines);
            renderer.setBaseShapesVisible(shapes);
        }
    }

    public static void setAxisPaint(JFreeChart chart, int axis, DefaultXYDataset d, Dataset.Key ykey, Integer[] series) {
        int yki;
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer(axis);
        Color[][] colors = new Color[][]{{new Color(255, 0, 0), new Color(0, 22, 255), new Color(0, 224, 255), new Color(255, 200, 0)}, {new Color(185, 0, 255), new Color(0, 255, 72), new Color(178, 255, 0), new Color(255, 112, 0)}};
        axis %= colors.length;
        String[] list = ECUxChartFactory.getDatasetYkeys(d);
        for (yki = 0; yki < list.length && !list[yki].equals(ykey.getString()); ++yki) {
        }
        Color color = colors[axis][yki % colors[axis].length];
        int i = series.length / 2;
        Color c = color;
        while (i >= 0) {
            renderer.setSeriesPaint(series[i].intValue(), (Paint)c);
            --i;
            c = c.darker();
        }
        i = series.length / 2 + 1;
        c = color;
        while (i < series.length) {
            renderer.setSeriesPaint(series[i].intValue(), (Paint)c);
            ++i;
            c = c.brighter();
        }
    }

    public static void setAxisStroke(JFreeChart chart, int axis, DefaultXYDataset d, Dataset.Key ykey, Integer[] series, int index) {
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer(axis);
        Stroke[] strokes = new Stroke[]{new BasicStroke(1.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f), new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 3.0f, 1.0f, 3.0f}, 0.0f)};
        for (Integer serie : series) {
            renderer.setSeriesStroke(serie.intValue(), strokes[index % strokes.length]);
        }
    }

    public static Integer[] addDataset(DefaultXYDataset d, ECUxDataset data, Comparable<?> xkey, Dataset.Key ykey, Filter filter) {
        boolean showAllRanges;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ArrayList<Dataset.Range> ranges = data.getRanges();
        double[][] empty = new double[][]{new double[0], new double[0]};
        if (ranges.size() == 0) {
            filter.currentRange = 0;
            ECUxDataset eCUxDataset = data;
            Objects.requireNonNull(eCUxDataset);
            Dataset.Key key = new Dataset.Key((Dataset)eCUxDataset, ykey, (Dataset)data);
            key.hideRange();
            d.addSeries((Comparable)key, (double[][])empty);
            ret.add(d.indexOf((Comparable)key));
            return ret.toArray(new Integer[0]);
        }
        if (filter.currentRange >= ranges.size()) {
            filter.currentRange = data.getRanges().size() - 1;
        }
        for (int i = (showAllRanges = filter.showAllRanges()) ? 0 : filter.currentRange; i < (showAllRanges ? ranges.size() : filter.currentRange + 1); ++i) {
            ECUxDataset eCUxDataset = data;
            Objects.requireNonNull(eCUxDataset);
            Dataset.Key key = new Dataset.Key(eCUxDataset, ykey, i, data);
            if (ranges.size() == 1) {
                key.hideRange();
            } else {
                key.showRange();
            }
            Dataset.Range r = ranges.get(i);
            try {
                double[][] s = new double[][]{data.getData(xkey, r), data.getData(ykey, r)};
                d.addSeries((Comparable)key, (double[][])s);
                ret.add(d.indexOf((Comparable)key));
                continue;
            }
            catch (Exception e) {
                d.addSeries((Comparable)key, (double[][])empty);
                ret.add(d.indexOf((Comparable)key));
            }
        }
        return ret.toArray(new Integer[0]);
    }

    public static void removeDataset(DefaultXYDataset d) {
        while (d.getSeriesCount() > 0) {
            d.removeSeries(d.getSeriesKey(0));
        }
    }

    public static void removeDataset(DefaultXYDataset d, Comparable<?> ykey) {
        if (ykey instanceof Dataset.Key) {
            ykey = ((Dataset.Key)ykey).getString();
        }
        for (int i = 0; i < d.getSeriesCount(); ++i) {
            while (i < d.getSeriesCount() && d.getSeriesKey(i).equals(ykey)) {
                d.removeSeries(d.getSeriesKey(i));
            }
        }
    }

    public static String[] getDatasetYkeys(DefaultXYDataset d) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < d.getSeriesCount(); ++i) {
            Comparable key = d.getSeriesKey(i);
            String s = key instanceof Dataset.Key ? ((Dataset.Key)key).getString() : key.toString();
            if (ret.contains(s)) continue;
            ret.add(s);
        }
        return ret.toArray(new String[0]);
    }

    public static JFreeChart createFATSChart(FATSDataset dataset) {
        return ChartFactory.createBarChart3D((String)dataset.getTitle(), (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }
}

