/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.TreeMap;
import org.jfree.data.category.DefaultCategoryDataset;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.util.Files;

public class FATSDataset
extends DefaultCategoryDataset {
    private static final long serialVersionUID = 1L;
    private int start = 4200;
    private int end = 6500;
    private final TreeMap<String, ECUxDataset> fileDatasets;

    public FATSDataset(TreeMap<String, ECUxDataset> fileDatasets) {
        this.fileDatasets = fileDatasets;
        this.rebuild();
    }

    private void rebuild() {
        for (ECUxDataset data : this.fileDatasets.values()) {
            this.setValue(data);
        }
    }

    public void setValue(ECUxDataset data, int series, double value) {
        String xkey = Files.stem(data.getFileId());
        String ykey = "Run " + (series + 1);
        super.setValue(value, (Comparable)((Object)xkey), (Comparable)((Object)ykey));
    }

    public void removeValue(ECUxDataset data, int series) {
        String xkey = Files.stem(data.getFileId());
        String ykey = "Run " + (series + 1);
        super.removeValue((Comparable)((Object)xkey), (Comparable)((Object)ykey));
    }

    public void setValue(ECUxDataset data) {
        try {
            this.removeRow((Comparable)((Object)Files.stem(data.getFileId())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < data.getRanges().size(); ++i) {
            this.setValue(data, i);
        }
    }

    public void setValue(ECUxDataset data, int series) {
        try {
            this.setValue(data, series, data.calcFATS(series, this.start, this.end));
        }
        catch (Exception e) {
            this.removeValue(data, series);
        }
    }

    public void removeValue(ECUxDataset data) {
        for (int i = 0; i < data.getRanges().size(); ++i) {
            this.removeValue(data, i);
        }
    }

    public void setStart(int start) {
        this.start = start;
        this.rebuild();
    }

    public void setEnd(int end) {
        this.end = end;
        this.rebuild();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getTitle() {
        return this.start + "-" + this.end + " RPM";
    }
}

