/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.mappack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.zip.ZipInputStream;
import org.nyet.mappack.Folder;
import org.nyet.mappack.HexValue;
import org.nyet.mappack.Map;
import org.nyet.mappack.Parse;
import org.nyet.mappack.ParserException;
import org.nyet.util.Files;
import org.nyet.util.XmlString;

public class Project {
    public String stem;
    public String name;
    public Date mTime;
    private final HexValue[] header = new HexValue[4];
    public String version;
    private final HexValue[] header1 = new HexValue[4];
    private final HexValue[] h77 = new HexValue[1];
    public int numMaps;
    public TreeSet<Map> maps;
    private final HexValue[] header2 = new HexValue[3];
    public int numFolders;
    public TreeSet<Folder> folders = new TreeSet();
    private final int kpv;

    private void ParseHeader(ByteBuffer b) throws ParserException {
        this.name = Parse.string(b);
        Parse.buffer(b, this.header);
        if (this.kpv == 2) {
            b.getInt();
        }
        this.version = Parse.string(b);
        Parse.buffer(b, this.header1);
        if (this.kpv == 2) {
            b.getInt();
        }
        Parse.buffer(b, this.h77);
        if (this.kpv == 2) {
            b.get();
        }
    }

    private static ByteBuffer is2bb(ZipInputStream in) throws IOException {
        int r;
        int BUFSIZE = 1024;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] tmp = new byte[1024];
        while ((r = in.read(tmp, 0, 1024)) != -1) {
            if (r <= 0) continue;
            out.write(tmp, 0, r);
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    private void ParseMapsZip(ByteBuffer b) throws ParserException {
        int start = b.position();
        int zsize = b.getInt();
        byte[] zip = new byte[zsize];
        b.get(zip);
        ByteArrayInputStream bbis = new ByteArrayInputStream(zip);
        ZipInputStream zis = new ZipInputStream(bbis);
        try {
            zis.getNextEntry();
            ByteBuffer bb = Project.is2bb(zis);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.get();
            this.ParseMaps(bb);
        }
        catch (IOException e) {
            throw new ParserException(b, e.toString(), (Object)e);
        }
        b.position(start + zsize);
        b.getInt();
    }

    private void ParseMaps(ByteBuffer b) throws ParserException {
        this.numMaps = b.getInt();
        this.maps = new TreeSet();
        for (int i = 0; i < this.numMaps; ++i) {
            try {
                Map m = new Map(i, b, this.kpv);
                this.maps.add(m);
                continue;
            }
            catch (ParserException e) {
                throw new ParserException(e.b, String.format("error parsing map %d/%d:\n  %s", i + 1, this.numMaps, e.getMessage()), e.getCause(), e.o);
            }
        }
    }

    private void ParseFolders(ByteBuffer b) throws ParserException {
        this.numFolders = b.getInt();
        for (int i = 0; i < this.numFolders; ++i) {
            try {
                Folder f = new Folder(b, this.kpv);
                if (f.id < 0 || f.id >= this.numFolders) continue;
                this.folders.add(f);
                continue;
            }
            catch (ParserException e) {
                throw new ParserException(e.b, String.format("error parsing folder %d/%d: %s", i + 1, this.numMaps, e.toString()), e.o);
            }
        }
        int[] flut = new int[this.numFolders];
        int i = 0;
        for (Folder f : this.folders) {
            flut[f.id] = i;
            f.id = i++;
        }
        if (this.maps != null) {
            for (Map m : this.maps) {
                m.folderId = flut[m.folderId];
            }
        }
    }

    public Project(String filename, ByteBuffer b, int kpv) throws ParserException {
        this.kpv = kpv;
        this.stem = Files.stem(filename);
        this.ParseHeader(b);
        if (kpv == 1) {
            this.ParseMaps(b);
        } else {
            this.ParseMapsZip(b);
        }
        Parse.buffer(b, this.header2);
        this.ParseFolders(b);
    }

    public String toString() {
        String out = "project: '" + this.name + "': (" + this.version + ") - " + this.numMaps + " maps\n";
        out = out + "  h: " + Arrays.toString(this.header) + "\n";
        out = out + " h1: " + Arrays.toString(this.header1) + "\n";
        out = out + " h2: " + Arrays.toString(this.header2) + "\n";
        return out;
    }

    public String toString(int format, ByteBuffer imagebuf) {
        switch (format) {
            case 2: {
                Object out = "%%HEADER%%\n";
                out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", 1000, "FileVers", this.version + " - " + String.valueOf(this.mTime));
                out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", 1005, "DefTitle", this.stem);
                out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", 1006, "Desc", this.name);
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", 1007, "DescSize", this.name.length() + 1);
                out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", 1010, "Author", "mesim translator");
                if (imagebuf != null && imagebuf.limit() > 0) {
                    out = (String)out + String.format("\t%06d %-17s=0x%X\n", 1030, "BinSize", imagebuf.limit());
                }
                out = (String)out + String.format("\t%06d %-17s=%d\n", 1035, "BaseOffset", 0);
                out = (String)out + String.format("\t%06d %-17s=\"\"\n", 1200, "ADSAssoc", 0);
                out = (String)out + String.format("\t%06d %-17s=0x0\n", 1225, "ADSCheck", 0);
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", 1300, "GenFlags", 0);
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", 1325, "ModeFlags", 0);
                for (Folder f : this.folders) {
                    out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", 2000 + f.id, "Category" + f.id, f.name);
                }
                return (String)out + "%%END%%\n\n";
            }
            case 3: {
                XmlString xs = new XmlString();
                xs.indent();
                xs.append("XDFHEADER");
                xs.indent();
                xs.append("fileversion", this.version);
                xs.append("deftitle", this.stem);
                xs.append("description", this.name);
                xs.append("author", "mesim translator");
                xs.append("baseoffset", 0);
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                m.put("datasizeinbits", 8);
                m.put("sigdigits", 2);
                m.put("outputtype", 1);
                m.put("signed", 0);
                m.put("lsbfirst", 1);
                m.put("float", 0);
                xs.append("DEFAULTS", m);
                if (imagebuf != null && imagebuf.limit() > 0) {
                    m.clear();
                    m.put("type", "0xFFFFFFFF");
                    m.put("startaddress", "0x0");
                    m.put("size", String.format("0x%X", imagebuf.limit()));
                    m.put("regionflags", "0x0");
                    m.put("name", "Binary File");
                    m.put("desc", "This region describes the bin file edited by this XDF");
                    xs.append("REGION", m);
                }
                for (Folder f : this.folders) {
                    m.clear();
                    m.put("index", String.format("0x%X", f.id));
                    m.put("name", f.name);
                    xs.append("CATEGORY", m);
                }
                xs.unindent();
                return xs.append("/XDFHEADER").toString();
            }
            case 0: {
                return this.toString();
            }
        }
        return "";
    }

    public ArrayList<Map> find(Map map) {
        if (this.maps == null) {
            return null;
        }
        ArrayList<Map> matches = new ArrayList<Map>();
        for (Map m : this.maps) {
            if (!m.equals(map)) continue;
            matches.add(m);
        }
        return matches;
    }

    public ArrayList<Map> find(String id) {
        if (this.maps == null) {
            return null;
        }
        ArrayList<Map> matches = new ArrayList<Map>();
        for (Map m : this.maps) {
            if (!m.equals(id)) continue;
            matches.add(m);
        }
        return matches;
    }

    public ArrayList<Map> find(HexValue v) {
        if (this.maps == null) {
            return null;
        }
        ArrayList<Map> matches = new ArrayList<Map>();
        for (Map m : this.maps) {
            if (!m.extent[0].equals(v)) continue;
        }
        return matches;
    }
}

