/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.util;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import org.nyet.util.FileDropHost;

public class FileDropListener
implements DropTargetListener {
    private DataFlavor Linux = null;
    private DataFlavor Windows = null;
    private DropTarget dropTarget;
    private final FileDropHost fileDropHost;

    public FileDropListener(FileDropHost fileDropHost, Component dropTargetComponent) {
        this.fileDropHost = fileDropHost;
        this.setDropTarget(new DropTarget(dropTargetComponent, this));
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        int action = event.getDropAction();
        event.acceptDrag(action);
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void drop(DropTargetDropEvent dropEvent) {
        try {
            Transferable droppedItem = dropEvent.getTransferable();
            DataFlavor[] droppedItemFlavors = droppedItem.getTransferDataFlavors();
            droppedItemFlavors = droppedItemFlavors.length == 0 ? dropEvent.getCurrentDataFlavors() : droppedItemFlavors;
            DataFlavor flavor = DataFlavor.selectBestTextFlavor(droppedItemFlavors);
            flavor = flavor == null ? droppedItemFlavors[0] : flavor;
            this.Linux = new DataFlavor("text/uri-list;class=java.io.Reader");
            this.Windows = DataFlavor.javaFileListFlavor;
            this.handleDrop(dropEvent, droppedItem, flavor);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("DnD not initalized properly, please try again.");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedFlavorException e) {
            System.err.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.err.println(e.getMessage());
        }
    }

    private void handleDrop(DropTargetDropEvent dropEvent, Transferable droppedItem, DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(this.Linux)) {
            this.acceptLinuxDrop(dropEvent, droppedItem, flavor);
        } else if (flavor.equals(this.Windows)) {
            this.acceptWindowsDrop(dropEvent, droppedItem, flavor);
        } else {
            System.err.println("DnD Error");
            dropEvent.rejectDrop();
        }
    }

    private void acceptWindowsDrop(DropTargetDropEvent dropTargetEvent, Transferable droppedItem, DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        dropTargetEvent.acceptDrop(3);
        List list = (List)droppedItem.getTransferData(flavor);
        dropTargetEvent.dropComplete(true);
        if (list.size() == 1) {
            this.fileDropHost.loadFile(new File(((File)list.get(0)).toString()));
        } else {
            this.fileDropHost.loadFiles(list);
        }
    }

    private void acceptLinuxDrop(DropTargetDropEvent dropTargetEvent, Transferable tr, DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        dropTargetEvent.acceptDrop(3);
        BufferedReader read = new BufferedReader(flavor.getReaderForText(tr));
        String fileName = URLDecoder.decode(read.readLine(), "UTF-8");
        if (fileName.startsWith("file://")) {
            fileName = fileName.substring(7);
        }
        read.close();
        dropTargetEvent.dropComplete(true);
        this.fileDropHost.loadFile(new File(fileName));
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public void setDropTarget(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }
}

