/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.nyet.ecuxplot.PreferencesEditor;
import org.nyet.ecuxplot.SAE;

public class SAEEditor
extends PreferencesEditor {
    private static final long serialVersionUID = 1L;
    private final SAE s;
    public JTextField temperature;
    public JTextField altitude;
    public JTextField humidity;
    public JLabel correction;
    private static String[][] pairs = new String[][]{{"Temperature (C)", "temperature"}, {"Altitude (m)", "altitude"}, {"Humidity (%)", "humidity"}, {"SAE correction", "correction"}};
    private static int[] fieldSizes = new int[]{4, 5, 3, 0};

    @Override
    protected void Process(ActionEvent event) {
        this.s.temperature(Double.valueOf(this.temperature.getText()));
        this.s.altitude(Double.valueOf(this.altitude.getText()));
        this.s.humidity(Double.valueOf(this.humidity.getText()));
        this.updateCorrection();
        super.Process(event);
    }

    public SAEEditor(Preferences prefs, SAE s) {
        super(prefs.node("SAE"), pairs, fieldSizes);
        this.s = s;
    }

    private String getCorrection() {
        return String.format("%.3f", this.s.correction());
    }

    private void updateCorrection() {
        this.correction.setText(this.getCorrection());
    }

    @Override
    public void updateDialog() {
        this.temperature.setText("" + this.s.temperature());
        this.altitude.setText("" + this.s.altitude());
        this.humidity.setText("" + this.s.humidity());
        this.updateCorrection();
    }
}

