/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.util;

import java.awt.Color;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.nyet.util.ExitListener;

public class WindowUtilities {
    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + String.valueOf(e));
        }
    }

    public static void setJavaLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting Java LAF: " + String.valueOf(e));
        }
    }

    public static void setMotifLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e) {
            System.out.println("Error setting Motif LAF: " + String.valueOf(e));
        }
    }

    public static JFrame openInJFrame(Container content, int width, int height, String title, Color bgColor) {
        JFrame frame = new JFrame(title);
        frame.setBackground(bgColor);
        content.setBackground(bgColor);
        frame.setSize(width, height);
        frame.setContentPane(content);
        frame.addWindowListener(new ExitListener());
        frame.setVisible(true);
        return frame;
    }

    public static JFrame openInJFrame(Container content, int width, int height, String title) {
        return WindowUtilities.openInJFrame(content, width, height, title, Color.white);
    }

    public static JFrame openInJFrame(Container content, int width, int height) {
        return WindowUtilities.openInJFrame(content, width, height, content.getClass().getName(), Color.white);
    }
}

