/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.prefs.Preferences;

public class Constants {
    public static final String PREFS_TAG = "constants";
    private static final double defaultMass = 1700.0;
    private static final double defaultRpm_per_mph = 72.1;
    private static final double defaultCd = 0.31;
    private static final double defaultFA = 2.034;
    private static final double defaultRolling_drag = 0.015;
    private static final double defaultStatic_loss = 0.0;
    private static final double defaultDriveline_loss = 0.25;
    private final Preferences prefs;

    public Constants(Preferences prefs) {
        this.prefs = prefs.node(PREFS_TAG);
    }

    public double mass() {
        return this.prefs.getDouble("mass", 1700.0);
    }

    public void mass(Double val) {
        this.prefs.putDouble("mass", val);
    }

    public double rpm_per_mph() {
        return this.prefs.getDouble("rpm_per_mph", 72.1);
    }

    public void rpm_per_mph(Double val) {
        this.prefs.putDouble("rpm_per_mph", val);
    }

    public double Cd() {
        return this.prefs.getDouble("Cd", 0.31);
    }

    public void Cd(Double val) {
        this.prefs.putDouble("Cd", val);
    }

    public double FA() {
        return this.prefs.getDouble("FA", 2.034);
    }

    public void FA(Double val) {
        this.prefs.putDouble("FA", val);
    }

    public double rolling_drag() {
        return this.prefs.getDouble("rolling_drag", 0.015);
    }

    public void rolling_drag(Double val) {
        this.prefs.putDouble("rolling_drag", val);
    }

    public double static_loss() {
        return this.prefs.getDouble("static_loss", 0.0);
    }

    public void static_loss(Double val) {
        this.prefs.putDouble("static_loss", val);
    }

    public double driveline_loss() {
        return this.prefs.getDouble("driveline_loss", 0.25);
    }

    public void driveline_loss(Double val) {
        this.prefs.putDouble("driveline_loss", val);
    }

    public String driveline_loss_string() {
        return "" + this.driveline_loss() * 100.0;
    }

    public void driveline_loss_string(String val) {
        this.prefs.putDouble("driveline_loss", Double.valueOf(val) / 100.0);
    }

    public Preferences get() {
        return this.prefs;
    }
}

