/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.mappack;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import org.nyet.mappack.HexValue;
import org.nyet.mappack.Map;
import org.nyet.mappack.Parse;
import org.nyet.mappack.Project;
import org.nyet.util.MMapFile;

public class Parser
extends MMapFile {
    private final String signature;
    private final String filename;
    private final String version;
    public ArrayList<Project> projects;

    private static final void eatNumber(ByteBuffer b, int count, int width) {
        block5: for (int i = 0; i < count; ++i) {
            switch (width) {
                case 1: {
                    b.get();
                    continue block5;
                }
                case 2: {
                    b.getShort();
                    continue block5;
                }
                case 4: {
                    b.getInt();
                    continue block5;
                }
                default: {
                    return;
                }
            }
        }
    }

    private static final void eatNumber(ByteBuffer b, int count) {
        Parser.eatNumber(b, count, 4);
    }

    private static final void eatNumber(ByteBuffer b) {
        Parser.eatNumber(b, 1);
    }

    private static final void parseHeader(ByteBuffer b, int ver) throws Exception {
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b, 3);
        Parser.eatNumber(b, 1, 2);
        Parser.eatNumber(b);
        if (b.getInt() != -1) {
            int pos = b.position();
            throw new Exception(HexValue.dumpHex(b, 16) + ": can't find term 1 @" + pos);
        }
        Parser.eatNumber(b, 2);
        Parser.eatNumber(b);
        Parser.eatNumber(b, 4);
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b, 10);
        Parser.eatNumber(b, 10);
        Parser.eatNumber(b, 3);
        Parser.eatNumber(b);
        Parser.eatNumber(b, 4);
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b, 1, 2);
        Parser.eatNumber(b, 1, 1);
        if (b.getInt() != -1) {
            int pos = b.position();
            throw new Exception(HexValue.dumpHex(b, 16) + ": can't find term 2 @" + pos);
        }
        switch (ver) {
            case 1: {
                Parser.eatNumber(b, 2);
                Parser.eatNumber(b);
                Parser.eatNumber(b, 4);
                Parser.eatNumber(b, 1, 1);
                break;
            }
            case 2: {
                Parser.eatNumber(b, 1, 1);
                Parser.eatNumber(b, 1);
                Parser.eatNumber(b, 5);
                Parse.string(b);
                Parse.string(b);
                Parser.eatNumber(b, 10);
                if (b.getInt() != -1) {
                    int pos = b.position();
                    throw new Exception(HexValue.dumpHex(b, 16) + ": can't find term 2a @" + pos);
                }
                Parser.eatNumber(b, 1, 1);
                Parser.eatNumber(b, 12);
                Parse.string(b);
                Parser.eatNumber(b, 7);
                Parser.eatNumber(b, 1);
                Parser.eatNumber(b, 2);
                Parser.eatNumber(b, 1, 1);
            }
        }
        Parser.eatNumber(b, 20, 2);
        Parser.eatNumber(b, 16, 2);
        Parser.eatNumber(b, 18);
        if (b.getInt() != -1) {
            int pos = b.position();
            throw new Exception(HexValue.dumpHex(b, 16) + ": can't find term 3 @" + pos);
        }
        Parser.eatNumber(b);
        switch (ver) {
            case 1: {
                break;
            }
            case 2: {
                Parser.eatNumber(b);
                Parser.eatNumber(b);
            }
        }
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b);
        Parser.eatNumber(b);
    }

    public Parser(String fname) throws Exception {
        super(fname, ByteOrder.LITTLE_ENDIAN);
        int kpv;
        int[] kp = new int[2];
        ByteBuffer buf = this.getByteBuffer();
        this.signature = Parse.string(buf);
        kp[0] = buf.getInt();
        kp[1] = buf.getInt();
        switch (kp[0]) {
            case 113: 
            case 116: {
                kpv = 1;
                buf.position(92);
                break;
            }
            case 292: 
            case 329: {
                kpv = 2;
                buf.position(96);
                break;
            }
            default: {
                throw new Exception("Unknown kp version " + kp[0]);
            }
        }
        this.filename = Parse.string(buf);
        this.version = Parse.string(buf);
        Parser.parseHeader(buf, kpv);
        this.projects = new ArrayList();
        Project p = new Project(fname, buf, kpv);
        p.mTime = new Date(this.mTime);
        this.projects.add(p);
    }

    public String toString() {
        String out = "signature: " + this.signature + "\n";
        out = out + "filename: " + this.filename + "\n";
        out = out + "version: " + this.version + "\n";
        out = out + "projects: " + this.projects.size() + "\n";
        for (Project p : this.projects) {
            out = out + p.toString();
        }
        return out;
    }

    public ArrayList<Map> find(Map map) {
        ArrayList<Map> matches = new ArrayList<Map>();
        for (Project p : this.projects) {
            matches.addAll(p.find(map));
        }
        return matches;
    }

    public ArrayList<Map> find(String id) {
        ArrayList<Map> matches = new ArrayList<Map>();
        for (Project p : this.projects) {
            matches.addAll(p.find(id));
        }
        return matches;
    }

    public ArrayList<Map> find(HexValue v) {
        ArrayList<Map> matches = new ArrayList<Map>();
        for (Project p : this.projects) {
            matches.addAll(p.find(v));
        }
        return matches;
    }

    public String getFilename() {
        return this.filename;
    }
}

