/*
 * Decompiled with CFR 0.152.
 */
package vec_math;

public abstract class LinearSmoothing {
    public static final int FIR = 1;
    public static final int IIR = 2;
    protected int type;
    protected double[] cn = null;
    protected double[] dn = null;
    protected int nk;
    protected int nj;

    protected LinearSmoothing() {
    }

    protected abstract void setType();

    public int getType() {
        if (this.type == 1) {
            return 1;
        }
        if (this.type == 2) {
            return 2;
        }
        throw new IllegalArgumentException("Not initialized");
    }

    public boolean isValid() {
        return this.cn != null || this.dn != null;
    }

    public int getNk() {
        if (this.cn == null) {
            return 0;
        }
        return this.nk;
    }

    public int getNj() {
        if (this.dn == null) {
            return 0;
        }
        return this.nj;
    }

    public int getM() {
        if (this.cn == null) {
            return 0;
        }
        return this.cn.length;
    }

    public int getN() {
        if (this.dn == null) {
            return 0;
        }
        return this.dn.length;
    }

    public double smoothAt(double[] input, double[] output, int ix, int ox) {
        int i1;
        if (this.cn != null && (input == null || ix + this.nk < 0 || ix + this.nk + this.cn.length > input.length)) {
            throw new IllegalArgumentException("Cannot filter from input " + ix + ": " + (ix + this.nk) + ":" + (ix + this.nk) + ":" + this.cn.length + ":" + input.length);
        }
        if (this.dn != null && (output == null || ox + this.nj < 0 || ox + this.nj + this.dn.length > output.length)) {
            throw new IllegalArgumentException("Cannot filter to output " + ox + ": " + (ox + this.nk) + ":" + (ox + this.nk) + ":" + this.cn.length + ":" + output.length);
        }
        double ret = 0.0;
        if (this.cn != null) {
            for (i1 = 0; i1 != this.cn.length; ++i1) {
                ret += this.cn[i1] * input[i1 + this.nk + ix];
            }
        }
        if (this.dn != null) {
            for (i1 = 0; i1 != this.dn.length; ++i1) {
                ret += this.dn[i1] * output[i1 + this.nj + ox];
            }
        }
        return ret;
    }

    public double[] smoothAll(double[] input, int start, int end) {
        if (this.cn != null && (start + this.nk < 0 || end + this.nk + this.cn.length > input.length)) {
            throw new IllegalArgumentException("Cannot filter cn set: " + (start + this.nk) + ":" + (end + this.nk) + ":" + this.cn.length + ":" + input.length);
        }
        double[] output = null;
        if (this.type == 2) {
            output = new double[input.length];
            if (this.dn != null && (start + this.nj < 0 || end + this.nj + this.dn.length > output.length)) {
                throw new IllegalArgumentException("Cannot filter dn set: " + (start + this.nj) + ":" + (end + this.nj) + ":" + this.dn.length + ":" + output.length);
            }
            System.arraycopy(input, 0, output, 0, input.length);
        }
        if (start > end) {
            throw new IllegalArgumentException("Cannot filter cn set: " + start + ">" + end);
        }
        double[] ret = new double[end - start + 1];
        double maxoff = 0.0;
        do {
            int i1;
            for (i1 = 0; i1 < ret.length; ++i1) {
                ret[i1] = this.smoothAt(input, output, start + i1, start + i1);
            }
            if (this.type != 2 || this.dn.length <= -this.nj) {
                return ret;
            }
            for (i1 = 0; i1 < ret.length; ++i1) {
                if (Math.abs(output[i1 + start] - ret[i1]) / Math.max(1.0, Math.abs(output[i1 + start] + ret[i1])) > maxoff) {
                    maxoff = Math.abs(output[i1 + start] - ret[i1]) / Math.max(1.0, Math.abs(output[i1 + start] + ret[i1]));
                }
                output[i1 + start] = ret[i1];
            }
        } while (maxoff >= 1.0E-5);
        return ret;
    }

    public double[] smoothAll(double[] input) {
        double[] a = this.smoothAll(input, -this.nk, input.length + this.nk - 1);
        double[] output = (double[])input.clone();
        System.arraycopy(a, 0, output, -this.nk, a.length);
        return output;
    }
}

