/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.BoundingBox;
import ru.sscc.util.data.DoubleIVecVector;
import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.RealVectors;

public final class DoubleIRefVectors
extends RealVectors {
    double[] vectors;
    int[] ref;

    public DoubleIRefVectors(double[] dArray, int[] nArray, int n) {
        this(dArray, nArray, n, nArray.length);
    }

    public DoubleIRefVectors(double[] dArray, int[] nArray, int n, int n2) {
        super(n, n2);
        this.vectors = dArray;
        this.ref = nArray;
    }

    public double add(int n, int n2, double d) {
        int n3 = this.pos(this.ref[n]) + n2;
        double d2 = this.vectors[n3] + d;
        this.vectors[n3] = d2;
        return d2;
    }

    public void assign(RealPointer realPointer, int n) {
        RealMath.assign(realPointer, this.vectors, this.pos(this.ref[n]), 1, this.dimension);
    }

    public BoundingBox boundingBox() {
        BoundingBox boundingBox = new BoundingBox(this.dimension);
        int n = 0;
        while (n < this.size) {
            boundingBox.enlargeBy(this.vectors, this.pos(this.ref[n]));
            ++n;
        }
        return boundingBox;
    }

    public double get(int n, int n2) {
        return this.vectors[this.pos(this.ref[n]) + n2];
    }

    public RealVector getComponent(int n) {
        return new DoubleIVecVector(this.vectors, this.ref, this.size, n, this.dimension);
    }

    public RealPointer getPointer(int n) {
        return new DoublePointer(this.vectors, this.pos(this.ref[n]), 1);
    }

    public RealVector getVector(int n) {
        return new DoubleVector(this.vectors, this.dimension, this.pos(this.ref[n]), 1);
    }

    public boolean inBox(int n, BoundingBox boundingBox) {
        return boundingBox.contains(this.vectors, this.pos(this.ref[n]));
    }

    public double mul(int n, int n2, double d) {
        int n3 = this.pos(this.ref[n]) + n2;
        double d2 = this.vectors[n3] * d;
        this.vectors[n3] = d2;
        return d2;
    }

    public int offset(int n) {
        return this.pos(this.ref[n]);
    }

    public double set(int n, int n2, double d) {
        double d2 = d;
        this.vectors[this.pos((int)this.ref[n]) + n2] = d2;
        return d2;
    }

    public double squaredDistance(int n, RealPointer realPointer) {
        return RealMath.squaredDistance(realPointer, this.vectors, this.pos(this.ref[n]), this.dimension);
    }
}

