/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.FloatPointer;
import ru.sscc.util.data.RealPointer;

public class RealMath {
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final float FLT_EPSILON = 1.1920929E-7f;

    private RealMath() {
    }

    public static void addVector(RealPointer realPointer, RealPointer realPointer2, double d, int n) {
        if (realPointer instanceof DoublePointer && realPointer2 instanceof DoublePointer) {
            RealMath.addVector(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, ((DoublePointer)realPointer2).data, realPointer2.index, realPointer2.step, d, n);
            return;
        }
        if (realPointer instanceof FloatPointer && realPointer2 instanceof FloatPointer) {
            RealMath.addVector(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, ((FloatPointer)realPointer2).data, realPointer2.index, realPointer2.step, d, n);
            return;
        }
        if (n <= 0) {
            return;
        }
        if (realPointer.equals(realPointer2)) {
            realPointer2 = (RealPointer)realPointer2.clone();
        }
        int n2 = 0;
        while (n2 < n) {
            realPointer.add(d * realPointer2.get());
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
    }

    public static void addVector(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, double d, int n5) {
        while (n5-- > 0) {
            int n6 = n;
            dArray[n6] = dArray[n6] + d * dArray2[n3];
            n += n2;
            n3 += n4;
        }
    }

    public static void addVector(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, double d, int n5) {
        while (n5-- > 0) {
            int n6 = n;
            fArray[n6] = fArray[n6] + (float)(d * (double)fArray2[n3]);
            n += n2;
            n3 += n4;
        }
    }

    public static void assign(RealPointer realPointer, double d, int n) {
        if (realPointer instanceof DoublePointer) {
            RealMath.assign(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, d, n);
            return;
        }
        if (realPointer instanceof FloatPointer) {
            RealMath.assign(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, d, n);
            return;
        }
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            realPointer.set(d);
            ++n2;
            realPointer.next();
        }
        realPointer.shift(-n);
    }

    public static void assign(RealPointer realPointer, RealPointer realPointer2, double d, int n) {
        if (n <= 0) {
            return;
        }
        if (realPointer.equals(realPointer2)) {
            realPointer2 = (RealPointer)realPointer2.clone();
        }
        int n2 = 0;
        while (n2 < n) {
            realPointer.set(realPointer2.get() * d);
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
    }

    public static void assign(RealPointer realPointer, RealPointer realPointer2, int n) {
        if (realPointer.equals(realPointer2)) {
            return;
        }
        if (realPointer instanceof DoublePointer && realPointer2 instanceof DoublePointer) {
            RealMath.assign(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, ((DoublePointer)realPointer2).data, realPointer2.index, realPointer2.step, n);
            return;
        }
        if (realPointer instanceof FloatPointer && realPointer2 instanceof FloatPointer) {
            RealMath.assign(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, ((FloatPointer)realPointer2).data, realPointer2.index, realPointer2.step, n);
            return;
        }
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            realPointer.set(realPointer2.get());
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
    }

    public static void assign(RealPointer realPointer, double[] dArray, int n, int n2, int n3) {
        if (realPointer instanceof DoublePointer) {
            RealMath.assign(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, dArray, n, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            realPointer.set(dArray[n]);
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
    }

    public static void assign(RealPointer realPointer, float[] fArray, int n, int n2, int n3) {
        if (realPointer instanceof FloatPointer) {
            RealMath.assign(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, fArray, n, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            realPointer.set(fArray[n]);
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
    }

    public static void assign(double[] dArray, int n, int n2, double d, int n3) {
        while (n3-- > 0) {
            dArray[n] = d;
            n += n2;
        }
    }

    public static void assign(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, int n5) {
        while (n5-- > 0) {
            dArray[n] = dArray2[n3];
            n += n2;
            n3 += n4;
        }
    }

    public static void assign(float[] fArray, int n, int n2, double d, int n3) {
        while (n3-- > 0) {
            fArray[n] = (float)d;
            n += n2;
        }
    }

    public static void assign(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, int n5) {
        while (n5-- > 0) {
            fArray[n] = fArray2[n3];
            n += n2;
            n3 += n4;
        }
    }

    public static double factorial(int n) {
        double d = 1.0;
        int n2 = 2;
        while (n2 <= n) {
            d *= (double)n2++;
        }
        return d;
    }

    public static int indexOfNormMax(RealPointer realPointer, int n) {
        if (realPointer instanceof DoublePointer) {
            return RealMath.indexOfNormMax(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, n);
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.indexOfNormMax(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, n);
        }
        if (n <= 0) {
            return -1;
        }
        double d = -1.0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            double d2 = Math.abs(realPointer.get());
            if (d < d2) {
                d = d2;
                n2 = n3;
            }
            ++n3;
            realPointer.next();
        }
        realPointer.shift(-n);
        return n2;
    }

    public static int indexOfNormMax(double[] dArray, int n, int n2, int n3) {
        double d = -1.0;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            double d2 = Math.abs(dArray[n]);
            if (d < d2) {
                d = d2;
                n4 = n5;
            }
            ++n5;
            n += n2;
        }
        return n4;
    }

    public static int indexOfNormMax(float[] fArray, int n, int n2, int n3) {
        double d = -1.0;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            double d2 = Math.abs(fArray[n]);
            if (d < d2) {
                d = d2;
                n4 = n5;
            }
            ++n5;
            n += n2;
        }
        return n4;
    }

    public static double innerProduct(RealPointer realPointer, RealPointer realPointer2, int n) {
        if (realPointer instanceof DoublePointer && realPointer2 instanceof DoublePointer) {
            return RealMath.innerProduct(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, ((DoublePointer)realPointer2).data, realPointer2.index, realPointer2.step, n);
        }
        if (realPointer instanceof FloatPointer && realPointer2 instanceof FloatPointer) {
            return RealMath.innerProduct(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, ((FloatPointer)realPointer2).data, realPointer2.index, realPointer2.step, n);
        }
        if (n <= 0) {
            return 0.0;
        }
        if (realPointer.equals(realPointer2)) {
            realPointer2 = (RealPointer)realPointer2.clone();
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += realPointer.get() * realPointer2.get();
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
        return d;
    }

    public static double innerProduct(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, int n5) {
        double d = 0.0;
        while (n5-- > 0) {
            d += dArray[n] * dArray2[n3];
            n += n2;
            n3 += n4;
        }
        return d;
    }

    public static double innerProduct(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, int n5) {
        double d = 0.0;
        while (n5-- > 0) {
            d += (double)fArray[n] * (double)fArray2[n3];
            n += n2;
            n3 += n4;
        }
        return d;
    }

    public static void multiply(RealPointer realPointer, double d, int n) {
        if (realPointer instanceof DoublePointer) {
            RealMath.multiply(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, d, n);
            return;
        }
        if (realPointer instanceof FloatPointer) {
            RealMath.multiply(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, d, n);
            return;
        }
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            realPointer.mul(d);
            ++n2;
            realPointer.next();
        }
        realPointer.shift(-n);
    }

    public static void multiply(double[] dArray, int n, int n2, double d, int n3) {
        while (n3-- > 0) {
            int n4 = n;
            dArray[n4] = dArray[n4] * d;
            n += n2;
        }
    }

    public static void multiply(float[] fArray, int n, int n2, double d, int n3) {
        while (n3-- > 0) {
            int n4 = n;
            fArray[n4] = (float)((double)fArray[n4] * d);
            n += n2;
        }
    }

    public static double norm(RealPointer realPointer, int n) {
        if (realPointer instanceof DoublePointer) {
            return Math.sqrt(RealMath.innerProduct(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, ((DoublePointer)realPointer).data, realPointer.index, realPointer.step, n));
        }
        if (realPointer instanceof FloatPointer) {
            return Math.sqrt(RealMath.innerProduct(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, ((FloatPointer)realPointer).data, realPointer.index, realPointer.step, n));
        }
        if (n <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = realPointer.get();
            d += d2 * d2;
            ++n2;
            realPointer.next();
        }
        realPointer.shift(-n);
        return Math.sqrt(d);
    }

    public static double normMax(RealPointer realPointer, int n) {
        if (realPointer instanceof DoublePointer) {
            return RealMath.normMax(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, n);
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.normMax(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, n);
        }
        if (n <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = Math.abs(realPointer.get());
            if (d < d2) {
                d = d2;
            }
            ++n2;
            realPointer.next();
        }
        realPointer.shift(-n);
        return d;
    }

    public static double normMax(double[] dArray, int n, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            double d2 = Math.abs(dArray[n]);
            if (d < d2) {
                d = d2;
            }
            n += n2;
        }
        return d;
    }

    public static double normMax(float[] fArray, int n, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            double d2 = Math.abs(fArray[n]);
            if (d < d2) {
                d = d2;
            }
            n += n2;
        }
        return d;
    }

    public static double normSum(RealPointer realPointer, int n) {
        if (realPointer instanceof DoublePointer) {
            return RealMath.normSum(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, n);
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.normSum(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, n);
        }
        if (n <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += Math.abs(realPointer.get());
            ++n2;
            realPointer.next();
        }
        realPointer.shift(-n);
        return d;
    }

    public static double normSum(double[] dArray, int n, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            d += Math.abs(dArray[n]);
            n += n2;
        }
        return d;
    }

    public static double normSum(float[] fArray, int n, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            d += (double)Math.abs(fArray[n]);
            n += n2;
        }
        return d;
    }

    public static double polynomial(RealPointer realPointer, double d, int n) {
        if (realPointer instanceof DoublePointer) {
            return RealMath.polynomial(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, d, n);
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.polynomial(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, d, n);
        }
        if (n < 0) {
            return 0.0;
        }
        double d2 = realPointer.shift(n).get();
        while (n-- > 0) {
            d2 = d2 * d + realPointer.previous().get();
        }
        return d2;
    }

    public static double polynomial(double[] dArray, int n, int n2, double d, int n3) {
        if (n3 < 0) {
            return 0.0;
        }
        double d2 = dArray[n += n2 * n3];
        while (n3-- > 0) {
            d2 = d2 * d + dArray[n -= n2];
        }
        return d2;
    }

    public static double polynomial(float[] fArray, int n, int n2, double d, int n3) {
        if (n3 < 0) {
            return 0.0;
        }
        double d2 = fArray[n += n2 * n3];
        while (n3-- > 0) {
            d2 = d2 * d + (double)fArray[n -= n2];
        }
        return d2;
    }

    public static double power(double d, int n) {
        if (n < 0) {
            d = 1.0 / d;
            n = -n;
        }
        double d2 = 1.0;
        while (true) {
            if ((n & 1) != 0) {
                d2 *= d;
            }
            if ((n >>= 1) == 0) {
                return d2;
            }
            d *= d;
        }
    }

    public static double squaredDistance(RealPointer realPointer, RealPointer realPointer2, int n) {
        if (n <= 0 || realPointer.equals(realPointer2)) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = realPointer.get() - realPointer2.get();
            d += d2 * d2;
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
        return d;
    }

    public static double squaredDistance(RealPointer realPointer, double[] dArray, int n, int n2) {
        if (realPointer.step == 1) {
            if (realPointer instanceof DoublePointer) {
                return RealMath.squaredDistance(((DoublePointer)realPointer).data, realPointer.index, dArray, n, n2);
            }
            if (realPointer instanceof FloatPointer) {
                return RealMath.squaredDistance(dArray, n, ((FloatPointer)realPointer).data, realPointer.index, n2);
            }
        }
        if (n2 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray[n] - realPointer.get();
            d += d2 * d2;
            ++n3;
            ++n;
            realPointer.next();
        }
        realPointer.shift(-n2);
        return d;
    }

    public static double squaredDistance(RealPointer realPointer, float[] fArray, int n, int n2) {
        if (realPointer.step == 1) {
            if (realPointer instanceof FloatPointer) {
                return RealMath.squaredDistance(((FloatPointer)realPointer).data, realPointer.index, fArray, n, n2);
            }
            if (realPointer instanceof DoublePointer) {
                return RealMath.squaredDistance(((DoublePointer)realPointer).data, realPointer.index, fArray, n, n2);
            }
        }
        if (n2 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = (double)fArray[n] - realPointer.get();
            d += d2 * d2;
            ++n3;
            ++n;
            realPointer.next();
        }
        realPointer.shift(-n2);
        return d;
    }

    public static double squaredDistance(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            double d2 = dArray[n++] - dArray2[n2++];
            d += d2 * d2;
        }
        return d;
    }

    public static double squaredDistance(double[] dArray, int n, float[] fArray, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            double d2 = dArray[n++] - (double)fArray[n2++];
            d += d2 * d2;
        }
        return d;
    }

    public static double squaredDistance(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        double d = 0.0;
        while (n3-- > 0) {
            double d2 = (double)fArray[n++] - (double)fArray2[n2++];
            d += d2 * d2;
        }
        return d;
    }

    public static void swap(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, int n5) {
        while (n5-- > 0) {
            double d = dArray[n];
            dArray[n] = dArray2[n3];
            dArray2[n3] = d;
            n += n2;
            n3 += n4;
        }
    }

    public static void swap(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, int n5) {
        while (n5-- > 0) {
            float f = fArray[n];
            fArray[n] = fArray2[n3];
            fArray2[n3] = f;
            n += n2;
            n3 += n4;
        }
    }

    public static double weightedNorm(RealPointer realPointer, RealPointer realPointer2, int n) {
        if (realPointer2 == null) {
            return RealMath.norm(realPointer, n);
        }
        if (realPointer instanceof DoublePointer) {
            return Math.sqrt(RealMath.weightedProduct(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, ((DoublePointer)realPointer).data, realPointer.index, realPointer.step, realPointer2, n));
        }
        if (realPointer instanceof FloatPointer) {
            return Math.sqrt(RealMath.weightedProduct(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, ((FloatPointer)realPointer).data, realPointer.index, realPointer.step, realPointer2, n));
        }
        if (n <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = realPointer.get();
            d += d2 * realPointer2.get() * d2;
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
        return Math.sqrt(d);
    }

    public static double weightedNormMax(RealPointer realPointer, RealPointer realPointer2, int n) {
        if (realPointer2 == null) {
            return RealMath.normMax(realPointer, n);
        }
        if (realPointer instanceof DoublePointer) {
            return RealMath.weightedNormMax(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, realPointer2, n);
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.weightedNormMax(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, realPointer2, n);
        }
        if (n <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = Math.abs(realPointer.get() * realPointer2.get());
            if (d < d2) {
                d = d2;
            }
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
        return d;
    }

    public static double weightedNormMax(double[] dArray, int n, int n2, RealPointer realPointer, int n3) {
        if (realPointer == null) {
            return RealMath.normMax(dArray, n, n2, n3);
        }
        if (n3 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            double d2 = Math.abs(dArray[n] * realPointer.get());
            if (d < d2) {
                d = d2;
            }
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
        return d;
    }

    public static double weightedNormMax(float[] fArray, int n, int n2, RealPointer realPointer, int n3) {
        if (realPointer == null) {
            return RealMath.normMax(fArray, n, n2, n3);
        }
        if (n3 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            double d2 = Math.abs((double)fArray[n] * realPointer.get());
            if (d < d2) {
                d = d2;
            }
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
        return d;
    }

    public static double weightedNormSum(RealPointer realPointer, RealPointer realPointer2, int n) {
        if (realPointer2 == null) {
            return RealMath.normSum(realPointer, n);
        }
        if (realPointer instanceof DoublePointer) {
            return RealMath.weightedNormSum(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, realPointer2, n);
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.weightedNormSum(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, realPointer2, n);
        }
        if (n <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += Math.abs(realPointer.get() * realPointer2.get());
            ++n2;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
        return d;
    }

    public static double weightedNormSum(double[] dArray, int n, int n2, RealPointer realPointer, int n3) {
        if (realPointer == null) {
            return RealMath.normSum(dArray, n, n2, n3);
        }
        if (n3 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            d += Math.abs(dArray[n] * realPointer.get());
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
        return d;
    }

    public static double weightedNormSum(float[] fArray, int n, int n2, RealPointer realPointer, int n3) {
        if (realPointer == null) {
            return RealMath.normSum(fArray, n, n2, n3);
        }
        if (n3 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            d += Math.abs((double)fArray[n] * realPointer.get());
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
        return d;
    }

    public static double weightedProduct(RealPointer realPointer, RealPointer realPointer2, RealPointer realPointer3, int n) {
        if (realPointer3 == null) {
            return RealMath.innerProduct(realPointer, realPointer2, n);
        }
        if (realPointer instanceof DoublePointer && realPointer2 instanceof DoublePointer) {
            return RealMath.weightedProduct(((DoublePointer)realPointer).data, realPointer.index, realPointer.step, ((DoublePointer)realPointer2).data, realPointer2.index, realPointer2.step, realPointer3, n);
        }
        if (realPointer instanceof FloatPointer && realPointer2 instanceof FloatPointer) {
            return RealMath.weightedProduct(((FloatPointer)realPointer).data, realPointer.index, realPointer.step, ((FloatPointer)realPointer2).data, realPointer2.index, realPointer2.step, realPointer3, n);
        }
        if (n <= 0) {
            return 0.0;
        }
        if (realPointer.equals(realPointer2)) {
            realPointer2 = (RealPointer)realPointer2.clone();
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += realPointer.get() * realPointer3.get() * realPointer2.get();
            ++n2;
            realPointer.next();
            realPointer2.next();
            realPointer3.next();
        }
        realPointer.shift(-n);
        realPointer2.shift(-n);
        realPointer3.shift(-n);
        return d;
    }

    public static double weightedProduct(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, RealPointer realPointer, int n5) {
        if (realPointer == null) {
            return RealMath.innerProduct(dArray, n, n2, dArray2, n3, n4, n5);
        }
        if (n5 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n6 = 0;
        while (n6 < n5) {
            d += dArray[n] * realPointer.get() * dArray2[n3];
            ++n6;
            n += n2;
            n3 += n4;
            realPointer.next();
        }
        realPointer.shift(-n5);
        return d;
    }

    public static double weightedProduct(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, RealPointer realPointer, int n5) {
        if (realPointer == null) {
            return RealMath.innerProduct(fArray, n, n2, fArray2, n3, n4, n5);
        }
        if (n5 <= 0) {
            return 0.0;
        }
        double d = 0.0;
        int n6 = 0;
        while (n6 < n5) {
            d += (double)fArray[n] * realPointer.get() * (double)fArray2[n3];
            ++n6;
            n += n2;
            n3 += n4;
            realPointer.next();
        }
        realPointer.shift(-n5);
        return d;
    }
}

