/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import ch.qos.logback.classic.Level;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.nyet.ecuxplot.AboutPanel;
import org.nyet.ecuxplot.AxisMenu;
import org.nyet.ecuxplot.ConstantsEditor;
import org.nyet.ecuxplot.DebugLogWindow;
import org.nyet.ecuxplot.ECUxChartFactory;
import org.nyet.ecuxplot.ECUxChartPanel;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.ECUxPreset;
import org.nyet.ecuxplot.Env;
import org.nyet.ecuxplot.FATS;
import org.nyet.ecuxplot.FATSChartFrame;
import org.nyet.ecuxplot.FileMenu;
import org.nyet.ecuxplot.Filter;
import org.nyet.ecuxplot.FilterDebugPanel;
import org.nyet.ecuxplot.FilterEditor;
import org.nyet.ecuxplot.FuelingEditor;
import org.nyet.ecuxplot.HelpMenu;
import org.nyet.ecuxplot.MessageDialog;
import org.nyet.ecuxplot.OptionsMenu;
import org.nyet.ecuxplot.PIDEditor;
import org.nyet.ecuxplot.ProfileMenu;
import org.nyet.ecuxplot.SAEEditor;
import org.nyet.logfile.Dataset;
import org.nyet.util.FileDropHost;
import org.nyet.util.FileDropListener;
import org.nyet.util.Files;
import org.nyet.util.GenericFileFilter;
import org.nyet.util.Strings;
import org.nyet.util.SubActionListener;
import org.nyet.util.WaitCursor;
import org.nyet.util.WindowUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECUxPlot
extends ApplicationFrame
implements SubActionListener,
FileDropHost,
OpenFilesHandler,
QuitHandler {
    private static final Logger logger = LoggerFactory.getLogger(ECUxPlot.class);
    TreeMap<String, ECUxDataset> fileDatasets = new TreeMap();
    private static final long serialVersionUID = 1L;
    private ArrayList<String> files = new ArrayList();
    FATSChartFrame fatsFrame;
    private ECUxChartPanel chartPanel;
    private DebugLogWindow debugLogWindow;
    private FilterDebugPanel filterDebugPanel;
    private final JMenuBar menuBar;
    private AxisMenu xAxis;
    private AxisMenu[] yAxis = new AxisMenu[2];
    OptionsMenu optionsMenu;
    private JFileChooser fc;
    private FilterEditor fe;
    private ConstantsEditor ce;
    private PIDEditor pe;
    private FuelingEditor fle;
    private SAEEditor sae;
    final Preferences prefs = ECUxPlot.getPreferences();
    final Env env;
    final Filter filter;
    final FATS fats;
    private Options options = new Options();
    private boolean exitOnClose = true;
    private ArrayList<ECUxPlot> plotlist = null;

    public ECUxPlot(String title, Options o, boolean exitOnClose) {
        this(title, o, null, exitOnClose);
    }

    public ECUxPlot(String title, ArrayList<ECUxPlot> plotlist) {
        this(title, new Options(), plotlist, false);
    }

    public ECUxPlot(String title, Options o, ArrayList<ECUxPlot> plotlist, boolean exitOnClose) {
        super(title);
        logger.info("Initializing ECUxPlot: {}", (Object)title);
        this.options = o;
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.plotlist = plotlist != null ? plotlist : new ArrayList();
        this.plotlist.add(this);
        this.exitOnClose = exitOnClose;
        WindowUtilities.setNativeLookAndFeel();
        this.menuBar = new JMenuBar();
        this.filter = new Filter(this.prefs);
        this.env = new Env(this.prefs);
        this.fats = new FATS(this.prefs);
        URL imageURL = this.getClass().getResource("icons/ECUxPlot2-64.png");
        this.setIconImage(new ImageIcon(imageURL).getImage());
        this.menuBar.add(new FileMenu("File", this));
        this.menuBar.add(new ProfileMenu("Vehicle Profiles", this));
        this.optionsMenu = new OptionsMenu("Options", this);
        this.menuBar.add(this.optionsMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        HelpMenu helpMenu = new HelpMenu("Help", this);
        this.menuBar.add(helpMenu);
        this.setJMenuBar(this.menuBar);
        this.setPreferredSize(o.size != null ? o.size : this.windowSize());
        new FileDropListener(this, (Component)((Object)this));
    }

    public static boolean scatter(Preferences prefs) {
        return prefs.getBoolean("scatter", false);
    }

    private boolean scatter() {
        return ECUxPlot.scatter(this.prefs);
    }

    private boolean showFATS() {
        return this.prefs.getBoolean("showfats", false);
    }

    private Comparable<?> xkey() {
        String defaultXkey = "RPM";
        return this.prefs.get("xkey", "RPM");
    }

    private Comparable<?>[] ykeys(int index) {
        Object[] defaultYkeys0 = new String[]{"WHP", "WTQ", "HP", "TQ"};
        Object[] defaultYkeys1 = new String[]{"BoostPressureDesired (PSI)", "BoostPressureActual (PSI)"};
        String[] defaultYkeys = new String[]{Strings.join(",", defaultYkeys0), Strings.join(",", defaultYkeys1)};
        String k = this.prefs.get("ykeys" + index, defaultYkeys[index]);
        return k.split(",");
    }

    private Dimension windowSize() {
        return new Dimension(this.prefs.getInt("windowWidth", 800), this.prefs.getInt("windowHeight", 600));
    }

    private void prefsPutWindowSize() {
        this.prefs.putInt("windowWidth", this.getWidth());
        this.prefs.putInt("windowHeight", this.getHeight());
    }

    private void prefsPutXkey(Comparable<?> xkey) {
        this.prefs.put("xkey", xkey.toString());
    }

    private void prefsPutYkeys(int axis, Comparable<?>[] ykeys) {
        this.prefs.put("ykeys" + axis, Strings.join(",", ykeys));
    }

    private void prefsPutYkeys(int axis) {
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        DefaultXYDataset dataset = (DefaultXYDataset)plot.getDataset(axis);
        this.prefsPutYkeys(axis, (Comparable<?>[])ECUxChartFactory.getDatasetYkeys(dataset));
    }

    private void addChartYFromPrefs() {
        this.addChartYFromPrefs(0);
        this.addChartYFromPrefs(1);
        this.updatePlotTitleAndYAxisLabels();
    }

    private void addChartYFromPrefs(int axis) {
        this.addChartY(this.ykeys(axis), axis);
    }

    private void fileDatasetsChanged() {
        this.setTitle("ECUxPlot " + Strings.join(", ", this.fileDatasets.keySet()));
        this.updateXAxisLabel();
        this.addChartYFromPrefs();
        TreeSet<Dataset.DatasetId> hset = new TreeSet<Dataset.DatasetId>();
        for (ECUxDataset d : this.fileDatasets.values()) {
            for (Dataset.DatasetId s : d.getIds()) {
                if (s == null) continue;
                hset.add(s);
            }
        }
        Dataset.DatasetId[] ids = hset.toArray(new Dataset.DatasetId[0]);
        if (ids.length <= 0) {
            return;
        }
        if (this.xAxis != null) {
            this.menuBar.remove(this.xAxis);
        }
        if (this.yAxis[0] != null) {
            this.menuBar.remove(this.yAxis[0]);
        }
        if (this.yAxis[1] != null) {
            this.menuBar.remove(this.yAxis[1]);
        }
        this.xAxis = new AxisMenu("X Axis", ids, (SubActionListener)this, true, this.xkey());
        this.menuBar.add((Component)this.xAxis, 3);
        this.yAxis[0] = new AxisMenu("Y Axis", ids, (SubActionListener)this, false, this.ykeys(0));
        this.menuBar.add((Component)this.yAxis[0], 4);
        this.yAxis[1] = new AxisMenu("Y Axis2", ids, (SubActionListener)this, false, this.ykeys(1));
        this.menuBar.add((Component)this.yAxis[1], 5);
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        for (int axis = 0; axis < plot.getDatasetCount(); ++axis) {
            XYDataset pds = plot.getDataset(axis);
            for (int series = 0; series < pds.getSeriesCount(); ++series) {
                Dataset.Key ykey = (Dataset.Key)pds.getSeriesKey(series);
                if (this.fileDatasets.size() == 1) {
                    ykey.hideFilename();
                    continue;
                }
                ykey.showFilename();
            }
        }
        if (this.fatsFrame == null) {
            this.fatsFrame = FATSChartFrame.createFATSChartFrame(this.fileDatasets, this);
            this.fatsFrame.pack();
            URL imageURL = this.getClass().getResource("icons/ECUxPlot2-64.png");
            this.fatsFrame.setIconImage(new ImageIcon(imageURL).getImage());
        } else {
            this.fatsFrame.setDatasets(this.fileDatasets);
        }
        this.chartTitle(this.prefs.get("title", this.chartTitle()));
    }

    public void loadFiles(ArrayList<String> files) {
        WaitCursor.startWaitCursor((JFrame)((Object)this));
        for (String s : files) {
            if (s.length() <= 0) continue;
            this._loadFile(new File(s), false);
        }
        this.fileDatasetsChanged();
        WaitCursor.stopWaitCursor((JFrame)((Object)this));
    }

    @Override
    public void loadFiles(List<File> files) {
        WaitCursor.startWaitCursor((JFrame)((Object)this));
        for (File f : files) {
            this._loadFile(f, false);
        }
        this.fileDatasetsChanged();
        WaitCursor.stopWaitCursor((JFrame)((Object)this));
    }

    @Override
    public void loadFile(File file) {
        this.loadFile(file, false);
    }

    private void loadFile(File file, boolean replace) {
        WaitCursor.startWaitCursor((JFrame)((Object)this));
        this._loadFile(file, replace);
        this.fileDatasetsChanged();
        WaitCursor.stopWaitCursor((JFrame)((Object)this));
    }

    private void _loadFile(File file, boolean replace) {
        try {
            if (replace) {
                this.nuke();
            }
            if (this.chartPanel == null) {
                JFreeChart chart = ECUxChartFactory.create2AxisChart(this.scatter());
                this.chartPanel = new ECUxChartPanel(chart);
                this.setContentPane((Container)((Object)this.chartPanel));
            }
            ECUxDataset data = new ECUxDataset(file.getAbsolutePath(), this.env, this.filter, this.options.verbose);
            this.fileDatasets.put(file.getName(), data);
            this.files.add(file.getAbsolutePath());
        }
        catch (Exception e) {
            MessageDialog.showMessageDialog((Component)((Object)this), e);
            e.printStackTrace();
            return;
        }
    }

    public void setMyVisible(boolean b) {
        super.setVisible(b);
        if (this.fatsFrame == null) {
            return;
        }
        if (b != this.fatsFrame.isShowing() && this.showFATS()) {
            this.fatsFrame.setVisible(b);
        }
    }

    private void nuke() {
        this.fileDatasets = new TreeMap();
        this.files = new ArrayList();
        this.setTitle("ECUxPlot");
        if (this.chartPanel != null) {
            this.chartPanel.setChart(null);
            this.chartPanel.removeAll();
            this.chartPanel = null;
        }
        if (this.fatsFrame != null) {
            this.fatsFrame.clearDataset();
        }
    }

    private String getExportStem() {
        Object stem = null;
        for (ECUxDataset d : this.fileDatasets.values()) {
            String fname = d.getFileId();
            if (stem == null) {
                stem = Files.stem(fname);
                continue;
            }
            stem = (String)stem + "_vs_" + Files.stem(Files.filename(fname));
        }
        if (this.chartPanel == null) {
            return stem;
        }
        return stem;
    }

    public String exportChartStem(String dir) {
        String ret = null;
        if (this.chartPanel != null) {
            String stem = this.getExportStem();
            ret = dir + File.separator + stem;
        }
        return ret;
    }

    private Point newChart() {
        return this.newChart(null, null);
    }

    private Point newChart(String preset, Point where) {
        ECUxPlot plot = new ECUxPlot("ECUxPlot", this.plotlist);
        plot.pack();
        if (where == null) {
            where = this.getLocation();
        }
        where.translate(20, 20);
        plot.setLocation(where);
        if (this.files != null) {
            plot.loadFiles(this.files);
        }
        if (preset != null) {
            plot.loadPreset((Comparable<String>)((Object)preset));
        } else {
            plot.removeAllY();
            plot.updatePlotTitleAndYAxisLabels();
        }
        plot.setMyVisible(true);
        return where;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AbstractButton source = (AbstractButton)event.getSource();
        if (source.getText().equals("Quit")) {
            this.exitApp();
        } else if (source.getText().equals("Export Chart")) {
            if (this.chartPanel == null) {
                MessageDialog.showMessageDialog((Component)((Object)this), "Open a CSV first");
            } else {
                try {
                    this.chartPanel.doSaveAs(this.getExportStem());
                }
                catch (Exception e) {
                    MessageDialog.showMessageDialog((Component)((Object)this), e);
                    e.printStackTrace();
                }
            }
        } else if (source.getText().equals("Export All Charts")) {
            if (this.plotlist == null || this.plotlist.isEmpty()) {
                MessageDialog.showMessageDialog((Component)((Object)this), "No charts to export");
                return;
            }
            boolean ok = false;
            for (ECUxPlot p : this.plotlist) {
                if (p.chartPanel == null) continue;
                ok = true;
                break;
            }
            if (!ok) {
                MessageDialog.showMessageDialog((Component)((Object)this), "No charts to export");
                return;
            }
            String dir = this.prefs.get("exportDir", System.getProperty("user.home"));
            JFileChooser fileChooser = new JFileChooser(dir);
            fileChooser.setFileSelectionMode(1);
            int option = fileChooser.showSaveDialog((Component)((Object)this));
            ArrayList<CallSite> seen = new ArrayList<CallSite>();
            if (option == 0) {
                dir = fileChooser.getSelectedFile().getPath();
                for (ECUxPlot p : this.plotlist) {
                    String stem;
                    if (p == null || (stem = p.exportChartStem(dir)) == null) continue;
                    String fname = stem + "-" + p.chartTitle() + ".png";
                    int i = 1;
                    while (seen.contains(fname)) {
                        fname = stem + "-" + p.chartTitle() + "_" + i + ".png";
                        ++i;
                    }
                    try {
                        p.chartPanel.saveChartAsPNG(fname);
                        seen.add((CallSite)((Object)fname));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog((Component)((Object)this), e);
                        e.printStackTrace();
                    }
                    if (p.fatsFrame == null || !p.fatsFrame.isShowing()) continue;
                    fname = stem + "-FATS.png";
                    i = 1;
                    while (seen.contains(fname)) {
                        fname = stem + "-FATS_" + i + ".png";
                        ++i;
                    }
                    try {
                        p.fatsFrame.saveChartAsPNG(fname);
                        seen.add((CallSite)((Object)fname));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog((Component)((Object)this), e);
                        e.printStackTrace();
                    }
                }
                if (seen.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Nothing exported");
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Exported:\n" + Strings.join("\n", seen));
                }
                this.prefs.put("exportDir", dir);
            }
        } else if (source.getText().equals("Clear Chart")) {
            if (this.menuBar != null) {
                if (this.xAxis != null) {
                    this.menuBar.remove(this.xAxis);
                }
                if (this.yAxis != null) {
                    if (this.yAxis[0] != null) {
                        this.menuBar.remove(this.yAxis[0]);
                    }
                    if (this.yAxis[1] != null) {
                        this.menuBar.remove(this.yAxis[1]);
                    }
                }
            }
            this.xAxis = null;
            this.yAxis = new AxisMenu[2];
            this.nuke();
        } else if (source.getText().equals("Close Chart")) {
            this.plotlist.remove(this);
            this.dispose();
        } else if (source.getText().equals("New Chart")) {
            this.newChart();
        } else if (source.getText().equals("Open File") || source.getText().equals("Add File")) {
            int ret;
            if (this.fc == null) {
                String dir = this.prefs.get("chooserDir", System.getProperty("user.home"));
                this.fc = new JFileChooser(dir);
                this.fc.setFileFilter(new GenericFileFilter("csv", "CSV File"));
            }
            if ((ret = this.fc.showOpenDialog((Component)((Object)this))) == 0) {
                boolean replace = source.getText().equals("Open File");
                WaitCursor.startWaitCursor((JFrame)((Object)this));
                this.loadFile(this.fc.getSelectedFile(), replace);
                this.setMyVisible(true);
                WaitCursor.stopWaitCursor((JFrame)((Object)this));
                this.prefs.put("chooserDir", this.fc.getCurrentDirectory().toString());
            }
        } else if (source.getText().equals("Use alternate column names")) {
            boolean s = source.isSelected();
            this.prefs.putBoolean("altnames", s);
            this.updateXAxisLabel();
            this.updatePlotTitleAndYAxisLabels();
        } else if (source.getText().equals("Scatter plot")) {
            boolean s = source.isSelected();
            this.prefs.putBoolean("scatter", s);
            if (this.chartPanel != null) {
                ECUxChartFactory.setChartStyle(this.chartPanel.getChart(), !s, s);
            }
        } else if (source.getText().equals("Filter data")) {
            this.filter.enabled(source.isSelected());
            this.rebuild();
        } else if (source.getText().equals("Show all ranges")) {
            this.filter.showAllRanges(source.isSelected());
            this.rebuild();
        } else if (source.getText().equals("Next range...")) {
            ++this.filter.currentRange;
            this.rebuild();
        } else if (source.getText().equals("Previous range...")) {
            if (this.filter.currentRange > 0) {
                --this.filter.currentRange;
            }
            this.rebuild();
        } else if (source.getText().equals("Configure filter...")) {
            if (this.fe == null) {
                this.fe = new FilterEditor(this.prefs, this.filter);
            }
            this.fe.showDialog((Component)((Object)this), "Filter");
        } else if (source.getText().equals("Edit constants...")) {
            boolean changesMade;
            if (this.ce == null) {
                this.ce = new ConstantsEditor(this.prefs, this.env.c);
            }
            if ((changesMade = this.ce.showDialog((Component)((Object)this), "Constants")) && this.fatsFrame != null) {
                this.fatsFrame.updateRpmPerMphFromConstants();
            }
        } else if (source.getText().equals("Edit fueling...")) {
            if (this.fle == null) {
                this.fle = new FuelingEditor(this.prefs, this.env.f);
            }
            this.fle.showDialog((Component)((Object)this), "Fueling");
        } else if (source.getText().equals("Edit PID...")) {
            if (this.pe == null) {
                this.pe = new PIDEditor(this.env.pid);
            }
            this.pe.showDialog((Component)((Object)this), "PID");
        } else if (source.getText().equals("Apply SAE")) {
            this.env.sae.enabled(source.isSelected());
            this.rebuild();
            this.updatePlotTitleAndYAxisLabels();
        } else if (source.getText().equals("Edit SAE constants...")) {
            if (this.sae == null) {
                this.sae = new SAEEditor(this.prefs, this.env.sae);
            }
            this.sae.showDialog((Component)((Object)this), "SAE");
        } else if (source.getText().equals("About...")) {
            JOptionPane.showMessageDialog((Component)((Object)this), new AboutPanel(), "About ECUxPlot", -1);
        } else if (source.getText().equals("Show FATS window...")) {
            boolean s = source.isSelected();
            this.prefs.putBoolean("showfats", s);
            if (!s && this.fatsFrame.isShowing()) {
                this.fatsFrame.setVisible(s);
            }
            this.rebuild();
        } else if (source.getText().equals("Show Debug Logs...")) {
            if (this.debugLogWindow == null) {
                this.debugLogWindow = new DebugLogWindow();
            }
            this.debugLogWindow.showWindow();
        } else if (source.getText().equals("Show Filter Debug Panel...")) {
            if (this.filterDebugPanel == null) {
                this.filterDebugPanel = new FilterDebugPanel();
            }
            this.filterDebugPanel.setDatasets(this.fileDatasets);
            this.filterDebugPanel.showWindow();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "unhandled getText=" + source.getText() + ", actionCommand=" + event.getActionCommand());
        }
    }

    private String findUnits(Comparable<?> key) {
        ArrayList<String> units = new ArrayList<String>();
        for (ECUxDataset d : this.fileDatasets.values()) {
            String u = d.units(key);
            if (u == null || u.length() == 0 || units.contains(u)) continue;
            units.add(u);
        }
        return Strings.join(",", units);
    }

    private void chartTitle(String title) {
        this.chartPanel.getChart().setTitle(title);
    }

    private String chartTitle() {
        String ret = this.chartPanel.getChart().getTitle().getText();
        return ret;
    }

    private void updatePlotTitleAndYAxisLabels() {
        if (this.chartPanel != null) {
            this.updatePlotTitleAndYAxisLabels(this.chartPanel.getChart().getXYPlot());
        }
    }

    private void updatePlotTitleAndYAxisLabels(XYPlot plot) {
        ArrayList<String> title = new ArrayList<String>();
        for (int axis = 0; axis < plot.getDatasetCount(); ++axis) {
            ArrayList<String> seriesTitle = new ArrayList<String>();
            ArrayList<String> label = new ArrayList<String>();
            XYDataset dataset = plot.getDataset(axis);
            if (dataset != null) {
                for (int series = 0; series < dataset.getSeriesCount(); ++series) {
                    String l;
                    String s;
                    Comparable key = dataset.getSeriesKey(series);
                    if (key == null) continue;
                    if (key instanceof Dataset.Key) {
                        Dataset.Key k = (Dataset.Key)key;
                        s = this.prefs.getBoolean("altnames", false) ? k.getId2() : k.getString();
                    } else {
                        s = key.toString();
                    }
                    if (!seriesTitle.contains(s)) {
                        seriesTitle.add(s);
                    }
                    if ((l = this.findUnits(key)) == null || l.length() == 0 || label.contains(l)) continue;
                    label.add(l);
                }
            }
            if (seriesTitle.size() > 0) {
                title.add(Strings.join(", ", seriesTitle));
            }
            plot.getRangeAxis(axis).setLabel(Strings.join(",", label));
            plot.getRangeAxis(axis).setVisible(dataset.getSeriesCount() > 0);
        }
        this.chartTitle(Strings.join(" and ", title));
    }

    private void updateXAxisLabel() {
        if (this.chartPanel != null) {
            this.updateXAxisLabel(this.chartPanel.getChart().getXYPlot());
        }
    }

    private void updateXAxisLabel(XYPlot plot) {
        Object label = "";
        for (ECUxDataset data : this.fileDatasets.values()) {
            String units;
            if (data.get(this.xkey()) == null || (units = data.units(this.xkey())) == null) continue;
            label = data.getLabel(this.xkey(), this.prefs.getBoolean("altnames", false));
            if (((String)label).indexOf(units) != -1) break;
            label = (String)label + " (" + units + ")";
            break;
        }
        plot.getDomainAxis().setLabel((String)label);
    }

    private void addDataset(int axis, DefaultXYDataset d, Dataset.Key ykey) {
        ECUxDataset data = null;
        int stroke = 0;
        for (Map.Entry<String, ECUxDataset> e : this.fileDatasets.entrySet()) {
            if (e.getKey().equals(ykey.getFilename())) {
                data = e.getValue();
                break;
            }
            ++stroke;
        }
        if (data == null) {
            return;
        }
        Integer[] series = ECUxChartFactory.addDataset(d, data, this.xkey(), ykey, this.filter);
        ECUxChartFactory.setAxisPaint(this.chartPanel.getChart(), axis, d, ykey, series);
        ECUxChartFactory.setAxisStroke(this.chartPanel.getChart(), axis, d, ykey, series, stroke);
    }

    public void rebuild() {
        if (this.chartPanel == null) {
            return;
        }
        WaitCursor.startWaitCursor((JFrame)((Object)this));
        for (ECUxDataset data : this.fileDatasets.values()) {
            data.buildRanges();
        }
        if (this.fatsFrame != null) {
            this.fatsFrame.setDatasets(this.fileDatasets);
        }
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        for (int axis = 0; axis < plot.getDatasetCount(); ++axis) {
            XYDataset pds = plot.getDataset(axis);
            DefaultXYDataset newdataset = new DefaultXYDataset();
            for (int series = 0; series < pds.getSeriesCount(); ++series) {
                Dataset.Key ykey = (Dataset.Key)pds.getSeriesKey(series);
                this.addDataset(axis, newdataset, ykey);
            }
            plot.setDataset(axis, (XYDataset)newdataset);
        }
        this.updateXAxisLabel(plot);
        WaitCursor.stopWaitCursor((JFrame)((Object)this));
        this.setMyVisible(true);
    }

    private void removeAllY() {
        this.removeAllY(0);
        this.removeAllY(1);
    }

    private void removeAllY(int axis) {
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        ECUxChartFactory.removeDataset((DefaultXYDataset)plot.getDataset(axis));
        this.yAxis[axis].uncheckAll();
    }

    private void editChartY(Comparable<?> ykey, int axis, boolean add) {
        for (ECUxDataset data : this.fileDatasets.values()) {
            this.editChartY(data, ykey, axis, add);
        }
    }

    private void editChartY(ECUxDataset data, Comparable<?> ykey, int axis, boolean add) {
        if (add && !data.exists(ykey)) {
            return;
        }
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        DefaultXYDataset pds = (DefaultXYDataset)plot.getDataset(axis);
        if (add) {
            ECUxDataset eCUxDataset = data;
            Objects.requireNonNull(eCUxDataset);
            Dataset.Key key = new Dataset.Key((Dataset)eCUxDataset, ykey.toString(), (Dataset)data);
            if (this.fileDatasets.size() == 1) {
                key.hideFilename();
            }
            this.addDataset(axis, pds, key);
        } else {
            ECUxChartFactory.removeDataset(pds, ykey);
        }
    }

    private void addChartY(Comparable<?>[] ykey, int axis) {
        for (Comparable<?> k : ykey) {
            this.editChartY(k, axis, true);
        }
    }

    public void saveUndoPreset() {
        if (this.chartPanel == null) {
            return;
        }
        ECUxPreset p = new ECUxPreset((Comparable<?>)((Object)"Undo"), this.xkey(), this.ykeys(0), this.ykeys(1), this.scatter());
        p.tag(this.chartTitle());
    }

    public void savePreset(Comparable<?> name) {
        if (this.chartPanel == null) {
            return;
        }
        new ECUxPreset(name, this.xkey(), this.ykeys(0), this.ykeys(1), this.scatter());
        this.chartTitle((String)((Object)name));
        this.prefs.put("title", (String)((Object)name));
    }

    public void loadPresets(List<String> presets) {
        boolean first = true;
        Point where = null;
        for (String s : presets) {
            if (first) {
                this.loadPreset((Comparable<String>)((Object)s));
                first = false;
                continue;
            }
            where = this.newChart(s, where);
        }
    }

    public void loadPreset(Comparable<String> name) {
        ECUxPreset p = new ECUxPreset(name);
        if (p != null) {
            this.loadPreset(p);
        }
    }

    private void loadPreset(ECUxPreset p) {
        if (this.chartPanel == null) {
            return;
        }
        if (p.xkey() == null) {
            try {
                ECUxPreset.getPreferencesStatic().node(p.name()).removeNode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.printf("Preset '%s' invalid or does not exist\n", p.name());
            return;
        }
        this.removeAllY();
        this.prefsPutXkey(p.xkey());
        this.updateXAxisLabel();
        this.prefsPutYkeys(0, p.ykeys(0));
        this.prefsPutYkeys(1, p.ykeys(1));
        this.addChartYFromPrefs();
        boolean s = p.scatter();
        ECUxChartFactory.setChartStyle(this.chartPanel.getChart(), !s, s);
        this.prefs.putBoolean("scatter", s);
        this.chartTitle(p.tag());
        this.prefs.put("title", p.tag());
        this.xAxis.setSelected(p.xkey());
        this.yAxis[0].setOnlySelected(p.ykeys(0));
        this.yAxis[1].setOnlySelected(p.ykeys(1));
        this.optionsMenu.updateScatterCheckbox();
    }

    @Override
    public void actionPerformed(ActionEvent event, Comparable<?> parentId) {
        AbstractButton source = (AbstractButton)event.getSource();
        if (parentId.equals("X Axis")) {
            this.prefsPutXkey((Comparable<?>)((Object)source.getText()));
            this.rebuild();
        } else if (parentId.equals("Y Axis")) {
            if (source.getText().equals("Remove all")) {
                this.removeAllY(0);
            } else {
                this.editChartY((Comparable<?>)((Object)source.getText()), 0, source.isSelected());
            }
            this.prefsPutYkeys(0);
        } else if (parentId.equals("Y Axis2")) {
            if (source.getText().equals("Remove all")) {
                this.removeAllY(1);
            } else {
                this.editChartY((Comparable<?>)((Object)source.getText()), 1, source.isSelected());
            }
            this.prefsPutYkeys(1);
        }
        this.updatePlotTitleAndYAxisLabels();
        try {
            this.prefs.remove("title");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowClosing(WindowEvent we) {
        if (this.exitOnClose) {
            this.exitApp();
        }
    }

    private void exitApp() {
        this.prefsPutWindowSize();
        this.saveLastLoadedFiles();
        if (this.fatsFrame != null) {
            this.fatsFrame.dispose();
        }
        if (this.debugLogWindow != null) {
            this.debugLogWindow.dispose();
        }
        if (this.filterDebugPanel != null) {
            this.filterDebugPanel.dispose();
        }
        System.exit(0);
    }

    public static final Preferences getPreferences() {
        return Preferences.userNodeForPackage(ECUxPlot.class);
    }

    private void saveLastLoadedFiles() {
        if (this.files != null && !this.files.isEmpty()) {
            this.prefs.putInt("lastFileCount", this.files.size());
            for (int i = 0; i < this.files.size(); ++i) {
                this.prefs.put("lastFile" + i, this.files.get(i));
            }
        } else {
            this.prefs.remove("lastFileCount");
            for (int i = 0; i < 10; ++i) {
                this.prefs.remove("lastFile" + i);
            }
        }
    }

    private static ArrayList<String> loadLastLoadedFiles() {
        Preferences prefs = ECUxPlot.getPreferences();
        int fileCount = prefs.getInt("lastFileCount", 0);
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < fileCount; ++i) {
            String filePath = prefs.get("lastFile" + i, null);
            if (filePath == null || !new File(filePath).exists()) continue;
            files.add(filePath);
        }
        return files;
    }

    public static final String showInputDialog(String message) {
        String ret = JOptionPane.showInputDialog(message);
        if (ret == null || ret.length() == 0) {
            return null;
        }
        if (ret.startsWith(".") || ret.contains(":") || ret.contains(File.separator) || ret.contains("/") || ret.contains("\\")) {
            JOptionPane.showMessageDialog(null, "Invalid name");
            return null;
        }
        return ret;
    }

    @Override
    public void openFiles(OpenFilesEvent e) {
        this.loadFiles(e.getFiles());
    }

    @Override
    public void handleQuitRequestWith(QuitEvent e, QuitResponse r) {
        this.exitApp();
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Desktop dt;
                Options o = new Options(args);
                ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
                ch.qos.logback.classic.Logger ecuxLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.nyet.ecuxplot");
                if (o.verbose > 1) {
                    rootLogger.setLevel(Level.TRACE);
                    ecuxLogger.setLevel(Level.TRACE);
                } else if (o.verbose > 0) {
                    rootLogger.setLevel(Level.DEBUG);
                    ecuxLogger.setLevel(Level.DEBUG);
                } else {
                    rootLogger.setLevel(Level.INFO);
                    ecuxLogger.setLevel(Level.INFO);
                }
                MessageDialog.setNoGui(o.nogui);
                ECUxPlot plot = new ECUxPlot("ECUxPlot", o, true);
                if (o.nogui) {
                    plot.loadFiles(o.files);
                    System.exit(0);
                }
                if ((dt = Desktop.getDesktop()) != null) {
                    if (dt.isSupported(Desktop.Action.APP_OPEN_FILE)) {
                        dt.setOpenFileHandler(plot);
                    }
                    if (dt.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                        dt.setQuitHandler(plot);
                    }
                }
                plot.pack();
                RefineryUtilities.centerFrameOnScreen((Window)((Object)plot));
                if (o.files != null && !o.files.isEmpty()) {
                    plot.loadFiles(o.files);
                } else {
                    ArrayList<String> lastFiles = ECUxPlot.loadLastLoadedFiles();
                    if (!lastFiles.isEmpty()) {
                        ecuxLogger.info("Auto-loading {} files from last session", (Object)lastFiles.size());
                        plot.loadFiles(lastFiles);
                    }
                }
                if (o.preset != null) {
                    plot.loadPreset((Comparable<String>)((Object)o.preset));
                }
                if (o.output != null) {
                    try {
                        plot.pack();
                        plot.chartPanel.saveChartAsPNG(o.output);
                        System.exit(0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                plot.setMyVisible(true);
            }
        });
    }

    public Env getEnv() {
        return this.env;
    }

    private static class Options {
        public String preset = null;
        public File output = null;
        public Dimension size = null;
        public ArrayList<String> files = new ArrayList();
        public int verbose = 0;
        public boolean nogui = false;

        private static void usage() {
            System.out.println("usage:");
            System.out.println("ECUxPlot [-l] [-v[v...]] [--no-gui] [-p Preset] [-o OutputFile] [--width width] [--height height] [LogFiles ... ]");
            System.out.println("         -l          : list presets");
            System.out.println("         -v...       : verbosity level");
            System.out.println("         --no-gui    : just parse file and exit");
            System.out.println("         -h|-?|--help: show usage");
            System.exit(0);
        }

        public Options() {
            this(new String[0]);
        }

        public Options(String[] args) {
            List<String> help = Arrays.asList("h", "?", "-help");
            int width = -1;
            int height = -1;
            Boolean list_presets = false;
            String output = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '-') {
                    String option = args[i].substring(1);
                    if (help.contains(option)) {
                        Options.usage();
                    }
                    if (option.equals("l")) {
                        list_presets = true;
                        continue;
                    }
                    if (option.equals("-no-gui")) {
                        this.nogui = true;
                        continue;
                    }
                    if (option.charAt(0) == 'v') {
                        for (char ch : option.toCharArray()) {
                            if (ch == 'v') {
                                ++this.verbose;
                                continue;
                            }
                            System.out.printf("Unknown option '-%c'\n", Character.valueOf(ch));
                            Options.usage();
                        }
                        continue;
                    }
                    if (i < args.length - 1) {
                        if (option.equals("p")) {
                            this.preset = args[i + 1];
                        } else if (option.equals("o")) {
                            output = args[i + 1];
                        } else if (option.equals("-width")) {
                            width = Integer.valueOf(args[i + 1]);
                        } else if (option.equals("-height")) {
                            height = Integer.valueOf(args[i + 1]);
                        } else {
                            System.out.printf("Unknown option '-%s ...'\n", option);
                            Options.usage();
                        }
                        ++i;
                        continue;
                    }
                    System.out.printf("Unknown option '-%s'\n", option);
                    Options.usage();
                    continue;
                }
                this.files.add(args[i]);
            }
            if (list_presets.booleanValue()) {
                try {
                    for (String s : ECUxPreset.getPresets()) {
                        System.out.println(s);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
            if (output != null) {
                this.output = new File(output);
            }
            if (width > 0 && height > 0) {
                this.size = new Dimension(width, height);
            }
        }
    }
}

