/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDialog {
    private static final Logger logger = LoggerFactory.getLogger(MessageDialog.class);
    private static boolean nogui = false;

    public static void setNoGui(boolean nogui) {
        MessageDialog.nogui = nogui;
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        if (nogui) {
            logger.info("Message: {}", message);
        } else {
            JOptionPane.showMessageDialog(parentComponent, message);
        }
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        if (nogui) {
            String level;
            switch (level = MessageDialog.getLogLevel(messageType)) {
                case "ERROR": {
                    logger.error("{}: {}", (Object)title, message);
                    break;
                }
                case "WARN": {
                    logger.warn("{}: {}", (Object)title, message);
                    break;
                }
                default: {
                    logger.info("{}: {}", (Object)title, message);
                    break;
                }
            }
        } else {
            JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
        }
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        if (nogui) {
            logger.info("Confirm dialog (assuming YES): {} - {}", (Object)title, message);
            return 0;
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static String showInputDialog(Object message) {
        if (nogui) {
            logger.info("Input dialog (no input): {}", message);
            return null;
        }
        return JOptionPane.showInputDialog(message);
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        if (nogui) {
            logger.info("Input dialog (using initial value): {} - {}", message, initialSelectionValue);
            return initialSelectionValue != null ? initialSelectionValue.toString() : null;
        }
        return JOptionPane.showInputDialog(parentComponent, message, initialSelectionValue);
    }

    private static String getLogLevel(int messageType) {
        switch (messageType) {
            case 0: {
                return "ERROR";
            }
            case 2: {
                return "WARN";
            }
            case 3: {
                return "INFO";
            }
        }
        return "INFO";
    }
}

