/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.logfile;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.regex.Pattern;
import org.nyet.util.DoubleArray;
import org.nyet.util.Files;

public class Dataset {
    private DatasetId[] ids;
    private final String fileId;
    private final ArrayList<Column> columns;
    private ArrayList<Range> range_cache = new ArrayList();
    private int rows;
    protected ArrayList<String> lastFilterReasons = new ArrayList();

    public static CSVReader DatasetReader(String filename) throws FileNotFoundException, UnsupportedEncodingException {
        return Dataset.DatasetReader(filename, ',');
    }

    public static CSVReader DatasetReader(String filename, char separator) throws FileNotFoundException, UnsupportedEncodingException {
        return Dataset.DatasetReader(filename, "ISO-8859-1", separator);
    }

    public static CSVReader DatasetReader(String filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        return Dataset.DatasetReader(filename, encoding, ',');
    }

    public static CSVReader DatasetReader(String filename, String encoding, char separator) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        return new CSVReaderBuilder((Reader)reader).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(separator).build()).build();
    }

    public Dataset(String filename, int verbose) throws Exception {
        String[] nextLine;
        this.fileId = Files.filename(filename);
        this.rows = 0;
        this.columns = new ArrayList();
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            this.detectLoggerType(reader);
        }
        reader = Dataset.DatasetReader(filename);
        try {
            this.ParseHeaders((CSVReader)reader, verbose);
        }
        catch (Exception e) {
            reader = Dataset.DatasetReader(filename, ';');
            this.ParseHeaders((CSVReader)reader, verbose);
        }
        for (DatasetId id : this.ids) {
            this.columns.add(new Column(this, (Comparable<?>)((Object)id.id), id.id2, id.unit));
        }
        while ((nextLine = reader.readNext()) != null) {
            if (nextLine.length <= 0) continue;
            boolean gotone = false;
            for (int i = 0; i < nextLine.length; ++i) {
                if (nextLine[i].trim().length() <= 0 || this.columns.size() <= i) continue;
                this.columns.get(i).add(nextLine[i]);
                gotone = true;
            }
            if (!gotone) continue;
            ++this.rows;
        }
        this.buildRanges();
    }

    public ArrayList<Column> getColumns() {
        return this.columns;
    }

    protected void detectLoggerType(BufferedReader reader) throws Exception {
    }

    public void ParseHeaders(CSVReader reader, int verbose) throws Exception {
        String[] line = reader.readNext();
        if (line.length > 0 && line[0].trim().length() > 0) {
            this.ids = new DatasetId[line.length];
            for (int i = 0; i < line.length; ++i) {
                this.ids[i].id = line[i];
            }
        }
    }

    public Column get(int id) {
        return this.columns.get(id);
    }

    public Column get(Key key) {
        Column c = this.get((Comparable<?>)key);
        if (c != null) {
            key.id_cache = c.id;
        }
        return c;
    }

    public Column get(Comparable<?> id) {
        for (Column c : this.columns) {
            if (!id.equals(c.id.id)) continue;
            return c;
        }
        return null;
    }

    public String units(Comparable<?> id) {
        Column c = this.get(id);
        if (c == null) {
            return null;
        }
        return c.getUnits();
    }

    public String id2(Comparable<?> id) {
        Column c = this.get(id);
        if (c == null) {
            return null;
        }
        return c.getId2();
    }

    public String getLabel(Comparable<?> id, boolean altnames) {
        Column c = this.get(id);
        if (c == null) {
            return null;
        }
        return c.getLabel(altnames);
    }

    public boolean exists(Comparable<?> id) {
        if (this.get(id) == null) {
            return false;
        }
        if (this.get(id).data == null) {
            return false;
        }
        return this.get(id).data.size() != 0;
    }

    protected boolean dataValid(int i) {
        return true;
    }

    protected boolean rangeValid(Range r) {
        return true;
    }

    public ArrayList<Range> getRanges() {
        return this.range_cache;
    }

    protected void buildRanges() {
        this.range_cache = new ArrayList();
        Range r = null;
        for (int i = 0; i < this.rows; ++i) {
            boolean end = false;
            if (this.dataValid(i)) {
                if (r == null) {
                    r = new Range(this, i);
                    this.lastFilterReasons = new ArrayList();
                }
                if (i == this.rows - 1) {
                    end = true;
                }
            } else {
                end = true;
            }
            if (r == null || !end) continue;
            r.end = i - 1;
            if (this.rangeValid(r)) {
                this.range_cache.add(r);
            }
            r = null;
        }
    }

    public double[] getData(Key id, Range r) {
        Column c = this.get((Comparable<?>)((Object)id.getString()));
        if (c == null) {
            return null;
        }
        return c.data.toArray(r.start, r.end);
    }

    public double[] getData(Comparable<?> id, Range r) {
        Column c = this.get(id);
        if (c == null) {
            return null;
        }
        return c.data.toArray(r.start, r.end);
    }

    public String getFileId() {
        return this.fileId;
    }

    public DatasetId[] getIds() {
        return this.ids;
    }

    public void setIds(DatasetId[] ids) {
        this.ids = ids;
    }

    public ArrayList<String> getLastFilterReasons() {
        return this.lastFilterReasons;
    }

    public int length() {
        return this.rows;
    }

    public boolean useId2() {
        return false;
    }

    public static class DatasetId
    implements Comparable<Object> {
        public String id;
        public String id2;
        public String unit;
        public Object type;

        @Override
        public int compareTo(Object o) {
            DatasetId id = (DatasetId)o;
            return this.id.compareTo(id.id);
        }

        public String toString() {
            return this.id;
        }

        public DatasetId(String s) {
            this.id = s;
        }

        public DatasetId(String s, String id2, String unit) {
            this.id = s;
            this.id2 = id2;
            this.unit = unit;
        }

        public boolean equals(Comparable<?> o) {
            return this.id.equals(o.toString());
        }
    }

    public class Column {
        private final DatasetId id;
        public DoubleArray data;

        public Column(Dataset this$0, Comparable<?> id, String units) {
            this(this$0, id, null, units, new DoubleArray());
        }

        public Column(Dataset this$0, Comparable<?> id, String units, DoubleArray data) {
            this(this$0, id, null, units, data);
        }

        public Column(Dataset this$0, Comparable<?> id, String id2, String units) {
            this(this$0, id, id2, units, new DoubleArray());
        }

        public Column(Dataset this$0, Comparable<?> id, String id2, String units, DoubleArray data) {
            this.id = new DatasetId(id.toString(), id2, units);
            this.data = data;
        }

        public Column(Dataset this$0, DatasetId id, DoubleArray data) {
            this.id = id;
            this.data = data;
        }

        public void add(String s) {
            Pattern p = Pattern.compile("[^\\p{Print}]");
            s = p.matcher(s).replaceAll("");
            Pattern p1 = Pattern.compile("\\d{2}:\\d{2}:\\d{2}.\\d{1,3}");
            Pattern p2 = Pattern.compile("\\d{2}:\\d{2}:\\d{2}");
            Pattern p3 = Pattern.compile("\\d{2}:\\d{2}.\\d{1,3}");
            SimpleDateFormat fmt = null;
            if (p1.matcher(s).matches()) {
                fmt = new SimpleDateFormat("HH:mm:ss.SSS");
            } else if (p2.matcher(s).matches()) {
                fmt = new SimpleDateFormat("HH:mm:ss");
            } else if (p3.matcher(s).matches()) {
                fmt = new SimpleDateFormat("mm:ss.SSS");
            }
            if (fmt != null) {
                try {
                    Date d = fmt.parse(s);
                    this.data.append(Double.valueOf(d.getTime()) / 1000.0);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.data.append(Double.valueOf(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String getId() {
            if (this.id == null) {
                return null;
            }
            return this.id.id;
        }

        public String getId2() {
            if (this.id == null) {
                return null;
            }
            return this.id.id2;
        }

        public String getUnits() {
            if (this.id == null) {
                return null;
            }
            return this.id.unit;
        }

        public String getLabel(boolean id2) {
            return id2 && this.id.id2 != null ? this.id.id2 : this.id.id;
        }
    }

    public class Key
    implements Comparable<Object> {
        private String fn;
        private final String s;
        private Integer range;
        private final BitSet flags;
        private final Dataset data_cache;
        private DatasetId id_cache;

        public Key(Dataset this$0, Key k, int range, Dataset data) {
            this.fn = k.fn;
            if (this.fn == null) {
                this.fn = data.getFileId();
            }
            this.s = new String(k.s);
            this.range = range;
            this.data_cache = data;
            this.flags = k.flags;
            data.get(this);
        }

        public Key(Dataset this$0, Key k, Dataset data) {
            this(this$0, k, 0, data);
        }

        public Key(Dataset this$0, String s, Dataset data) {
            this.fn = data.getFileId();
            this.s = s;
            this.data_cache = data;
            this.range = 0;
            this.flags = new BitSet(2);
            data.get(this);
        }

        private boolean useId2() {
            return this.data_cache != null && this.data_cache.useId2() && this.id_cache != null && this.id_cache.id2 != null;
        }

        public String toString() {
            Object ret;
            Object object = ret = this.useId2() ? this.id_cache.id2 : this.s;
            if (!this.flags.get(0)) {
                ret = Files.filenameStem(this.fn) + ":" + (String)ret;
            }
            if (!this.flags.get(1)) {
                ret = (String)ret + " " + (this.range + 1);
            }
            return ret;
        }

        public void hideFilename() {
            this.flags.set(0);
        }

        public void showFilename() {
            this.flags.clear(0);
        }

        public void hideRange() {
            this.flags.set(1);
        }

        public void showRange() {
            this.flags.clear(1);
        }

        public String getFilename() {
            return this.fn;
        }

        public String getId2() {
            return this.id_cache != null && this.id_cache.id2 != null ? this.id_cache.id2 : this.s;
        }

        public String getString() {
            return this.s;
        }

        public Integer getRange() {
            return this.range;
        }

        public void setRange(int r) {
            this.range = r;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                int out = this.fn.compareTo(k.fn);
                if (out != 0) {
                    return out;
                }
                out = this.s.compareTo(k.s);
                if (out != 0) {
                    return out;
                }
                return this.range.compareTo(k.range);
            }
            if (o instanceof String) {
                return this.s.compareTo((String)o);
            }
            throw new ClassCastException("Not a Key or a String!");
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Key) {
                Key k = (Key)o;
                if (!this.fn.equals(k.fn)) {
                    return false;
                }
                if (!this.s.equals(k.s)) {
                    return false;
                }
                return this.range.equals(k.range);
            }
            if (o instanceof String) {
                return this.s.equals(o);
            }
            throw new ClassCastException(String.valueOf(o) + ": Not a Key or a String!");
        }
    }

    public class Range {
        public int start;
        public int end;

        public Range(Dataset this$0, int s, int e) {
            this.start = s;
            this.end = e;
        }

        public Range(Dataset this$0, int s) {
            this(this$0, s, s);
        }

        public Range(Dataset this$0) {
            this(this$0, 0, 0);
        }

        public int size() {
            return this.end - this.start + 1;
        }

        public String toString() {
            return String.format("[%d:%d]", this.start, this.end);
        }
    }
}

