/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.nyet.ecuxplot.ECUxPlot;
import org.nyet.util.SpringUtilities;

public class PreferencesEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JDialog dialog;
    private final JButton jbtnOK;
    private boolean ok;
    protected ECUxPlot eplot;
    private final JPanel prefsPanel;
    private final Preferences prefs;

    protected void Process(ActionEvent event) {
        if (this.eplot != null) {
            this.eplot.rebuild();
        }
    }

    private void setDefaults() {
        if (this.prefs != null) {
            try {
                this.prefs.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.eplot != null) {
                this.eplot.rebuild();
            }
            this.updateDialog();
        }
    }

    protected void processPairs(Object o, String[][] pairs) {
        this.processPairs(o, pairs, Integer.TYPE);
    }

    protected void processPairs(Object o, String[][] pairs, Class<?> c) {
        for (String[] pair : pairs) {
            try {
                Method m = o.getClass().getMethod(pair[1], c);
                Method convert = c.getMethod("valueOf", String.class);
                Field fld = this.getClass().getField(pair[1]);
                JTextField f = (JTextField)fld.get(this);
                m.invoke(o, convert.invoke(null, f.getText()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addPairs(String[][] pairs, int[] fieldSizes) {
        for (int i = 0; i < pairs.length; ++i) {
            this.prefsPanel.add(new JLabel(pairs[i][0], 11));
            try {
                Field fld = this.getClass().getField(pairs[i][1]);
                JComponent tf = fieldSizes == null || fieldSizes.length < i + 1 ? new JTextField(10) : (fieldSizes[i] > 0 ? new JTextField(fieldSizes[i]) : new JLabel(""));
                fld.set(this, tf);
                this.prefsPanel.add(tf);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public PreferencesEditor() {
        this((Preferences)null);
    }

    public PreferencesEditor(Preferences prefs) {
        this(prefs, null);
    }

    public PreferencesEditor(Preferences prefs, String[][] pairs) {
        this(prefs, pairs, null);
    }

    public PreferencesEditor(Preferences prefs, String[][] pairs, int[] fieldSizes) {
        this.prefs = prefs;
        this.setLayout(new BorderLayout());
        this.prefsPanel = new JPanel();
        this.prefsPanel.setLayout(new SpringLayout());
        this.add((Component)this.prefsPanel, "Center");
        if (pairs != null) {
            this.addPairs(pairs, fieldSizes);
            SpringUtilities.makeCompactGrid(this.prefsPanel, pairs.length, 2, 6, 6, 6, 6);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jbtnOK = new JButton("OK");
        this.jbtnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesEditor.this.ok = true;
                PreferencesEditor.this.Process(event);
                PreferencesEditor.this.dialog.setVisible(false);
            }
        });
        panel.add(this.jbtnOK);
        panel.add(Box.createHorizontalGlue());
        JButton jbtn = new JButton("Apply");
        jbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesEditor.this.ok = true;
                PreferencesEditor.this.Process(event);
            }
        });
        panel.add(jbtn);
        if (prefs != null) {
            panel.add(Box.createHorizontalGlue());
            jbtn = new JButton("Defaults");
            jbtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PreferencesEditor.this.setDefaults();
                }
            });
            panel.add(jbtn);
        }
        panel.add(Box.createHorizontalGlue());
        jbtn = new JButton("Cancel");
        jbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesEditor.this.ok = false;
                PreferencesEditor.this.dialog.setVisible(false);
            }
        });
        panel.add(jbtn);
        this.add((Component)panel, "South");
    }

    protected void updateDialog() {
    }

    protected void updateDialog(Object o, String[][] pairs) {
        for (String[] pair : pairs) {
            try {
                Field fld = this.getClass().getField(pair[1]);
                JTextField f = (JTextField)fld.get(this);
                Method m = o.getClass().getMethod(pair[1], new Class[0]);
                f.setText(String.valueOf(m.invoke(o, new Object[0])));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean showDialog(Component parent, String title) {
        this.updateDialog();
        this.ok = false;
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            if (owner instanceof ECUxPlot) {
                this.eplot = (ECUxPlot)owner;
            }
            this.dialog = new JDialog(owner);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.jbtnOK);
            this.dialog.pack();
            Point where = owner.getLocation();
            where.translate(20, 20);
            this.dialog.setLocation(where);
            this.dialog.setResizable(true);
            this.dialog.setMinimumSize(new Dimension(300, 200));
        }
        this.dialog.setTitle(title);
        this.dialog.setVisible(true);
        return this.ok;
    }

    public JPanel getPrefsPanel() {
        return this.prefsPanel;
    }
}

