/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util;

import java.io.Serializable;
import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.RealPointer;

public class BoundingBox
implements Serializable,
Cloneable {
    private double[] min = null;
    private double[] max = null;
    private boolean empty = true;
    public final int dimension;

    public BoundingBox(int n) {
        this.dimension = n;
    }

    public Object clone() {
        try {
            BoundingBox boundingBox = (BoundingBox)super.clone();
            if (!this.empty) {
                boundingBox.min = (double[])this.min.clone();
                boundingBox.max = (double[])this.max.clone();
            }
            return boundingBox;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(RealPointer realPointer) {
        if (this.empty) {
            return false;
        }
        boolean bl = true;
        long l = realPointer.save();
        int n = 0;
        while (n < this.dimension) {
            double d = realPointer.get();
            if (d < this.min[n] || d > this.max[n]) {
                bl = false;
                break;
            }
            ++n;
            realPointer.next();
        }
        realPointer.restore(l);
        return bl;
    }

    public boolean contains(double[] dArray, int n) {
        if (this.empty) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.dimension) {
            double d = dArray[n];
            if (d < this.min[n2] || d > this.max[n2]) {
                return false;
            }
            ++n2;
            ++n;
        }
        return true;
    }

    public boolean contains(float[] fArray, int n) {
        if (this.empty) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.dimension) {
            double d = fArray[n];
            if (d < this.min[n2] || d > this.max[n2]) {
                return false;
            }
            ++n2;
            ++n;
        }
        return true;
    }

    public void enlargeBy(RealPointer realPointer) {
        if (this.empty) {
            this.min = new double[this.dimension];
            this.max = new double[this.dimension];
            this.empty = false;
            int n = 0;
            while (n < this.dimension) {
                this.min[n] = this.max[n] = realPointer.get();
                ++n;
                realPointer.next();
            }
            realPointer.shift(-this.dimension);
            return;
        }
        int n = 0;
        while (n < this.dimension) {
            double d = realPointer.get();
            if (d < this.min[n]) {
                this.min[n] = d;
            } else if (d > this.max[n]) {
                this.max[n] = d;
            }
            ++n;
            realPointer.next();
        }
        realPointer.shift(-this.dimension);
    }

    public void enlargeBy(double[] dArray, int n) {
        if (this.empty) {
            this.min = new double[this.dimension];
            this.max = new double[this.dimension];
            this.empty = false;
            int n2 = 0;
            while (n2 < this.dimension) {
                this.min[n2] = this.max[n2] = dArray[n];
                ++n2;
                ++n;
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.dimension) {
            int n4 = n++;
            double d = dArray[n4];
            if (d < this.min[n3]) {
                this.min[n3] = d;
            } else if (d > this.max[n3]) {
                this.max[n3] = d;
            }
            ++n3;
        }
    }

    public void enlargeBy(float[] fArray, int n) {
        if (this.empty) {
            this.min = new double[this.dimension];
            this.max = new double[this.dimension];
            this.empty = false;
            int n2 = 0;
            while (n2 < this.dimension) {
                this.min[n2] = this.max[n2] = (double)fArray[n];
                ++n2;
                ++n;
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.dimension) {
            int n4 = n++;
            double d = fArray[n4];
            if (d < this.min[n3]) {
                this.min[n3] = d;
            } else if (d > this.max[n3]) {
                this.max[n3] = d;
            }
            ++n3;
        }
    }

    public RealPointer getLowerCorner() {
        return this.empty ? null : new DoublePointer(this.min);
    }

    public RealPointer getUpperCorner() {
        return this.empty ? null : new DoublePointer(this.max);
    }

    public final boolean isEmpty() {
        return this.empty;
    }

    public double width(int n) {
        return this.empty ? 0.0 : this.max[n] - this.min[n];
    }
}

