/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVectors;

public final class RealPointers
extends RealPointer {
    RealVectors vectors;
    RealPointer pointer;
    int dimension;
    int position;
    int offset;

    public RealPointers(RealVectors realVectors) {
        super(0, 1);
        this.vectors = realVectors;
        this.pointer = realVectors.getPointer(0);
        this.dimension = realVectors.dimension;
        this.position = 0;
        this.offset = this.pointer.index;
    }

    public double add(double d) {
        if (this.index >= this.dimension) {
            this.selectAfter();
        } else if (this.index < 0) {
            this.selectBefore();
        }
        this.pointer.index = this.offset + this.index;
        return this.pointer.add(d);
    }

    public Object clone() {
        RealPointers realPointers = (RealPointers)super.clone();
        realPointers.pointer = (RealPointer)realPointers.pointer.clone();
        return realPointers;
    }

    public double get() {
        if (this.index >= this.dimension) {
            this.selectAfter();
        } else if (this.index < 0) {
            this.selectBefore();
        }
        this.pointer.index = this.offset + this.index;
        return this.pointer.get();
    }

    public RealVectors getVectors() {
        return this.vectors;
    }

    public double mul(double d) {
        if (this.index >= this.dimension) {
            this.selectAfter();
        } else if (this.index < 0) {
            this.selectBefore();
        }
        this.pointer.index = this.offset + this.index;
        return this.pointer.mul(d);
    }

    public RealPointer reset(int n, int n2) {
        this.index = n;
        this.step = n2;
        this.offset = this.vectors.offset(0);
        this.position = 0;
        return this;
    }

    public void restore(long l) {
        this.reset((int)(l >> 32), (int)l);
    }

    public long save() {
        return (long)(this.index + this.position * this.dimension) << 32 | (long)this.step & 0xFFFFFFFFL;
    }

    public void select(int n) {
        this.index = 0;
        this.step = 1;
        this.offset = this.vectors.offset(n);
        this.position = n;
    }

    private void selectAfter() {
        this.position += this.index / this.dimension;
        this.index %= this.dimension;
        this.offset = this.vectors.offset(this.position);
    }

    private void selectBefore() {
        this.position += (this.index + 1) / this.dimension - 1;
        this.index = (this.index + 1) % this.dimension + this.dimension - 1;
        this.offset = this.vectors.offset(this.position);
    }

    public double set(double d) {
        if (this.index >= this.dimension) {
            this.selectAfter();
        } else if (this.index < 0) {
            this.selectBefore();
        }
        this.pointer.index = this.offset + this.index;
        return this.pointer.set(d);
    }
}

