/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import java.io.Serializable;
import ru.sscc.util.BoundingBox;
import ru.sscc.util.data.DoubleIRefVectors;
import ru.sscc.util.data.DoubleSRefVectors;
import ru.sscc.util.data.DoubleVectors;
import ru.sscc.util.data.FloatIRefVectors;
import ru.sscc.util.data.FloatSRefVectors;
import ru.sscc.util.data.FloatVectors;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealPointers;
import ru.sscc.util.data.RealVector;

public abstract class RealVectors
implements Serializable {
    public final int dimension;
    public final int size;

    protected RealVectors(int n, int n2) {
        this.dimension = n;
        this.size = n2;
    }

    public abstract double add(int var1, int var2, double var3);

    public abstract void assign(RealPointer var1, int var2);

    public abstract BoundingBox boundingBox();

    public static RealVectors by(Object object, int n) {
        return object instanceof double[] ? new DoubleVectors((double[])object, n) : new FloatVectors((float[])object, n);
    }

    public static RealVectors by(Object object, Object object2, int n) {
        return object instanceof double[] ? (object2 instanceof int[] ? new DoubleIRefVectors((double[])object, (int[])object2, n) : new DoubleSRefVectors((double[])object, (short[])object2, n)) : (object2 instanceof int[] ? new FloatIRefVectors((float[])object, (int[])object2, n) : new FloatSRefVectors((float[])object, (short[])object2, n));
    }

    public final void ensureDimension(int n) {
        if (this.dimension < n) {
            throw new IllegalArgumentException("Vectors' dimension is less than " + n);
        }
    }

    public final void ensureSize(int n) {
        if (this.size < n) {
            throw new IllegalArgumentException("Vectors' size is less than " + n);
        }
    }

    public abstract double get(int var1, int var2);

    public abstract RealVector getComponent(int var1);

    public abstract RealPointer getPointer(int var1);

    public final RealPointers getPointers() {
        return new RealPointers(this);
    }

    public abstract RealVector getVector(int var1);

    public abstract boolean inBox(int var1, BoundingBox var2);

    public abstract double mul(int var1, int var2, double var3);

    public abstract int offset(int var1);

    protected final int pos(int n) {
        return n * this.dimension;
    }

    public abstract double set(int var1, int var2, double var3);

    public abstract double squaredDistance(int var1, RealPointer var2);
}

