/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.nyet.ecuxplot.Loggers;
import org.nyet.logfile.Dataset;
import org.nyet.util.MenuListener;
import org.nyet.util.SubActionListener;

public class AxisMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final SubActionListener listener;
    private ButtonGroup buttonGroup = null;
    private final boolean radioButton;
    private final Comparable<?>[] initialChecked;
    private final HashMap<String, AbstractButton> members = new HashMap();
    private final HashMap<String, JMenu> subMenus = new HashMap();
    private int count = 0;
    private int maxItems = 20;
    private AxisMenu more = null;
    private AxisMenu parent = null;

    private void addToSubmenu(String submenu, JComponent item, boolean autoadd) {
        JMenu sub = this.subMenus.get(submenu);
        if (sub == null) {
            sub = new AxisMenu(submenu + "...", this);
            this.subMenus.put(submenu, sub);
            if (autoadd) {
                this.add(sub);
            }
        }
        sub.add(item);
        if (item instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)item;
            this.members.put(b.getText(), b);
        }
    }

    private void addToSubmenu(String submenu, JComponent item) {
        this.addToSubmenu(submenu, item, true);
    }

    private void addToSubmenu(String submenu, String id) {
        AbstractButton item = this.makeMenuItem(id, null);
        this.addToSubmenu(submenu, item);
    }

    private AbstractButton makeMenuItem(String id, String tip) {
        AbstractButton item;
        boolean checked = false;
        for (Comparable<?> element : this.initialChecked) {
            if (!id.equals(element)) continue;
            checked = true;
            break;
        }
        AbstractButton abstractButton = item = this.buttonGroup == null ? new JCheckBox(id, checked) : new JRadioButtonMenuItem(id, checked);
        if (tip != null) {
            item.setToolTipText(tip);
        }
        item.addActionListener(new MenuListener(this.listener, (Comparable<?>)((Object)this.getText())));
        if (this.buttonGroup != null) {
            this.buttonGroup.add(item);
        }
        return item;
    }

    private void addDirect(String id, int index) {
        AbstractButton item = this.makeMenuItem(id, null);
        this.members.put(id, item);
        super.add((Component)item, index);
    }

    @Override
    public JMenuItem add(String id) {
        return this.add(new Dataset.DatasetId(id));
    }

    private JMenuItem add(Dataset.DatasetId dsid) {
        if (this.members.containsKey(dsid.id)) {
            return null;
        }
        String id = dsid.id;
        String tip = dsid.id2;
        String units = dsid.unit;
        AbstractButton item = this.makeMenuItem(id, tip);
        if (id.matches("RPM")) {
            this.add((Component)item, 0);
            this.addDirect("RPM - raw", 1);
            this.addToSubmenu("Calc Power", "WHP");
            this.addToSubmenu("Calc Power", "WTQ");
            this.addToSubmenu("Calc Power", "HP");
            this.addToSubmenu("Calc Power", "TQ");
            this.addToSubmenu("Calc Power", "Drag");
            this.addToSubmenu("Calc Power", new JSeparator());
            this.addToSubmenu("Calc Power", "Calc Velocity");
            this.addToSubmenu("Calc Power", "Acceleration (RPM/s)");
            this.addToSubmenu("Calc Power", "Acceleration - raw (RPM/s)");
            this.addToSubmenu("Calc Power", "Acceleration (m/s^2)");
            this.addToSubmenu("Calc Power", "Acceleration (g)");
        } else if (id.matches("TIME")) {
            this.add((Component)item, 2);
        } else if (id.matches(".*(MAF|Mass *Air|Air *Mass|Mass *Air *Flow).*")) {
            this.addToSubmenu("MAF", item);
            if (id.matches("MassAirFlow")) {
                this.add("MassAirFlow (kg/hr)");
                if (dsid.type == Loggers.LoggerType.LOG_ME7LOGGER) {
                    this.addToSubmenu("Calc MAF", "Sim Load");
                    this.addToSubmenu("Calc MAF", "Sim Load Corrected");
                    this.addToSubmenu("Calc MAF", "Sim MAF");
                }
                this.addToSubmenu("Calc MAF", "MassAirFlow df/dt");
                this.addToSubmenu("Calc MAF", "Turbo Flow");
                this.addToSubmenu("Calc MAF", "Turbo Flow (lb/min)");
                this.addToSubmenu("Calc MAF", new JSeparator());
            }
        } else if (id.matches(".*(AFR|AdaptationPartial|Injection|Fuel|Lambda|TFT|IDC|Injector|Methanol|E85|[LH]PFP|Rail).*")) {
            this.addToSubmenu("Fuel", item);
            if (id.matches("TargetAFRDriverRequest") && (units == null || !units.equals("AFR"))) {
                this.add("TargetAFRDriverRequest (AFR)");
            }
            if (id.matches("AirFuelRatioDesired") && (units == null || !units.equals("AFR"))) {
                this.add("AirFuelRatioDesired (AFR)");
            }
            if (id.matches("AirFuelRatioCurrent")) {
                this.add("AirFuelRatioCurrent (AFR)");
            }
            if (id.matches("AirFuelRatioCurrentBank1")) {
                this.add("AirFuelRatioCurrentBank1 (AFR)");
            }
            if (id.matches("AirFuelRatioCurrentBank2")) {
                this.add("AirFuelRatioCurrentBank2 (AFR)");
            }
            if (id.matches("Lambda")) {
                this.add("Lambda (AFR)");
            }
            if (id.matches("Lambda Bank 1")) {
                this.add("Lambda Bank 1 (AFR)");
            }
            if (id.matches("Lambda Bank 2")) {
                this.add("Lambda Bank 2 (AFR)");
            }
            if (id.matches("FuelInjectorOnTime")) {
                this.add("FuelInjectorDutyCycle");
            }
            if (id.matches("EffInjectionTime")) {
                this.add("EffInjectorDutyCycle");
                this.addToSubmenu("Calc Fuel", "Sim Fuel Mass");
                this.addToSubmenu("Calc Fuel", "Sim AFR");
                this.addToSubmenu("Calc Fuel", "Sim lambda");
                this.addToSubmenu("Calc Fuel", "Sim lambda error");
            }
            if (id.matches("EffInjectionTimeBank2")) {
                this.add("EffInjectorDutyCycleBank2");
            }
        } else if (id.matches("^Zeitronix.*")) {
            if (id.matches("^Zeitronix Boost")) {
                this.add("Zeitronix Boost (PSI)");
                this.addToSubmenu("Calc Boost", "Boost Spool Rate Zeit (RPM)");
            }
            if (id.matches("^Zeitronix AFR")) {
                this.add("Zeitronix AFR (lambda)");
            }
            if (id.matches("^Zeitronix Lambda")) {
                this.add("Zeitronix Lambda (AFR)");
            }
            this.addToSubmenu("Zeitronix", item);
        } else if (id.matches(".*(Load|Torque|ChargeLimit.*Protection).*")) {
            this.addToSubmenu("Load", item);
            if (id.matches("EngineLoad(Requested|Corrected)")) {
                this.addToSubmenu("Calc Boost", "Sim BoostPressureDesired");
                this.addToSubmenu("Calc Boost", "Sim LoadSpecified correction");
            }
        } else if (id.matches(".*([Bb]oost|Wastegate|Charge|WGDC|PSI|Baro|Press|PID|Turbine).*")) {
            this.addToSubmenu("Boost", item);
            if (id.matches("BoostPressureDesired")) {
                if (units == null || !units.equals("PSI")) {
                    this.add("BoostPressureDesired (PSI)");
                }
                this.addToSubmenu("Calc Boost", "BoostDesired PR");
            }
            if (id.matches("BoostPressureActual")) {
                if (units == null || !units.equals("PSI")) {
                    this.add("BoostPressureActual (PSI)");
                }
                this.addToSubmenu("Calc Boost", "BoostActual PR");
                this.addToSubmenu("Calc Boost", "Boost Spool Rate (RPM)");
                this.addToSubmenu("Calc Boost", "Boost Spool Rate (time)");
                this.addToSubmenu("Calc PID", "LDR error");
                this.addToSubmenu("Calc PID", "LDR de/dt");
                this.addToSubmenu("Calc PID", "LDR I e dt");
                this.addToSubmenu("Calc PID", "LDR PID");
            }
            if (id.matches("BoostPressureDesiredDelta")) {
                this.add(new Dataset.DatasetId("BoostPressureDesired", null, units));
            }
        } else if (id.matches(".*(Pedal|Throttle).*")) {
            this.addToSubmenu("Throttle", item);
        } else if (id.matches(".*(Eta|Avg|Adapted)?(Ign|Timing|Angle|Spark|Combustion).*")) {
            this.addToSubmenu("Ignition", item);
            if (id.matches("IgnitionTimingAngleOverall")) {
                this.add("IgnitionTimingAngleOverallDesired");
            }
            AbstractButton titem = this.makeMenuItem(id + " (ms)", tip);
            this.addToSubmenu("TrueTiming", titem, true);
        } else if (id.matches(".*(Cam|NWS|Valve).*")) {
            this.addToSubmenu("VVT", item);
        } else if (id.matches("(Cat|MainCat).*")) {
            this.addToSubmenu("Cats", item);
        } else if (id.matches(".*EGT.*")) {
            this.addToSubmenu("EGT", item);
        } else if (id.matches(".*(Idle|Idling).*")) {
            this.addToSubmenu("Idle", item);
        } else if (id.matches(".*[Kk]nock.*")) {
            this.addToSubmenu("Knock", item);
        } else if (id.matches(".*Misfire.*")) {
            this.addToSubmenu("Misfires", item);
        } else if (id.matches(".*(OXS|O2|ResistanceSensor).*")) {
            this.addToSubmenu("O2 Sensor(s)", item);
        } else if (id.matches("VehicleSpeed")) {
            this.addToSubmenu("Vehicle Speed", item);
            this.addToSubmenu("Vehicle Speed", "VehicleSpeed (MPH)");
        } else if (id.matches("Engine torque")) {
            this.add(item);
            this.add("Engine torque (ft-lb)");
            this.add("Engine HP");
        } else if (id.matches("IntakeAirTemperature")) {
            this.addToSubmenu("Temperature", item);
            this.add("IntakeAirTemperature (C)");
            if (dsid.type == Loggers.LoggerType.LOG_ME7LOGGER) {
                this.addToSubmenu("Calc IAT", "Sim evtmod");
                this.addToSubmenu("Calc IAT", "Sim ftbr");
                this.addToSubmenu("Calc IAT", "Sim BoostIATCorrection");
            }
        } else if (id.matches(".*Temperature.*")) {
            this.addToSubmenu("Temperature", item);
        } else if (id.matches(".*VV.*")) {
            this.addToSubmenu("VVT", item);
        } else if (id.matches("^Log.*")) {
            this.addToSubmenu("EvoScan", item);
        } else if (id.matches("^ME7L.*")) {
            this.addToSubmenu("ME7 Logger", item);
            if (id.matches("ME7L ps_w")) {
                this.addToSubmenu("Calc Boost", "Sim pspvds");
                this.addToSubmenu("Boost", "ps_w error");
            }
        } else {
            this.add(item);
        }
        this.members.put(id, item);
        return null;
    }

    public AxisMenu(String text, Dataset.DatasetId[] ids, SubActionListener listener, boolean radioButton, Comparable<?>[] initialChecked) {
        this(text, ids, listener, radioButton, initialChecked, -1);
    }

    public AxisMenu(String text, Dataset.DatasetId[] ids, SubActionListener listener, boolean radioButton, Comparable<?>[] initialChecked, int maxItems) {
        super(text);
        this.listener = listener;
        this.radioButton = radioButton;
        this.initialChecked = initialChecked;
        if (maxItems > 0) {
            this.maxItems = maxItems;
        }
        if (ids != null) {
            JMenu me7l;
            if (radioButton) {
                this.buttonGroup = new ButtonGroup();
                this.add("Sample");
                this.add(new JSeparator());
            }
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null || ids[i].id.length() <= 0 || this.members.containsKey(ids[i].id)) continue;
                this.add(ids[i]);
            }
            if (!this.members.containsKey("VehicleSpeed (MPH)")) {
                this.addToSubmenu("Vehicle Speed", "VehicleSpeed (MPH)");
            }
            if ((me7l = this.subMenus.get("ME7 Logger")) != null) {
                super.add(new JSeparator());
                super.add(me7l);
            }
            if (this.more != null) {
                super.add(new JSeparator());
                super.add(this.more);
            }
        }
        if (ids != null && !radioButton) {
            super.add(new JSeparator());
            JMenuItem item = new JMenuItem("Remove all");
            super.add(item);
            item.addActionListener(new MenuListener(listener, (Comparable<?>)((Object)this.getText())));
        }
    }

    public AxisMenu(String text, Dataset.DatasetId[] ids, SubActionListener listener, boolean radioButton, Comparable<?> initialChecked) {
        this(text, ids, listener, radioButton, new Comparable[]{initialChecked});
    }

    public AxisMenu(String id, AxisMenu parent) {
        this(id + "...", null, parent.listener, parent.radioButton, parent.initialChecked, parent.maxItems);
        this.parent = parent;
    }

    public Component add(JMenu item) {
        return this.add((Component)item, false);
    }

    @Override
    public Component add(Component item) {
        return this.add(item, false);
    }

    private Component add(Component item, boolean force) {
        if (this.more == null && item instanceof JSeparator) {
            Component c = this.getMenuComponent(this.getMenuComponentCount() - 1);
            if (c == null || c instanceof JSeparator) {
                return null;
            }
            return super.add(item);
        }
        if (force || this.count++ < this.maxItems) {
            return super.add(item);
        }
        if (this.more == null) {
            this.more = new AxisMenu("More...", this);
            if (this.parent != null) {
                this.add(new JSeparator());
                this.add((Component)this.more, true);
            }
        }
        return this.more.add(item);
    }

    public void uncheckAll() {
        for (AbstractButton item : this.members.values()) {
            item.setSelected(false);
        }
    }

    public void setSelected(Comparable<?> key) {
        AbstractButton item = this.members.get(key);
        if (item != null) {
            item.setSelected(true);
        }
    }

    public void setSelected(Comparable<?>[] keys) {
        for (Comparable<?> key : keys) {
            this.setSelected(key);
        }
    }

    public void setOnlySelected(Comparable<?>[] keys) {
        this.setOnlySelected(new HashSet(Arrays.asList(keys)));
    }

    public void setOnlySelected(Set<Comparable<?>> keys) {
        for (String ik : this.members.keySet()) {
            AbstractButton item = this.members.get(ik);
            item.setSelected(keys.contains(ik));
        }
    }
}

