/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import org.slf4j.LoggerFactory;

public class DebugLogWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LOG_LINES = 1000;
    private JTextArea logTextArea;
    private JScrollPane scrollPane;
    private JComboBox<Level> levelFilter;
    private JTextField searchField;
    private JButton clearButton;
    private JButton exportButton;
    private JCheckBox autoScrollCheckBox;
    private LogAppender logAppender;
    private BlockingQueue<String> logQueue;
    private Thread logProcessor;
    private boolean isVisible = false;

    public DebugLogWindow() {
        super("Debug Logs");
        this.setDefaultCloseOperation(1);
        this.setSize(1200, 400);
        this.setLocationRelativeTo(null);
        this.initializeComponents();
        this.setupLayout();
        this.setupLogging();
        this.setupEventHandlers();
        this.startLogProcessor();
    }

    private void initializeComponents() {
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logTextArea.setFont(new Font("Monospaced", 0, 12));
        this.scrollPane = new JScrollPane(this.logTextArea);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        DefaultCaret caret = (DefaultCaret)this.logTextArea.getCaret();
        caret.setUpdatePolicy(2);
        this.levelFilter = new JComboBox<Level>(new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR});
        this.levelFilter.setSelectedItem(Level.DEBUG);
        this.searchField = new JTextField(20);
        this.searchField.setToolTipText("Search log messages");
        this.clearButton = new JButton("Clear");
        this.exportButton = new JButton("Export");
        this.autoScrollCheckBox = new JCheckBox("Auto-scroll", true);
        this.logQueue = new LinkedBlockingQueue<String>();
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(new JLabel("Level:"));
        topPanel.add(this.levelFilter);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(new JLabel("Search:"));
        topPanel.add(this.searchField);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(this.clearButton);
        topPanel.add(this.exportButton);
        topPanel.add(this.autoScrollCheckBox);
        topPanel.add(Box.createHorizontalGlue());
        this.add((Component)topPanel, "North");
        this.add((Component)this.scrollPane, "Center");
    }

    private void setupLogging() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.logAppender = new LogAppender();
        this.logAppender.setContext(context);
        this.logAppender.start();
        Logger ecuxLogger = (Logger)LoggerFactory.getLogger("org.nyet.ecuxplot");
        ecuxLogger.addAppender(this.logAppender);
    }

    private void setupEventHandlers() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DebugLogWindow.this.hideWindow();
            }
        });
        this.clearButton.addActionListener(e -> {
            this.logTextArea.setText("");
            this.logQueue.clear();
        });
        this.exportButton.addActionListener(e -> this.exportLogs());
        this.levelFilter.addActionListener(e -> {});
        this.searchField.addActionListener(e -> {
            String searchText = this.searchField.getText().trim();
            if (!searchText.isEmpty()) {
                this.searchLogs(searchText);
            }
        });
        this.autoScrollCheckBox.addActionListener(e -> {
            DefaultCaret caret = (DefaultCaret)this.logTextArea.getCaret();
            if (this.autoScrollCheckBox.isSelected()) {
                caret.setUpdatePolicy(2);
            } else {
                caret.setUpdatePolicy(1);
            }
        });
    }

    private void startLogProcessor() {
        this.logProcessor = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    String logEntry = this.logQueue.take();
                    SwingUtilities.invokeLater(() -> {
                        if (this.isVisible) {
                            this.appendLogEntry(logEntry);
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        this.logProcessor.setDaemon(true);
        this.logProcessor.start();
    }

    private void appendLogEntry(String logEntry) {
        Level selectedLevel = (Level)this.levelFilter.getSelectedItem();
        String searchText = this.searchField.getText().trim();
        Level entryLevel = this.parseLogLevel(logEntry);
        if (entryLevel != null && entryLevel.levelInt < selectedLevel.levelInt) {
            return;
        }
        if (!searchText.isEmpty() && !logEntry.toLowerCase().contains(searchText.toLowerCase())) {
            return;
        }
        this.logTextArea.append(logEntry);
        String[] lines = this.logTextArea.getText().split("\n");
        if (lines.length > 1000) {
            StringBuilder sb = new StringBuilder();
            for (int i = lines.length - 1000; i < lines.length; ++i) {
                sb.append(lines[i]).append("\n");
            }
            this.logTextArea.setText(sb.toString());
        }
        if (this.autoScrollCheckBox.isSelected()) {
            this.logTextArea.setCaretPosition(this.logTextArea.getDocument().getLength());
        }
    }

    private Level parseLogLevel(String logEntry) {
        if (logEntry.contains(" TRACE ")) {
            return Level.TRACE;
        }
        if (logEntry.contains(" DEBUG ")) {
            return Level.DEBUG;
        }
        if (logEntry.contains(" INFO ")) {
            return Level.INFO;
        }
        if (logEntry.contains(" WARN ")) {
            return Level.WARN;
        }
        if (logEntry.contains(" ERROR ")) {
            return Level.ERROR;
        }
        return null;
    }

    private void searchLogs(String searchText) {
        String content = this.logTextArea.getText();
        int index = content.toLowerCase().indexOf(searchText.toLowerCase());
        if (index >= 0) {
            this.logTextArea.setCaretPosition(index);
            this.logTextArea.getCaret().setSelectionVisible(true);
        }
    }

    private void exportLogs() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File("ecuxplot-debug-" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + ".log"));
        if (fileChooser.showSaveDialog(this) == 0) {
            try (FileWriter writer = new FileWriter(fileChooser.getSelectedFile());){
                writer.write(this.logTextArea.getText());
                JOptionPane.showMessageDialog(this, "Logs exported successfully!", "Export Complete", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Failed to export logs: " + e.getMessage(), "Export Error", 0);
            }
        }
    }

    public void showWindow() {
        this.isVisible = true;
        this.setVisible(true);
        this.toFront();
    }

    public void hideWindow() {
        this.isVisible = false;
        this.setVisible(false);
    }

    public boolean isWindowVisible() {
        return this.isVisible;
    }

    @Override
    public void dispose() {
        if (this.logProcessor != null) {
            this.logProcessor.interrupt();
        }
        if (this.logAppender != null) {
            this.logAppender.stop();
        }
        super.dispose();
    }

    private class LogAppender
    extends AppenderBase<ILoggingEvent> {
        private LogAppender() {
        }

        @Override
        protected void append(ILoggingEvent event) {
            if (!this.isStarted()) {
                return;
            }
            Object formattedMessage = String.format("%s [%s] %-5s %s - %s%n", new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(event.getTimeStamp())), event.getThreadName(), event.getLevel().toString(), event.getLoggerName(), event.getFormattedMessage());
            if (event.getThrowableProxy() != null) {
                formattedMessage = (String)formattedMessage + "Exception: " + event.getThrowableProxy().getMessage() + "\n";
            }
            DebugLogWindow.this.logQueue.offer((String)formattedMessage);
        }
    }
}

