/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import com.opencsv.CSVReader;
import flanagan.interpolation.CubicSpline;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nyet.ecuxplot.Env;
import org.nyet.ecuxplot.Filter;
import org.nyet.ecuxplot.Loggers;
import org.nyet.ecuxplot.Units;
import org.nyet.logfile.Dataset;
import org.nyet.util.DoubleArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECUxDataset
extends Dataset {
    private static final Logger logger = LoggerFactory.getLogger(ECUxDataset.class);
    private final Dataset.Column rpm;
    private Dataset.Column pedal;
    private Dataset.Column throttle;
    private Dataset.Column gear;
    private final Dataset.Column zboost;
    private final Env env;
    private final Filter filter;
    private double time_ticks_per_sec;
    public double samples_per_sec = 0.0;
    private CubicSpline[] splines;
    private Loggers.LoggerType log_detected = Loggers.LoggerType.LOG_UNKNOWN;

    public ECUxDataset(String filename, Env env, Filter filter, int verbose) throws Exception {
        super(filename, verbose);
        Dataset.Column baroPressure;
        this.env = env;
        this.filter = filter;
        this.pedal = this.get((Comparable<?>[])Loggers.pedalnames);
        if (this.pedal != null && this.pedal.data.isZero()) {
            this.pedal = null;
        }
        this.throttle = this.get((Comparable<?>[])Loggers.throttlenames);
        if (this.throttle != null && this.throttle.data.isZero()) {
            this.throttle = null;
        }
        this.gear = this.get((Comparable<?>[])Loggers.gearnames);
        if (this.gear != null && this.gear.data.isZero()) {
            this.gear = null;
        }
        this.zboost = this.get((Comparable<?>)((Object)"Zeitronix Boost"));
        Dataset.Column time = this.get((Comparable<?>)((Object)"TIME"));
        if (time != null) {
            for (int i = 1; i < time.data.size(); ++i) {
                double rate;
                double delta = time.data.get(i) - time.data.get(i - 1);
                if (!(delta > 0.0) || !((rate = 1.0 / delta) > this.samples_per_sec)) continue;
                this.samples_per_sec = rate;
            }
        }
        if ((baroPressure = this.get((Comparable<?>)((Object)"BaroPressure"))) != null && baroPressure.data.size() > 0 && baroPressure.data.get(0) < 600.0) {
            for (Dataset.Column column : this.getColumns()) {
                if (column.getUnits() == null || !column.getUnits().toLowerCase().equals("mbar")) continue;
                for (int i = 1; i < column.data.size(); ++i) {
                    column.data.set(i, column.data.get(i) * 2.0);
                }
            }
        }
        this.rpm = this.get((Comparable<?>)((Object)"RPM"));
        this.buildRanges();
    }

    private int MAW() {
        return (int)Math.floor(this.samples_per_sec / 10.0 * (double)this.filter.HPTQMAW());
    }

    private int AccelMAW() {
        return (int)Math.floor(this.samples_per_sec / 10.0 * (double)this.filter.accelMAW());
    }

    private String[] ParseUnits(String[] h, int verbose) {
        int i;
        String[] u = new String[h.length];
        for (i = 0; i < h.length; ++i) {
            h[i] = h[i].trim();
            Pattern unitsRegEx = Pattern.compile("([\\S\\s]+)\\(([\\S\\s].*)\\)");
            Matcher matcher = unitsRegEx.matcher(h[i]);
            if (!matcher.find()) continue;
            h[i] = matcher.group(1).trim();
            u[i] = matcher.group(2).trim();
        }
        for (i = 0; i < h.length; ++i) {
            logger.trace("pu: '{}' [{}]", (Object)h[i], (Object)u[i]);
        }
        return u;
    }

    public void ParseHeaders(CSVReader reader) throws Exception {
        this.ParseHeaders(reader, Loggers.LoggerType.LOG_DETECT, 0);
    }

    @Override
    public void ParseHeaders(CSVReader reader, int verbose) throws Exception {
        this.ParseHeaders(reader, Loggers.LoggerType.LOG_DETECT, verbose);
    }

    public void ParseHeaders(CSVReader reader, Loggers.LoggerType log_req, int verbose) throws Exception {
        String[] u;
        String[] h;
        String[] v = null;
        do {
            if ((h = reader.readNext()) == null) {
                throw new Exception(this.getFileId() + ": read failed parsing CSV headers");
            }
            for (int i = 0; i < h.length; ++i) {
                logger.debug("h[" + i + "]: " + h[i]);
            }
        } while (h.length < 1 || h[0].trim().length() == 0 || h[0].trim().matches("^#.+"));
        Loggers.DetectResult r = Loggers.detect(h);
        if (r.type != Loggers.LoggerType.LOG_UNKNOWN) {
            logger.info("Detected {} based on \"{}\"", (Object)r.type, (Object)r.message);
        }
        this.log_detected = r.type;
        if (log_req != Loggers.LoggerType.LOG_DETECT && this.log_detected != Loggers.LoggerType.LOG_ERR && log_req != this.log_detected) {
            throw new Exception(String.valueOf((Object)log_req) + "!=" + String.valueOf((Object)this.log_detected));
        }
        Loggers.LoggerType log_use = log_req == Loggers.LoggerType.LOG_DETECT ? this.log_detected : log_req;
        logger.info("Using {}", (Object)log_use);
        this.time_ticks_per_sec = 1.0;
        switch (log_use) {
            case LOG_VCDS: {
                int i;
                String[] e = reader.readNext();
                String[] b = reader.readNext();
                String[] g = reader.readNext();
                h = reader.readNext();
                String[] h2 = reader.readNext();
                u = reader.readNext();
                logger.debug("in e:{}, b:{}, g:{}, h:{}, h2:{}, u:{}", e.length, b.length, g.length, h.length, h2.length, u.length);
                if (g.length <= 1) {
                    g = h;
                    h = h2;
                    h2 = new String[h.length];
                }
                if (g.length < h.length) {
                    String[] newg = new String[h.length];
                    System.arraycopy(g, 0, newg, 0, g.length);
                    g = newg;
                }
                logger.debug("out e:{}, b:{}, g:{}, h:{}, h2:{}, u:{}", e.length, b.length, g.length, h.length, h2.length, u.length);
                for (i = 0; i < h.length; ++i) {
                    g[i] = g[i] != null ? g[i].trim() : "";
                    h[i] = h[i] != null ? h[i].trim() : "";
                    h2[i] = h2[i] != null ? h2[i].trim() : "";
                    u[i] = u[i] != null ? u[i].trim() : "";
                    logger.debug("in {} (g:h:h2:[u]): '{}' '{}' [{}]", i, g[i], h[i], h2[i], u[i]);
                    if (g[i].equals("TIME") && h[i].equals("STAMP")) {
                        g[i] = "";
                        h[i] = "TIME";
                    }
                    if (h2[i].equals(u[i])) {
                        h2[i] = "";
                    }
                    if (h[i].length() > 0 && h2[i].length() > 0) {
                        int n = i;
                        h[n] = h[n] + " ";
                    }
                    int n = i;
                    h[n] = h[n] + h2[i];
                    if (h[i].length() != 0) continue;
                    h[i] = u[i];
                }
                Loggers.processAliases(h, log_use);
                for (i = 0; i < h.length; ++i) {
                    if (g[i].matches("^Group 24.*") && h[i].equals("Accelerator position")) {
                        h[i] = "Accelerator position (G024)";
                    }
                    logger.debug("out {} (g:h:h2:[u]): '{}' '{}' [{}]", i, g[i], h[i], h2[i], u[i]);
                }
                break;
            }
            case LOG_ZEITRONIX: {
                if (this.log_detected == Loggers.LoggerType.LOG_ZEITRONIX) {
                    reader.readNext();
                    do {
                        if ((h = reader.readNext()) != null) continue;
                        throw new Exception(this.getFileId() + ": read failed parsing zeitronix log");
                    } while (h.length <= 1 || h[0].trim().length() == 0);
                }
                u = this.ParseUnits(h, verbose);
                Loggers.processAliases(h, log_use);
                for (int i = 0; i < h.length; ++i) {
                    if (h[i].equals("RPM")) continue;
                    h[i] = "Zeitronix" + h[i];
                }
                break;
            }
            case LOG_ECUX: {
                u = this.ParseUnits(h, verbose);
                this.time_ticks_per_sec = 1000.0;
                Loggers.processAliases(h, log_use);
                break;
            }
            case LOG_EVOSCAN: {
                u = new String[h.length];
                Loggers.processAliases(h, log_use);
                break;
            }
            case LOG_ME7LOGGER: {
                int i;
                do {
                    if ((v = reader.readNext()) != null) continue;
                    throw new Exception(this.getFileId() + ": read failed parsing ME7Logger log variables");
                } while (v.length < 1 || !v[0].equals("TimeStamp"));
                if (v == null || v.length < 1) {
                    throw new Exception(this.getFileId() + ": read failed parsing ME7Logger log variables");
                }
                do {
                    if ((u = reader.readNext()) != null) continue;
                    throw new Exception(this.getFileId() + ": read failed parsing ME7Logger log units");
                } while (u.length < 1 || u[0].trim().length() == 0);
                if (u == null || u.length < 1) {
                    throw new Exception(this.getFileId() + ": read failed parsing ME7Logger log units");
                }
                do {
                    if ((h = reader.readNext()) != null) continue;
                    throw new Exception(this.getFileId() + ": read failed parsing ME7Logger log aliases");
                } while (h.length < 1 || h[0].trim().length() == 0);
                if (h == null || h.length < 1) {
                    throw new Exception(this.getFileId() + ": read failed parsing ME7Logger log aliases");
                }
                for (i = 0; i < v.length; ++i) {
                    v[i] = v[i].trim();
                }
                for (i = 0; i < h.length; ++i) {
                    logger.debug("in: '{}' ({}) [{}]", v[i], h[i], u[i]);
                }
                Loggers.processAliases(h, log_use);
                for (i = 0; i < h.length; ++i) {
                    h[i] = h[i].replace(v[i], "").trim();
                    if (h[i].length() != 0 || v[i].length() <= 0) continue;
                    h[i] = "ME7L " + v[i];
                }
                break;
            }
            case LOG_VOLVOLOGGER: {
                u = new String[h.length];
                v = new String[h.length];
                Pattern unitsRegEx = Pattern.compile("([\\S\\s]+)\\(([\\S\\s]+)\\)\\s*(.*)");
                for (int i = 0; i < h.length; ++i) {
                    h[i] = h[i].trim();
                    Matcher matcher = unitsRegEx.matcher(h[i]);
                    if (!matcher.find()) continue;
                    h[i] = matcher.group(1).trim();
                    u[i] = matcher.group(2).trim();
                    v[i] = matcher.group(3).trim();
                    if (h[i].length() != 0 || v[i].length() <= 0) continue;
                    h[i] = "ME7L " + v[i];
                }
                Loggers.processAliases(h, log_use);
                break;
            }
            case LOG_LOGWORKS: {
                h = reader.readNext();
                u = reader.readNext();
                Loggers.processAliases(h, log_use);
                Pattern unitsRegEx1 = Pattern.compile("\\((.+)\\)");
                for (int i = 0; i < u.length; ++i) {
                    u[i] = u[i].trim();
                    Matcher matcher = unitsRegEx1.matcher(u[i]);
                    if (!matcher.find()) continue;
                    u[i] = matcher.group(1).trim();
                }
                break;
            }
            case LOG_JB4: {
                this.time_ticks_per_sec = 10.0;
                reader.readNext();
                reader.readNext();
                reader.readNext();
                h = reader.readNext();
                for (int i = 0; i < h.length; ++i) {
                    h[i] = h[i].trim();
                }
                v = Arrays.copyOf(h, h.length);
                Loggers.processAliases(h, log_use);
                u = this.ParseUnits(h, verbose);
                break;
            }
            default: {
                u = this.ParseUnits(h, verbose);
                Loggers.processAliases(h, log_use);
            }
        }
        u = Units.processUnits(h, u);
        for (int i = 0; i < h.length; ++i) {
            if (v != null && i < v.length) {
                logger.debug("out: '{}' ({}) [{}]", h[i], v[i], u[i]);
                continue;
            }
            logger.debug("out: '{}' [{}]", (Object)h[i], (Object)u[i]);
        }
        Dataset.DatasetId[] ids = new Dataset.DatasetId[h.length];
        for (int i = 0; i < h.length; ++i) {
            ids[i] = new Dataset.DatasetId(h[i]);
            if (v != null && i < v.length) {
                ids[i].id2 = v[i];
            }
            if (u != null && i < u.length) {
                ids[i].unit = u[i];
            }
            ids[i].type = this.log_detected;
        }
        this.setIds(ids);
    }

    private DoubleArray drag(DoubleArray v) {
        double rho = 1.293;
        DoubleArray windDrag = v.pow(3.0).mult(0.6465 * this.env.c.Cd() * this.env.c.FA());
        DoubleArray rollingDrag = v.mult(this.env.c.rolling_drag() * this.env.c.mass() * 9.80665);
        return windDrag.add(rollingDrag);
    }

    private DoubleArray toPSI(DoubleArray abs) {
        Dataset.Column ambient = this.get((Comparable<?>)((Object)"BaroPressure"));
        if (ambient == null) {
            return abs.add(-1013.25).div(0.0145038);
        }
        return abs.sub(ambient.data).div(0.0145038);
    }

    private static DoubleArray toCelcius(DoubleArray f) {
        return f.add(-32.0).mult(0.5555555555555556);
    }

    private static DoubleArray toFahrenheit(DoubleArray c) {
        return c.mult(1.8).add(32.0);
    }

    public Dataset.Column get(Comparable<?>[] id) {
        for (Comparable<?> k : id) {
            Dataset.Column ret = null;
            try {
                ret = this._get(k);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Dataset.Column get(Comparable<?> id) {
        try {
            return this._get(id);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private Dataset.Column _get(Comparable<?> id) {
        Dataset.Column c;
        block162: {
            c = null;
            if (id.equals("Sample")) {
                double[] idx = new double[this.length()];
                for (int i = 0; i < this.length(); ++i) {
                    idx[i] = i;
                }
                DoubleArray a = new DoubleArray(idx);
                c = new Dataset.Column((Dataset)this, (Comparable<?>)((Object)"Sample"), "#", a);
            } else if (id.equals("TIME")) {
                DoubleArray a = super.get("TIME").data;
                c = new Dataset.Column((Dataset)this, (Comparable<?>)((Object)"TIME"), "s", a.div(this.time_ticks_per_sec));
            } else if (id.equals("RPM")) {
                if (this.samples_per_sec > 10.0) {
                    DoubleArray a = super.get("RPM").data.smooth();
                    c = new Dataset.Column((Dataset)this, id, "RPM", a);
                }
            } else if (id.equals("RPM - raw")) {
                c = new Dataset.Column((Dataset)this, id, "RPM", super.get("RPM").data);
            } else if (id.equals("Sim Load")) {
                DoubleArray a = super.get("MassAirFlow").data.mult(3.6);
                DoubleArray b = super.get("RPM").data.smooth();
                c = new Dataset.Column((Dataset)this, id, "%", a.div(b).div(0.001072));
            } else if (id.equals("Sim Load Corrected")) {
                DoubleArray a = this.get("Sim MAF").data.mult(3.6);
                DoubleArray b = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "%", a.div(b).div(0.001072));
            } else if (id.equals("MassAirFlow (kg/hr)")) {
                DoubleArray maf = super.get("MassAirFlow").data;
                c = new Dataset.Column((Dataset)this, id, "kg/hr", maf.mult(3.6));
            } else if (id.equals("Sim MAF")) {
                DoubleArray a = super.get("MassAirFlow").data.mult(this.env.f.MAF_correction()).add(this.env.f.MAF_offset());
                c = new Dataset.Column((Dataset)this, id, "g/sec", a);
            } else if (id.equals("MassAirFlow df/dt")) {
                DoubleArray maf = super.get("MassAirFlow").data;
                DoubleArray time = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "g/sec^s", maf.derivative(time).max(0.0));
            } else if (id.equals("Turbo Flow")) {
                DoubleArray a = this.get("Sim MAF").data;
                c = new Dataset.Column((Dataset)this, id, "m^3/sec", a.div(1225 * this.env.f.turbos()));
            } else if (id.equals("Turbo Flow (lb/min)")) {
                DoubleArray a = this.get("Sim MAF").data;
                c = new Dataset.Column((Dataset)this, id, "lb/min", a.div(7.55 * (double)this.env.f.turbos()));
            } else if (id.equals("Sim Fuel Mass")) {
                double gps_per_ccmin = 0.0114;
                double gps = this.env.f.injector() * 0.0114;
                double cylinders = this.env.f.cylinders();
                Dataset.Column bank1 = this.get((Comparable<?>)((Object)"EffInjectorDutyCycle"));
                Dataset.Column bank2 = this.get((Comparable<?>)((Object)"EffInjectorDutyCycleBank2"));
                DoubleArray duty = bank1.data;
                if (bank2 != null) {
                    duty = duty.add(bank2.data).div(2.0);
                }
                DoubleArray a = duty.mult(cylinders * gps / 100.0);
                c = new Dataset.Column((Dataset)this, id, "g/sec", a);
            } else if (id.equals("TargetAFRDriverRequest (AFR)")) {
                DoubleArray abs = super.get("TargetAFRDriverRequest").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioDesired (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioDesired").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioCurrent (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioCurrent").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioCurrentBank1 (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioCurrentBank1").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioCurrentBank2 (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioCurrentBank2").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("Lambda Bank 1 (AFR)")) {
                DoubleArray abs = super.get("Lambda Bank 1").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("Lambda Bank 2 (AFR)")) {
                DoubleArray abs = super.get("Lambda Bank 2").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("Sim AFR")) {
                DoubleArray a = this.get("Sim MAF").data;
                DoubleArray b = this.get("Sim Fuel Mass").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", a.div(b));
            } else if (id.equals("Sim lambda")) {
                DoubleArray a = this.get("Sim AFR").data.div(14.7);
                c = new Dataset.Column((Dataset)this, id, "lambda", a);
            } else if (id.equals("Sim lambda error")) {
                DoubleArray a = super.get("AirFuelRatioDesired").data;
                DoubleArray b = this.get("Sim lambda").data;
                c = new Dataset.Column((Dataset)this, id, "%", a.div(b).mult(-1.0).add(1.0).mult(100.0).max(-25.0).min(25.0));
            } else if (id.equals("FuelInjectorDutyCycle")) {
                DoubleArray a = super.get("FuelInjectorOnTime").data.div(60000.0);
                DoubleArray b = this.get("RPM").data.div(2.0);
                c = new Dataset.Column((Dataset)this, id, "%", a.mult(b).mult(100.0));
            } else if (id.equals("EffInjectorDutyCycle")) {
                DoubleArray a = super.get("EffInjectionTime").data.div(60000.0);
                DoubleArray b = this.get("RPM").data.div(2.0);
                c = new Dataset.Column((Dataset)this, id, "%", a.mult(b).mult(100.0));
            } else if (id.equals("EffInjectorDutyCycleBank2")) {
                DoubleArray a = super.get("EffInjectionTimeBank2").data.div(60000.0);
                DoubleArray b = this.get("RPM").data.div(2.0);
                c = new Dataset.Column((Dataset)this, id, "%", a.mult(b).mult(100.0));
            } else if (id.equals("Engine torque (ft-lb)")) {
                DoubleArray tq = this.get("Engine torque").data;
                DoubleArray value = tq.mult(0.737562149);
                c = new Dataset.Column((Dataset)this, id, "ft-lb", value);
            } else if (id.equals("Engine HP")) {
                DoubleArray tq = this.get("Engine torque (ft-lb)").data;
                DoubleArray rpm = this.get("RPM").data;
                DoubleArray value = tq.div(5252.0).mult(rpm);
                c = new Dataset.Column((Dataset)this, id, "HP", value);
            } else if (id.equals("VehicleSpeed (MPH)")) {
                Dataset.Column rawVehicleSpeed = this.get((Comparable<?>)((Object)"VehicleSpeed"));
                if (rawVehicleSpeed != null) {
                    DoubleArray a = rawVehicleSpeed.data.mult(0.621371192);
                    c = new Dataset.Column((Dataset)this, id, "MPH", a);
                } else {
                    DoubleArray rpm = this.get("RPM").data;
                    DoubleArray calculatedMph = rpm.div(this.env.c.rpm_per_mph());
                    c = new Dataset.Column((Dataset)this, id, "MPH", calculatedMph);
                }
            } else if (id.equals("Calc Velocity")) {
                DoubleArray rpm = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "m/s", rpm.div(this.env.c.rpm_per_mph()).div(2.2369362912));
            } else if (id.equals("Acceleration (RPM/s)")) {
                DoubleArray y = this.get("RPM").data;
                DoubleArray x = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "RPM/s", y.derivative(x, this.AccelMAW()).max(0.0));
            } else if (id.equals("Acceleration - raw (RPM/s)")) {
                DoubleArray y = this.get("RPM - raw").data;
                DoubleArray x = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "RPM/s", y.derivative(x));
            } else if (id.equals("Acceleration (m/s^2)")) {
                DoubleArray y = this.get("Calc Velocity").data;
                DoubleArray x = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "m/s^2", y.derivative(x, this.MAW()).max(0.0));
            } else if (id.equals("Acceleration (g)")) {
                DoubleArray a = this.get("Acceleration (m/s^2)").data;
                c = new Dataset.Column((Dataset)this, id, "g", a.div(9.80665));
            } else if (id.equals("WHP")) {
                DoubleArray a = this.get("Acceleration (m/s^2)").data;
                DoubleArray v = this.get("Calc Velocity").data;
                DoubleArray whp = a.mult(v).mult(this.env.c.mass()).add(this.drag(v));
                DoubleArray value = whp.mult(0.0013410220888438076);
                Object l = "HP";
                if (this.env.sae.enabled()) {
                    value = value.mult(this.env.sae.correction());
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value.movingAverage(this.MAW()));
            } else if (id.equals("HP")) {
                DoubleArray whp = this.get("WHP").data;
                DoubleArray value = whp.div(1.0 - this.env.c.driveline_loss()).add(this.env.c.static_loss());
                Object l = "HP";
                if (this.env.sae.enabled()) {
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value);
            } else if (id.equals("WTQ")) {
                DoubleArray whp = this.get("WHP").data;
                DoubleArray rpm = this.get("RPM").data;
                DoubleArray value = whp.mult(5252.0).div(rpm);
                Object l = "ft-lb";
                if (this.env.sae.enabled()) {
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value);
            } else if (id.equals("TQ")) {
                DoubleArray hp = this.get("HP").data;
                DoubleArray rpm = this.get("RPM").data;
                DoubleArray value = hp.mult(5252.0).div(rpm);
                Object l = "ft-lb";
                if (this.env.sae.enabled()) {
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value);
            } else if (id.equals("Drag")) {
                DoubleArray v = this.get("Calc Velocity").data;
                DoubleArray drag = this.drag(v);
                c = new Dataset.Column((Dataset)this, id, "HP", drag.mult(0.0013410220888438076));
            } else if (id.equals("IntakeAirTemperature")) {
                c = super.get(id);
                if (c.getUnits().matches(".*C$")) {
                    c = new Dataset.Column((Dataset)this, id, "\u00b0F", ECUxDataset.toFahrenheit(c.data));
                }
            } else if (id.equals("IntakeAirTemperature (C)")) {
                c = super.get((Comparable<?>)((Object)"IntakeAirTemperature"));
                if (c.getUnits().matches(".*F$")) {
                    c = new Dataset.Column((Dataset)this, id, "\u00b0C", ECUxDataset.toCelcius(c.data));
                }
            } else if (id.equals("BoostPressureDesired (PSI)")) {
                c = super.get((Comparable<?>)((Object)"BoostPressureDesired"));
                if (!c.getUnits().matches("PSI")) {
                    c = new Dataset.Column((Dataset)this, id, "PSI", this.toPSI(c.data));
                }
            } else if (id.equals("BoostPressureDesired")) {
                Dataset.Column ecu;
                Dataset.Column delta = super.get((Comparable<?>)((Object)"BoostPressureDesiredDelta"));
                if (delta != null && (ecu = super.get((Comparable<?>)((Object)"ECUBoostPressureDesired"))) != null) {
                    c = new Dataset.Column((Dataset)this, id, "PSI", ecu.data.add(delta.data));
                }
            } else if (id.equals("BoostPressureActual (PSI)")) {
                c = super.get((Comparable<?>)((Object)"BoostPressureActual"));
                if (!c.getUnits().matches("PSI")) {
                    c = new Dataset.Column((Dataset)this, id, "PSI", this.toPSI(c.data));
                }
            } else if (id.equals("Zeitronix Boost (PSI)")) {
                DoubleArray boost = super.get("Zeitronix Boost").data;
                c = new Dataset.Column((Dataset)this, id, "PSI", boost.movingAverage(this.filter.ZeitMAW()));
            } else if (id.equals("Zeitronix Boost")) {
                DoubleArray boost = this.get("Zeitronix Boost (PSI)").data;
                c = new Dataset.Column((Dataset)this, id, "mBar", boost.mult(0.0145038).add(1013.25));
            } else if (id.equals("Zeitronix AFR (lambda)")) {
                DoubleArray abs = super.get("Zeitronix AFR").data;
                c = new Dataset.Column((Dataset)this, id, "lambda", abs.div(14.7));
            } else if (id.equals("Zeitronix Lambda (AFR)")) {
                DoubleArray abs = super.get("Zeitronix Lambda").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("BoostDesired PR")) {
                Dataset.Column act = super.get((Comparable<?>)((Object)"BoostPressureDesired"));
                try {
                    DoubleArray ambient = super.get("BaroPressure").data;
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(ambient));
                }
                catch (Exception e) {
                    if (act.getUnits().matches("PSI")) {
                        c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(14.7));
                        break block162;
                    }
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(1013.25));
                }
            } else if (id.equals("BoostActual PR")) {
                Dataset.Column act = super.get((Comparable<?>)((Object)"BoostPressureActual"));
                try {
                    DoubleArray ambient = super.get("BaroPressure").data;
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(ambient));
                }
                catch (Exception e) {
                    if (act.getUnits().matches("PSI")) {
                        c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(14.7));
                        break block162;
                    }
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(1013.25));
                }
            } else if (id.equals("Sim evtmod")) {
                DoubleArray tans = this.get("IntakeAirTemperature (C)").data;
                DoubleArray tmot = tans.ident(95.0);
                try {
                    tmot = this.get("CoolantTemperature").data;
                }
                catch (Exception value) {
                    // empty catch block
                }
                DoubleArray evtmod = tans.add(tmot.sub(tans).mult(0.02));
                c = new Dataset.Column((Dataset)this, id, "\u00b0C", evtmod);
            } else if (id.equals("Sim ftbr")) {
                DoubleArray tans = this.get("IntakeAirTemperature (C)").data;
                DoubleArray evtmod = this.get("Sim evtmod").data;
                DoubleArray fwft = tans.add(673.425).div(731.334);
                c = new Dataset.Column((Dataset)this, id, "", evtmod.ident(273.0).div(evtmod.add(273.0)).mult(fwft));
            } else if (id.equals("Sim BoostIATCorrection")) {
                DoubleArray ftbr = this.get("Sim ftbr").data;
                c = new Dataset.Column((Dataset)this, id, "", ftbr.inverse());
            } else if (id.equals("Sim BoostPressureDesired")) {
                DoubleArray ps;
                DoubleArray load;
                boolean SY_BDE = false;
                boolean SY_AGR = true;
                try {
                    load = super.get("EngineLoadRequested").data;
                }
                catch (Exception e) {
                    load = super.get("EngineLoadCorrected").data;
                }
                try {
                    ps = super.get("ME7L ps_w").data;
                }
                catch (Exception e) {
                    ps = super.get("BoostPressureActual").data;
                }
                DoubleArray ambient = ps.ident(1013.25);
                try {
                    ambient = super.get("BaroPressure").data;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DoubleArray fupsrl = load.ident(0.1037);
                try {
                    DoubleArray ftbr = this.get("Sim ftbr").data;
                    fupsrl = fupsrl.mult(ftbr);
                }
                catch (Exception ftbr) {
                    // empty catch block
                }
                DoubleArray pirg = ambient.mult(0.0690846286701209);
                load = load.max(0.0);
                DoubleArray rfges = ps.mult(1.106).sub(pirg).max(0.0).mult(fupsrl);
                load = load.add(rfges.mult(250.0).div(ps));
                DoubleArray boost = load.div(fupsrl);
                boost = boost.div(1.016);
                boost = boost.div(1.016);
                c = new Dataset.Column((Dataset)this, id, "mBar", boost.max(ambient));
            } else if (id.equals("Boost Spool Rate (RPM)")) {
                DoubleArray abs = super.get("BoostPressureActual").data.smooth();
                DoubleArray rpm = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "mBar/RPM", abs.derivative(rpm).max(0.0));
            } else if (id.equals("Boost Spool Rate Zeit (RPM)")) {
                DoubleArray boost = this.get("Zeitronix Boost").data.smooth();
                DoubleArray rpm = this.get("RPM").data.movingAverage(this.filter.ZeitMAW()).smooth();
                c = new Dataset.Column((Dataset)this, id, "mBar/RPM", boost.derivative(rpm).max(0.0));
            } else if (id.equals("Boost Spool Rate (time)")) {
                DoubleArray abs = this.get("BoostPressureActual (PSI)").data.smooth();
                DoubleArray time = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "PSI/sec", abs.derivative(time, this.MAW()).max(0.0));
            } else if (id.equals("ps_w error")) {
                DoubleArray abs = super.get("BoostPressureActual").data.max(900.0);
                DoubleArray ps_w = super.get("ME7L ps_w").data.max(900.0);
                c = new Dataset.Column((Dataset)this, id, "lambda", ps_w.div(abs));
            } else if (id.equals("LDR error")) {
                DoubleArray set = super.get("BoostPressureDesired").data;
                DoubleArray out = super.get("BoostPressureActual").data;
                c = new Dataset.Column((Dataset)this, id, "100mBar", set.sub(out).div(100.0));
            } else if (id.equals("LDR de/dt")) {
                DoubleArray set = super.get("BoostPressureDesired").data;
                DoubleArray out = super.get("BoostPressureActual").data;
                DoubleArray t = this.get("TIME").data;
                DoubleArray o = set.sub(out).derivative(t, this.MAW());
                c = new Dataset.Column((Dataset)this, id, "100mBar", o.mult(this.env.pid.time_constant).div(100.0));
            } else if (id.equals("LDR I e dt")) {
                DoubleArray set = super.get("BoostPressureDesired").data;
                DoubleArray out = super.get("BoostPressureActual").data;
                DoubleArray t = this.get("TIME").data;
                DoubleArray o = set.sub(out).integral(t, 0.0, this.env.pid.I_limit / this.env.pid.I * 100.0);
                c = new Dataset.Column((Dataset)this, id, "100mBar", o.div(this.env.pid.time_constant).div(100.0));
            } else if (id.equals("LDR PID")) {
                DoubleArray.TransferFunction fP = new DoubleArray.TransferFunction(){

                    @Override
                    public final double f(double x, double y) {
                        if (Math.abs(x) < ECUxDataset.this.env.pid.P_deadband / 100.0) {
                            return 0.0;
                        }
                        return x * ECUxDataset.this.env.pid.P;
                    }
                };
                DoubleArray.TransferFunction fD = new DoubleArray.TransferFunction(){

                    @Override
                    public final double f(double x, double y) {
                        if ((y = Math.abs(y)) < 3.0) {
                            return x * ECUxDataset.this.env.pid.D[0];
                        }
                        if (y < 5.0) {
                            return x * ECUxDataset.this.env.pid.D[1];
                        }
                        if (y < 7.0) {
                            return x * ECUxDataset.this.env.pid.D[2];
                        }
                        return x * ECUxDataset.this.env.pid.D[3];
                    }
                };
                DoubleArray E = this.get("LDR error").data;
                DoubleArray P = E.func(fP);
                DoubleArray I = this.get("LDR I e dt").data.mult(this.env.pid.I);
                DoubleArray D = this.get("LDR de/dt").data.func(fD, E);
                c = new Dataset.Column((Dataset)this, id, "%", P.add(I).add(D).max(0.0).min(95.0));
            } else if (id.equals("Sim pspvds")) {
                DoubleArray ps_w = super.get("ME7L ps_w").data;
                DoubleArray pvdkds = super.get("BoostPressureActual").data;
                c = new Dataset.Column((Dataset)this, id, "", ps_w.div(pvdkds));
            } else if (id.equals("IgnitionTimingAngleOverallDesired")) {
                DoubleArray averetard = null;
                int count = 0;
                for (int i = 0; i < 8; ++i) {
                    Dataset.Column retard = this.get((Comparable<?>)((Object)("IgnitionRetardCyl" + i)));
                    if (retard == null) continue;
                    averetard = averetard == null ? retard.data : averetard.add(retard.data);
                    ++count;
                }
                DoubleArray out = this.get("IgnitionTimingAngleOverall").data;
                if (count > 0) {
                    out = out.add(averetard.div(count).abs());
                }
                c = new Dataset.Column((Dataset)this, id, "\u00b0", out);
            } else if (id.equals("Sim LoadSpecified correction")) {
                DoubleArray cs = super.get("EngineLoadCorrected").data;
                DoubleArray s = super.get("EngineLoadSpecified").data;
                c = new Dataset.Column((Dataset)this, id, "K", cs.div(s));
            }
        }
        if (c == null && id.toString().endsWith(" (ms)")) {
            String s = id.toString();
            Dataset.Column t = this.get((Comparable<?>)((Object)(s = s.substring(0, s.length() - 5))));
            if (t != null) {
                DoubleArray r = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "(ms)", t.data.div(r.mult(0.006)));
            }
        }
        if (c != null) {
            this.getColumns().add(c);
            return c;
        }
        return super.get(id);
    }

    @Override
    protected boolean dataValid(int i) {
        Dataset.Column boostDesired;
        Dataset.Column boostActual;
        Dataset.Column accel;
        boolean ret = true;
        if (this.filter == null) {
            return ret;
        }
        if (!this.filter.enabled()) {
            return ret;
        }
        ArrayList<CallSite> reasons = new ArrayList<CallSite>();
        if (this.filter.gear() >= 0 && this.gear != null && Math.round(this.gear.data.get(i)) != (long)this.filter.gear()) {
            reasons.add((CallSite)((Object)("gear " + Math.round(this.gear.data.get(i)) + "!=" + this.filter.gear())));
            ret = false;
        }
        if (this.pedal != null && this.pedal.data.get(i) < (double)this.filter.minPedal()) {
            reasons.add((CallSite)((Object)("pedal " + this.pedal.data.get(i) + "<" + this.filter.minPedal())));
            ret = false;
        }
        if (this.throttle != null && this.throttle.data.get(i) < (double)this.filter.minThrottle()) {
            reasons.add((CallSite)((Object)("throttle " + this.throttle.data.get(i) + "<" + this.filter.minThrottle())));
            ret = false;
        }
        if (this.filter.minAcceleration() > 0 && (accel = this.get((Comparable<?>)((Object)"Acceleration (RPM/s)"))) != null && accel.data.get(i) < (double)this.filter.minAcceleration()) {
            reasons.add((CallSite)((Object)("acceleration " + accel.data.get(i) + "<" + this.filter.minAcceleration() + " RPM/s")));
            ret = false;
        }
        if (this.zboost != null && this.zboost.data.get(i) < 0.0) {
            reasons.add((CallSite)((Object)("zboost " + this.zboost.data.get(i) + "<0")));
            ret = false;
        }
        if ((boostActual = this.get((Comparable<?>)((Object)"BoostPressureActual"))) != null && boostActual.data.get(i) < 1000.0) {
            reasons.add((CallSite)((Object)("boost actual " + boostActual.data.get(i) + "<1000 mBar (vacuum)")));
            ret = false;
        }
        if ((boostDesired = this.get((Comparable<?>)((Object)"BoostPressureDesired"))) != null && boostDesired.data.get(i) < 1000.0) {
            reasons.add((CallSite)((Object)("boost desired " + boostDesired.data.get(i) + "<1000 mBar (vacuum)")));
            ret = false;
        }
        if (this.rpm != null) {
            if (this.rpm.data.get(i) < (double)this.filter.minRPM()) {
                reasons.add((CallSite)((Object)("rpm " + this.rpm.data.get(i) + "<" + this.filter.minRPM())));
                ret = false;
            }
            if (this.rpm.data.get(i) > (double)this.filter.maxRPM()) {
                reasons.add((CallSite)((Object)("rpm " + this.rpm.data.get(i) + ">" + this.filter.maxRPM())));
                ret = false;
            }
            if (i > 0 && this.rpm.data.size() > i + 2 && this.rpm.data.get(i - 1) - this.rpm.data.get(i + 1) > (double)this.filter.monotonicRPMfuzz()) {
                reasons.add((CallSite)((Object)("rpm delta " + this.rpm.data.get(i - 1) + "-" + this.rpm.data.get(i + 1) + ">" + this.filter.monotonicRPMfuzz())));
                ret = false;
            }
        }
        if (!ret) {
            this.lastFilterReasons = reasons;
            logger.trace("Filter rejected data point {}: {}", (Object)i, (Object)String.join((CharSequence)", ", reasons));
        }
        return ret;
    }

    @Override
    protected boolean rangeValid(Dataset.Range r) {
        boolean ret = true;
        if (this.filter == null) {
            return ret;
        }
        if (!this.filter.enabled()) {
            return ret;
        }
        ArrayList<CallSite> reasons = new ArrayList<CallSite>();
        if (r.size() < this.filter.minPoints()) {
            reasons.add((CallSite)((Object)("points " + r.size() + "<" + this.filter.minPoints())));
            ret = false;
        }
        if (this.rpm != null && this.rpm.data.get(r.end) < this.rpm.data.get(r.start) + (double)this.filter.minRPMRange()) {
            reasons.add((CallSite)((Object)("RPM Range " + this.rpm.data.get(r.end) + "<" + this.rpm.data.get(r.start) + "+" + this.filter.minRPMRange())));
            ret = false;
        }
        if (!ret) {
            this.lastFilterReasons = reasons;
            logger.trace("Filter rejected range {}: {}", (Object)r, (Object)String.join((CharSequence)", ", reasons));
        }
        return ret;
    }

    private static final PrintStream nullStdout() {
        PrintStream original = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }));
        return original;
    }

    @Override
    public void buildRanges() {
        super.buildRanges();
        ArrayList<Dataset.Range> ranges = this.getRanges();
        this.splines = new CubicSpline[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            this.splines[i] = null;
            Dataset.Range r = ranges.get(i);
            double[] rpm = this.getData((Comparable<?>)((Object)"RPM"), r);
            double[] time = this.getData((Comparable<?>)((Object)"TIME"), r);
            if (rpm == null || time == null || time.length != rpm.length || rpm.length < 3) continue;
            PrintStream original = null;
            try {
                original = ECUxDataset.nullStdout();
                this.splines[i] = new CubicSpline(rpm, time);
                System.setOut(original);
                original = null;
                continue;
            }
            catch (Exception e) {
                if (original != null) {
                    System.setOut(original);
                }
                logger.warn("CubicSpline:", e);
            }
        }
    }

    public double calcFATS(int run, int RPMStart, int RPMEnd) throws Exception {
        return this.calcFATSRPM(run, RPMStart, RPMEnd);
    }

    public double calcFATSBySpeed(int run, double speedStart, double speedEnd) throws Exception {
        return this.calcFATSMPH(run, speedStart, speedEnd);
    }

    private double calcFATSRPM(int run, int RPMStart, int RPMEnd) throws Exception {
        ArrayList<Dataset.Range> ranges = this.getRanges();
        if (run < 0 || run >= ranges.size()) {
            throw new Exception("FATS run " + run + " not found (available: 0-" + (ranges.size() - 1) + ")");
        }
        if (this.splines[run] == null) {
            throw new Exception("FATS run " + run + " interpolation failed - check filter settings");
        }
        Dataset.Range r = ranges.get(run);
        logger.trace("FATS RPM calculation: run={}, range={}-{}", run, r.start, r.end);
        logger.trace("FATS RPM calculation: {} RPM -> {} RPM", (Object)RPMStart, (Object)RPMEnd);
        double et = this.splines[run].interpolate(RPMEnd) - this.splines[run].interpolate(RPMStart);
        if (et <= 0.0) {
            throw new Exception("FATS RPM calculation failed: timeEnd <= timeStart for RPM range " + RPMStart + "-" + RPMEnd);
        }
        return et;
    }

    private double calcFATSMPH(int run, double speedStart, double speedEnd) throws Exception {
        ArrayList<Dataset.Range> ranges = this.getRanges();
        if (run < 0 || run >= ranges.size()) {
            throw new Exception("FATS run " + run + " not found (available: 0-" + (ranges.size() - 1) + ")");
        }
        if (this.splines[run] == null) {
            throw new Exception("FATS run " + run + " interpolation failed - check filter settings");
        }
        Dataset.Range r = ranges.get(run);
        logger.trace("FATS MPH calculation: run={}, range={}-{}", run, r.start, r.end);
        double rpmPerMph = this.env.c.rpm_per_mph();
        int rpmStart = (int)Math.round(speedStart * rpmPerMph);
        int rpmEnd = (int)Math.round(speedEnd * rpmPerMph);
        logger.trace("FATS MPH->RPM conversion: {} mph -> {} RPM, {} mph -> {} RPM", speedStart, rpmStart, speedEnd, rpmEnd);
        return this.calcFATSRPM(run, rpmStart, rpmEnd);
    }

    public double[] calcFATS(int RPMStart, int RPMEnd) {
        ArrayList<Dataset.Range> ranges = this.getRanges();
        double[] out = new double[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            try {
                out[i] = this.calcFATS(i, RPMStart, RPMEnd);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Env getEnv() {
        return this.env;
    }

    @Override
    public boolean useId2() {
        return this.env.prefs.getBoolean("altnames", false);
    }
}

