/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.nyet.ecuxplot.Constants;
import org.nyet.ecuxplot.FATS;
import org.nyet.ecuxplot.PreferencesEditor;

public class FATSEditor
extends PreferencesEditor {
    private static final long serialVersionUID = 1L;
    private final FATS s;
    private final Constants c;
    public JTextField start;
    public JTextField end;
    public JTextField rpmPerMph;
    public JCheckBox useMph;
    public JLabel startLabel;
    public JLabel endLabel;
    public JLabel rpmPerMphLabel;
    private static String[][] pairs = new String[][]{{"Range", "start"}, {"RPM per MPH", "rpmPerMph"}};
    private static int[] fieldSizes = new int[]{6, 4};

    @Override
    protected void Process(ActionEvent event) {
        if (this.useMph.isSelected()) {
            this.s.startMph(Double.valueOf(this.start.getText()));
            this.s.endMph(Double.valueOf(this.end.getText()));
        } else {
            this.s.start(Integer.valueOf(this.start.getText()));
            this.s.end(Integer.valueOf(this.end.getText()));
        }
        this.s.useMph(this.useMph.isSelected());
        this.c.rpm_per_mph(Double.valueOf(this.rpmPerMph.getText()));
        super.Process(event);
    }

    public FATSEditor(Preferences prefs, FATS s, Constants c) {
        super(prefs.node("FATS"), pairs, fieldSizes);
        this.s = s;
        this.c = c;
        JPanel customPanel = new JPanel(new BorderLayout());
        JPanel rangePanel = new JPanel(new FlowLayout(0));
        this.start = new JTextField("" + this.s.start(), 3);
        rangePanel.add(this.start);
        rangePanel.add(new JLabel(" to "));
        this.end = new JTextField("" + this.s.end(), 3);
        rangePanel.add(this.end);
        this.startLabel = new JLabel("RPM");
        rangePanel.add(this.startLabel);
        this.useMph = new JCheckBox("Use MPH instead of RPM");
        this.useMph.setSelected(this.s.useMph());
        this.useMph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FATSEditor.this.updateLabels();
                FATSEditor.this.updateValues();
                FATSEditor.this.updateRpmPerMphVisibility();
            }
        });
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add(this.useMph);
        JPanel bottomPanel = new JPanel(new FlowLayout(0));
        bottomPanel.add(new JLabel("Range: "));
        bottomPanel.add(rangePanel);
        this.rpmPerMph = new JTextField("" + this.c.rpm_per_mph(), 4);
        this.rpmPerMphLabel = new JLabel("RPM/MPH:");
        bottomPanel.add(Box.createHorizontalStrut(20));
        bottomPanel.add(this.rpmPerMphLabel);
        bottomPanel.add(this.rpmPerMph);
        customPanel.add((Component)topPanel, "North");
        customPanel.add((Component)bottomPanel, "Center");
        this.remove(this.getPrefsPanel());
        this.add((Component)customPanel, "Center");
        this.updateLabels();
        this.updateRpmPerMphVisibility();
    }

    @Override
    public void updateDialog() {
        this.useMph.setSelected(this.s.useMph());
        this.rpmPerMph.setText("" + this.c.rpm_per_mph());
        this.updateLabels();
        this.updateValues();
        this.updateRpmPerMphVisibility();
    }

    private void updateLabels() {
        if (this.useMph.isSelected()) {
            this.startLabel.setText("MPH");
        } else {
            this.startLabel.setText("RPM");
        }
    }

    private void updateValues() {
        if (this.useMph.isSelected()) {
            this.start.setText("" + this.s.startMph());
            this.end.setText("" + this.s.endMph());
        } else {
            this.start.setText("" + this.s.start());
            this.end.setText("" + this.s.end());
        }
    }

    private void updateRpmPerMphVisibility() {
        boolean showRpmPerMph = !this.useMph.isSelected();
        this.rpmPerMphLabel.setVisible(showRpmPerMph);
        this.rpmPerMph.setVisible(showRpmPerMph);
    }
}

