/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.nyet.ecuxplot.ECUxPlot;
import org.nyet.util.GenericFileFilter;
import org.nyet.util.Locate;

public final class ProfileMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final ECUxPlot plotFrame;
    private final JMenu loadProfilesMenu;
    private final JMenu saveProfilesMenu;
    private final JMenu deleteProfilesMenu;

    public ProfileMenu(String id, ECUxPlot plotFrame) {
        super(id);
        this.plotFrame = plotFrame;
        JMenuItem jmi = new JMenuItem("Edit constants...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        jmi = new JMenuItem("Edit fueling...");
        jmi.addActionListener(plotFrame);
        this.add(jmi);
        this.add(new JSeparator());
        this.loadProfilesMenu = new JMenu("Load Profile...");
        this.saveProfilesMenu = new JMenu("Save Profile...");
        this.deleteProfilesMenu = new JMenu("Delete Profile...");
        this.updateProfiles();
        this.add(this.loadProfilesMenu);
        this.add(this.saveProfilesMenu);
        this.add(this.deleteProfilesMenu);
    }

    private void updateProfiles() {
        File dir;
        try {
            dir = new File(Locate.getClassDirectory(this), "profiles");
            if (!dir.isDirectory()) {
                dir = new File("profiles");
            }
        }
        catch (Exception e) {
            ProfileMenu pm = this;
            JOptionPane.showMessageDialog(pm.plotFrame, e.toString());
            e.printStackTrace();
            return;
        }
        if (dir.isDirectory()) {
            LoadProfileAction lpa = new LoadProfileAction(dir);
            for (File p : dir.listFiles()) {
                if (!p.isDirectory() || p.getName().startsWith(".")) continue;
                JMenuItem jmi = new JMenuItem(p.getName());
                jmi.addActionListener(lpa);
                this.loadProfilesMenu.add(jmi);
            }
        }
        if (!(dir = new File(Locate.getDataDirectory("ECUxPlot"), "profiles")).exists()) {
            String err = null;
            try {
                if (!dir.mkdirs()) {
                    err = "Failed to create profile directory " + dir.getPath();
                }
            }
            catch (SecurityException se) {
                err = "Failed to create profile directory " + dir.getPath() + "\n" + se.toString();
            }
            if (err != null) {
                System.out.println(err);
            }
        }
        if (dir.isDirectory()) {
            SaveProfileAction spa = new SaveProfileAction(dir);
            DeleteProfileAction dpa = new DeleteProfileAction(dir);
            File[] profiles = dir.listFiles();
            if (profiles != null && profiles.length > 0) {
                this.loadProfilesMenu.add(new JSeparator());
                LoadProfileAction lpa = new LoadProfileAction(dir);
                for (File p : profiles) {
                    if (!p.isDirectory() || p.getName().startsWith(".")) continue;
                    JMenuItem jmi = new JMenuItem(p.getName());
                    jmi.addActionListener(lpa);
                    this.loadProfilesMenu.add(jmi);
                    jmi = new JMenuItem(p.getName());
                    jmi.addActionListener(spa);
                    this.saveProfilesMenu.add(jmi);
                    jmi = new JMenuItem(p.getName());
                    jmi.addActionListener(dpa);
                    this.deleteProfilesMenu.add(jmi);
                }
                this.saveProfilesMenu.add(new JSeparator());
            }
            JMenuItem jmi = new JMenuItem("New Profile...");
            jmi.addActionListener(spa);
            this.saveProfilesMenu.add(jmi);
        }
    }

    private class LoadProfileAction
    implements ActionListener {
        private final File dir;

        public LoadProfileAction(File dir) {
            this.dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ProfileMenu pm = ProfileMenu.this;
            try {
                File[] profiles;
                File pdir = new File(this.dir, event.getActionCommand());
                for (File p : profiles = pdir.listFiles(new GenericFileFilter("xml"))) {
                    ECUxPlot.getPreferences();
                    Preferences.importPreferences(new FileInputStream(p));
                }
                if (pm.plotFrame != null) {
                    pm.plotFrame.rebuild();
                }
                if (pm.plotFrame.fatsFrame != null) {
                    pm.plotFrame.fatsFrame.updateRpmPerMphFromConstants();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(pm.plotFrame, e.toString());
                e.printStackTrace();
            }
        }
    }

    private class SaveProfileAction
    implements ActionListener {
        private final File dir;

        public SaveProfileAction(File dir) {
            this.dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String prof = event.getActionCommand();
            boolean make = false;
            ProfileMenu pm = ProfileMenu.this;
            if (prof.equals("New Profile...")) {
                prof = ECUxPlot.showInputDialog("Enter profile name");
                if (prof == null) {
                    return;
                }
                make = true;
            }
            try {
                File pdir = new File(this.dir, prof);
                if (make) {
                    if (pdir.isDirectory()) {
                        JOptionPane.showMessageDialog(pm.plotFrame, "Profile already exists");
                        return;
                    }
                    if (!pdir.mkdirs()) {
                        JOptionPane.showMessageDialog(pm.plotFrame, "Failed to create profile");
                        return;
                    }
                    pm.saveProfilesMenu.removeAll();
                    pm.loadProfilesMenu.removeAll();
                    ProfileMenu.this.updateProfiles();
                }
                if (pdir.isDirectory()) {
                    for (File f : pdir.listFiles()) {
                        f.delete();
                    }
                    pm.plotFrame.getEnv().c.get().exportNode(new FileOutputStream(new File(pdir, "constants.xml")));
                    pm.plotFrame.getEnv().f.get().exportNode(new FileOutputStream(new File(pdir, "fueling.xml")));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(pm.plotFrame, e.toString());
                e.printStackTrace();
            }
        }
    }

    private class DeleteProfileAction
    implements ActionListener {
        private final File dir;

        public DeleteProfileAction(File dir) {
            this.dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String profileName = event.getActionCommand();
            ProfileMenu pm = ProfileMenu.this;
            int result = JOptionPane.showConfirmDialog(pm.plotFrame, "Are you sure you want to delete the profile '" + profileName + "'?\n\nThis action cannot be undone.", "Delete Profile", 0, 2);
            if (result != 0) {
                return;
            }
            try {
                File profileDir = new File(this.dir, profileName);
                if (profileDir.isDirectory()) {
                    File[] files = profileDir.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            if (file.delete()) continue;
                            JOptionPane.showMessageDialog(pm.plotFrame, "Failed to delete file: " + file.getName());
                            return;
                        }
                    }
                    if (!profileDir.delete()) {
                        JOptionPane.showMessageDialog(pm.plotFrame, "Failed to delete profile directory");
                        return;
                    }
                    pm.saveProfilesMenu.removeAll();
                    pm.loadProfilesMenu.removeAll();
                    pm.deleteProfilesMenu.removeAll();
                    pm.updateProfiles();
                    JOptionPane.showMessageDialog(pm.plotFrame, "Profile '" + profileName + "' deleted successfully");
                } else {
                    JOptionPane.showMessageDialog(pm.plotFrame, "Profile directory not found: " + profileDir.getPath());
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(pm.plotFrame, "Error deleting profile: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

