/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.mappack;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.nyet.logfile.CSVRow;
import org.nyet.mappack.HexValue;
import org.nyet.mappack.MapData;
import org.nyet.mappack.Parse;
import org.nyet.mappack.ParserException;
import org.nyet.util.Strings;
import org.nyet.util.XmlString;

public class Map
implements Comparable<Object> {
    private int index;
    private byte header0;
    private int header0a;
    public String comment;
    private byte header0b;
    public String name;
    public Organization organization;
    private int header;
    private int headera;
    public int base;
    public int folderId;
    public String id;
    private int header1;
    private byte header1a;
    private int header1b;
    public int[] range = new int[4];
    private final HexValue[] header2 = new HexValue[8];
    public boolean reciprocal;
    public boolean difference;
    public boolean percent;
    public Dimension size;
    private final int[] header3 = new int[2];
    public Value value;
    public HexValue[] extent = new HexValue[2];
    private HexValue header4;
    private final int[] header4a = new int[2];
    private HexValue extent2;
    private final int[] header5 = new int[2];
    private HexValue header6;
    private int header7;
    public Axis x_axis;
    public Axis y_axis;
    public Axis z_axis;
    private int header8;
    private short header8a;
    private final HexValue[] header9 = new HexValue[5];
    private final short[] header9a = new short[7];
    private int header9b;
    private byte header9c;
    private final HexValue[] header10 = new HexValue[6];
    private final HexValue[] header11 = new HexValue[2];
    public byte[] term2 = new byte[3];
    private int kpv;
    public static final int INPUT_KP_v1 = 1;
    public static final int INPUT_KP_v2 = 2;
    public static final int FORMAT_DUMP = 0;
    public static final int FORMAT_CSV = 1;
    public static final int FORMAT_OLD_XDF = 2;
    public static final int FORMAT_XDF = 3;
    public static final boolean XDF_Pedantic = true;
    public static final int XDF_MaxDigits = 6;
    public static final String XDF_LBL = "\t%06d %-17s=";

    public Map(ByteBuffer b, int kpv) throws ParserException {
        this(0, b, kpv);
    }

    public Map(int index, ByteBuffer b, int kpv) throws ParserException {
        this.index = index;
        this.kpv = kpv;
        this.header0 = b.get();
        if (kpv == 2) {
            this.header0a = b.getInt();
            this.comment = Parse.string(b);
            this.header0b = b.get();
        }
        this.name = Parse.string(b);
        this.organization = new Organization(this, b);
        this.header = b.getInt();
        ValueType vt = new ValueType(this, b);
        this.header = b.getInt();
        this.base = b.getInt();
        this.folderId = b.getInt();
        this.id = Parse.string(b);
        this.header1 = b.getInt();
        this.header1a = b.get();
        if (kpv == 2) {
            this.header1b = b.getInt();
        }
        Parse.buffer(b, this.range);
        Parse.buffer(b, this.header2);
        this.reciprocal = b.get() == 1;
        boolean sign = b.get() == 1;
        this.difference = b.get() == 1;
        this.percent = b.get() == 1;
        this.size = new Dimension(this, b);
        Parse.buffer(b, this.header3);
        int precision = b.getInt();
        this.value = new Value(this, b, vt, sign, precision);
        Parse.buffer(b, this.extent);
        this.header4 = new HexValue(b);
        if (kpv == 2) {
            Parse.buffer(b, this.header4a);
        }
        this.extent2 = new HexValue(b);
        Parse.buffer(b, this.header5);
        this.header6 = new HexValue(b);
        this.header7 = b.getInt();
        this.x_axis = new Axis(b, "x", this.size.x);
        this.y_axis = new Axis(b, "y", this.size.y);
        this.header8 = b.getInt();
        this.header8a = b.getShort();
        Parse.buffer(b, this.header9);
        Parse.buffer(b, this.header9a);
        this.header9b = b.getInt();
        this.header9c = b.get();
        Parse.buffer(b, this.header10);
        Parse.buffer(b, this.header11);
        b.get(this.term2);
        this.z_axis = new Axis(this.value, this);
        if (this.term2[0] != 1 || this.term2[1] != 1) {
            throw new ParserException(b, "unexpected term2:" + Arrays.toString(this.term2), (Object)this);
        }
    }

    public Map(Axis axis, int size) {
        this.extent[0] = axis.addr;
        this.value = axis.value;
        this.size = new Dimension(this, 1, size);
    }

    public static final String CSVHeader() {
        Object[] header = new String[]{"ID", "Address", "Name", "Size", "Organization", "Description", "Units", "X Address", "Y Address", "X Units", "Y Units", "Scale", "X Scale", "Y Scale", "Value min", "Value max", "Value min*1", "Value max*1"};
        CSVRow out = new CSVRow(header);
        return out.toString();
    }

    public boolean equals(Map map) {
        String stem = map.id.split("[? ]")[0];
        if (stem.length() == 0) {
            return false;
        }
        return this.equals(stem);
    }

    public boolean equals(String id) {
        if (id.length() == 0 || this.id.length() == 0) {
            return false;
        }
        return id.equals(this.id.split("[? ]")[0]);
    }

    private void swapXY() {
        Axis tmpa = this.y_axis;
        this.y_axis = this.x_axis;
        this.x_axis = tmpa;
        this.x_axis.name = "x";
        this.y_axis.name = "y";
        int tmp = this.size.y;
        this.size.y = this.size.x;
        this.size.x = tmp;
    }

    public String toString() {
        return this.toStringDump();
    }

    public String toString(int format, ByteBuffer image) throws Exception {
        switch (format) {
            case 0: {
                return this.toStringDump();
            }
            case 1: {
                return this.toStringCSV(image);
            }
            case 2: {
                return this.toStringOldXDF(image);
            }
            case 3: {
                return this.toStringXDF(image);
            }
        }
        return "";
    }

    private String toStringCSV(ByteBuffer image) throws Exception {
        CSVRow row = new CSVRow();
        row.add(this.id);
        row.add(this.extent[0]);
        row.add(this.name);
        row.add(this.size);
        row.add(this.value.type);
        row.add(this.value.description);
        row.add(this.value.units);
        row.add(this.x_axis.addr != null ? String.format("0x%x", this.x_axis.addr.v) : "-");
        row.add(this.y_axis.addr != null ? String.format("0x%x", this.y_axis.addr.v) : "-");
        row.add(this.x_axis.value.units);
        row.add(this.y_axis.value.units);
        row.add(this.value.factor);
        row.add(this.x_axis.value.factor);
        row.add(this.y_axis.value.factor);
        if (image != null && image.limit() > 0) {
            MapData mapdata = new MapData(this, image);
            row.add(mapdata.getMinimumValue());
            row.add(mapdata.getMaximumValue());
            row.add(String.format("0x%x", mapdata.getMinimum()));
            row.add(String.format("0x%x", mapdata.getMaximum()));
        } else {
            row.add("");
            row.add("");
            row.add("");
            row.add("");
        }
        row.add(this.comment != null ? this.comment : "");
        return row.toString();
    }

    private static String ordinalArray(int len) {
        Object[] out = new Integer[len];
        for (int i = 0; i < len; ++i) {
            out[i] = i + 1;
        }
        return Strings.join(",", out);
    }

    private String toStringOldXDF(ByteBuffer image) throws Exception {
        int flags;
        boolean table = this.organization.isTable();
        boolean oneD = this.organization.is1D() || this.size.y <= 1;
        Object out = table ? "%%TABLE%%\n" : "%%CONSTANT%%\n";
        out = (String)out + String.format("\t%06d %-17s=0x%X\n", 100, "Cat0ID", this.folderId + 1);
        int off = table ? 40000 : 20000;
        String title = "";
        String desc = "";
        if (this.id.length() > 0) {
            title = this.id.split(" ")[0];
            desc = this.name;
        } else {
            title = this.name;
        }
        out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", off + 5, "Title", title);
        if (desc.length() > 0) {
            out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", off + 10, "Desc", desc);
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 11, "DescSize", desc.length() + 1);
        }
        if (this.value.units.length() > 0) {
            out = table ? (String)out + String.format("\t%06d %-17s=\"%s\"\n", off + 330, "ZUnits", this.value.units) : (String)out + String.format("\t%06d %-17s=\"%s\"\n", off + 20, "Units", this.value.units);
        }
        if (this.value.type.width() > 1) {
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 50, "SizeInBits", this.value.type.width() * 8);
        }
        if (this.value.precision != 2) {
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 210, "DecimalPl", this.value.precision);
        }
        int n = flags = this.value.sign ? 1 : 0;
        if (this.value.type.isLE()) {
            flags |= 2;
        }
        out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 100, "Address", this.extent[0].v);
        out = (String)out + this.value.eqOldXDF(off + 200, table ? "ZEq" : "Equation");
        if (table) {
            if (this.size.x > 256 && this.size.y <= 256) {
                this.swapXY();
            }
            if (this.x_axis.value.sign) {
                flags |= 0x40;
            }
            if (this.x_axis.value.type.isLE()) {
                flags |= 0x100;
            }
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 305, "Cols", this.size.x);
            out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", off + 320, "XUnits", this.x_axis.value.units);
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 352, "XLabelType", this.x_axis.value.precision == 0 ? 2 : 1);
            if (this.x_axis.datasource.isOrdinal() && this.size.x > 1) {
                out = (String)out + String.format("\t%06d %-17s=%s\n", off + 350, "XLabels", Map.ordinalArray(this.size.x));
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 352, "XLabelType", 2);
            } else if (this.x_axis.addr != null) {
                out = (String)out + this.x_axis.value.eqOldXDF(off + 354, "XEq");
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 505, "XLabelSource", 1);
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 600, "XAddress", this.x_axis.addr.v);
                out = (String)out + String.format("\t%06d %-17s=%d\n", off + 610, "XDataSize", this.x_axis.value.type.width());
                out = (String)out + String.format("\t%06d %-17s=%d\n", off + 620, "XAddrStep", this.x_axis.value.type.width());
                if (this.x_axis.value.precision != 2) {
                    out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 650, "XOutputDig", this.x_axis.value.precision);
                }
            }
            if (this.y_axis.value.sign) {
                flags |= 0x80;
            }
            if (this.y_axis.value.type.isLE()) {
                flags |= 0x200;
            }
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 300, "Rows", this.size.y);
            out = (String)out + String.format("\t%06d %-17s=\"%s\"\n", off + 325, "YUnits", this.y_axis.value.units);
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 362, "YLabelType", this.y_axis.value.precision == 0 ? 2 : 1);
            if (this.y_axis.datasource.isOrdinal() && this.size.y > 1) {
                out = (String)out + String.format("\t%06d %-17s=%s\n", off + 360, "YLabels", Map.ordinalArray(this.size.y));
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 362, "YLabelType", 2);
            } else if (this.y_axis.addr != null) {
                out = (String)out + this.y_axis.value.eqOldXDF(off + 364, "YEq");
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 515, "YLabelSource", 1);
                out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 700, "YAddress", this.y_axis.addr.v);
                out = (String)out + String.format("\t%06d %-17s=%d\n", off + 710, "YDataSize", this.y_axis.value.type.width());
                out = (String)out + String.format("\t%06d %-17s=%d\n", off + 720, "YAddrStep", this.y_axis.value.type.width());
                if (this.y_axis.value.precision != 2) {
                    out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 750, "YOutputDig", this.y_axis.value.precision);
                }
            }
        }
        out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 150, "Flags", flags);
        if (oneD) {
            out = (String)out + String.format("\t%06d %-17s=%s\n", off + 360, "YLabels", this.y_axis.value.units);
            out = (String)out + String.format("\t%06d %-17s=0x%X\n", off + 362, "YLabelType", 4);
        }
        return (String)out + "%%END%%\n";
    }

    private void tableToXDF(XmlString xs) {
        if (this.size.x > 256 && this.size.y <= 256) {
            this.swapXY();
        }
        this.x_axis.toXDF(xs);
        this.y_axis.toXDF(xs);
        this.z_axis.toXDF(xs);
    }

    private void constantToXDF(XmlString xs) {
        int flags;
        int n = flags = this.value.sign ? 1 : 0;
        if (this.value.type.isLE()) {
            flags |= 2;
        }
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (flags != 0) {
            m.put("mmedtypeflags", String.format("0x%02X", flags));
        }
        m.put("mmedaddress", String.format("0x%X", this.extent[0].v));
        m.put("mmedelementsizebits", this.value.type.width() * 8);
        xs.append("EMBEDDEDDATA", m);
        xs.append("units", this.value.units);
        xs.append("outputtype", this.value.outputtypeXDF(this.base));
        if (this.value.precision != 2) {
            xs.append("decimalpl", this.value.precision);
        }
        xs.append("datatype", 0);
        xs.append("unittype", 0);
        xs.append("DALINK index=\"0\" /");
        this.value.doMathXDF(xs);
    }

    private String toStringXDF(ByteBuffer image) throws Exception {
        String tag;
        boolean table = this.organization.isTable();
        XmlString xs = new XmlString(1);
        if (table) {
            tag = "XDFTABLE";
            xs.append("XDFTABLE uniqueid=\"0x0\" flags=\"0x0\"");
        } else {
            tag = "XDFCONSTANT";
            xs.append("XDFCONSTANT uniqueid=\"0x0\"");
        }
        xs.indent();
        String title = "";
        Object desc = "";
        if (this.id.length() > 0) {
            title = this.id.split(" ")[0];
            desc = this.name.trim();
            if (this.comment != null) {
                desc = (String)desc + "\r\n" + this.comment.trim();
            }
        } else {
            title = this.name;
            if (this.comment != null) {
                desc = this.comment.trim();
            }
        }
        xs.append("title", title);
        xs.append("description", desc);
        xs.append("CATEGORYMEM index=\"0\" category=\"" + (this.folderId + 1) + "\" /");
        if (table) {
            this.tableToXDF(xs);
        } else {
            this.constantToXDF(xs);
        }
        xs.unindent();
        return xs.append("/" + tag).toString();
    }

    public String toStringDump() {
        String out = "index: " + this.index + "\n";
        out = out + "   h0: " + this.header0 + "\n";
        if (this.kpv == 2) {
            out = out + " *h0a: " + this.header0a + "\n";
            out = out + " *cmt: " + this.comment + "\n";
            out = out + " *h0b: " + this.header0b + "\n";
        }
        out = out + "  map: " + this.name + " [" + this.id + "] " + String.valueOf(this.value.type) + "\n";
        out = out + "  org: " + String.valueOf(this.organization) + "\n";
        out = out + "    h: " + this.header + "\n";
        out = out + "   ha: " + this.headera + "\n";
        out = out + " base: " + this.base + "\n";
        out = out + "fdrId: " + this.folderId + "\n";
        out = out + "   id: " + this.id + "\n";
        out = out + "   h1: " + this.header1 + "\n";
        out = out + "  h1a: " + this.header1a + " (byte)\n";
        if (this.kpv == 2) {
            out = out + " *h1b: " + this.header1b + "\n";
        }
        out = out + "range: " + this.range[0] + "-" + this.range[2] + "\n";
        out = out + "   h2: " + Arrays.toString(this.header2) + "\n";
        out = out + "flags: ";
        if (this.reciprocal) {
            out = out + "R";
        }
        if (this.value.sign) {
            out = out + "S";
        }
        if (this.difference) {
            out = out + "D";
        }
        if (this.percent) {
            out = out + "P";
        }
        out = out + "\n";
        out = out + " size: " + String.valueOf(this.size) + "\n";
        out = out + "   h3: " + Arrays.toString(this.header3) + "\n";
        out = out + " prec: " + this.value.precision + "\n";
        out = out + "value: " + String.valueOf(this.value) + "\n";
        out = out + " addr: " + Arrays.toString(this.extent) + "\n";
        out = out + "   h4: " + String.valueOf(this.header4) + "\n";
        if (this.kpv == 2) {
            out = out + " *h4a: " + Arrays.toString(this.header4a) + "\n";
        }
        out = out + "addr?: " + String.valueOf(this.extent2) + "\n";
        out = out + "   h5: " + Arrays.toString(this.header5) + "\n";
        out = out + "   h6: " + String.valueOf(this.header6) + "\n";
        out = out + "   h7: " + this.header7 + "\n";
        out = out + "xaxis: " + String.valueOf(this.x_axis) + "\n";
        out = out + "yaxis: " + String.valueOf(this.y_axis) + "\n";
        out = out + "   h8: " + this.header8 + "\n";
        out = out + "  h8a: " + this.header8a + " (short)\n";
        out = out + "   h9: " + Arrays.toString(this.header9) + "\n";
        out = out + "  h9a: " + Arrays.toString(this.header9a) + " (shorts)\n";
        out = out + "  h9b: " + this.header9b + "\n";
        out = out + "  h9c: " + this.header9c + " (byte)\n";
        out = out + "  h10: " + Arrays.toString(this.header10) + "\n";
        out = out + "  h11: " + Arrays.toString(this.header11) + "\n";
        out = out + "term2: " + Arrays.toString(this.term2) + "\n";
        out = out + "zaxis: " + String.valueOf(this.z_axis) + "\n";
        return out;
    }

    @Override
    public int compareTo(Object o) {
        Map them = (Map)o;
        int ret = this.extent[0].v - them.extent[0].v;
        return ret == 0 ? this.index - them.index : ret;
    }

    private class Organization
    extends Enm {
        public Organization(Map map, ByteBuffer b) {
            super(map, b);
            String[] l = new String[]{"??", "??", "Single value", "Onedimensional", "Twodimensional", "2d Inverse"};
            this.legend = l;
        }

        public boolean isTable() {
            return this.enm > 2 && this.enm < 6;
        }

        public boolean is1D() {
            return this.enm == 3;
        }
    }

    public class ValueType
    extends Enm {
        private int width;

        public ValueType(Map this$0, int width, int enm) {
            super(this$0, enm);
            this.width = width;
        }

        public ValueType(Map this$0, ByteBuffer b) {
            super(this$0, b);
            String[] l = new String[]{"??", "8 Bit", "16 Bit (HiLo)", "16 Bit (LoHi)", "32 Bit (HiLoHilo)", "32 Bit (LoHiLoHi)", "32 BitFloat (HiLoHiLo)", "32 BitFloat (LoHiLoHi)"};
            this.legend = l;
            switch (this.enm) {
                case 1: {
                    this.width = 1;
                    break;
                }
                case 2: 
                case 3: {
                    this.width = 2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.width = 4;
                    break;
                }
                default: {
                    this.width = 0;
                }
            }
        }

        public boolean isLE() {
            return this.enm > 1 && (this.enm & 1) == 1;
        }

        public int width() {
            return this.width;
        }
    }

    public class Dimension
    implements Comparable<Object> {
        public int x;
        public int y;

        public Dimension(Map this$0, int xx, int yy) {
            this.x = xx;
            this.y = yy;
        }

        public Dimension(Map this$0, ByteBuffer b) {
            this.x = b.getInt();
            this.y = b.getInt();
        }

        public String toString() {
            return this.x + "x" + this.y;
        }

        @Override
        public int compareTo(Object o) {
            return Integer.valueOf(this.areaOf()).compareTo(((Dimension)o).areaOf());
        }

        public int areaOf() {
            return this.x * this.y;
        }
    }

    public class Value {
        public String description;
        public String units;
        public double factor;
        public double offset;
        public ValueType type = null;
        public int precision = 0;
        public boolean sign = false;

        public String toString() {
            return "(" + this.description + ")/" + this.units + " -  f/o: " + this.factor + "/" + this.offset;
        }

        protected Value(Map this$0, ByteBuffer b) throws ParserException {
            this.description = Parse.string(b);
            this.units = Parse.string(b);
            this.factor = b.getDouble();
            this.offset = b.getDouble();
        }

        public Value(Map this$0, ByteBuffer b, ValueType vt, boolean s, int p) throws ParserException {
            this(this$0, b);
            this.type = vt;
            this.sign = s;
            this.precision = p;
            this.limitPrecision(6);
        }

        public double convert(double in) {
            return in * this.factor + this.offset;
        }

        public String eqOldXDF(int off, String tag) {
            Object out = "";
            if (this.factor != 1.0 || this.offset != 0.0) {
                out = (String)out + String.format("\t%06d %-17s=%f * X", off, tag, this.factor);
                if (this.offset != 0.0) {
                    out = (String)out + String.format("+ %f", this.offset);
                }
                out = (String)out + ",TH|0|0|0|0|\n";
            }
            return out;
        }

        public String eqXDF() {
            Object out = "X";
            if (this.factor != 1.0 || this.offset != 0.0) {
                out = String.format("%f * X", this.factor);
                if (this.offset != 0.0) {
                    out = (String)out + String.format("+ %f", this.offset);
                }
            }
            return out;
        }

        public String outputtypeXDF(int base) {
            if (this.precision == 0) {
                return base == 16 ? "3" : "2";
            }
            return "";
        }

        protected int limitPrecision(int maxDigits) {
            int width = this.sign ? this.type.width() * 8 - 1 : this.type.width() * 8;
            double max = this.convert((1 << width) - 1);
            int intdigits = (int)(Math.floor(Math.log10(max)) + 1.0);
            int digits = this.precision + intdigits;
            if (digits > maxDigits) {
                this.precision = maxDigits > intdigits ? maxDigits - intdigits : 0;
            }
            return this.precision;
        }

        protected void doMathXDF(XmlString xs) {
            this.doMathXDF(xs, this.eqXDF());
        }

        protected void doMathXDF(XmlString xs, String x) {
            xs.append("MATH equation=\"" + x + "\"");
            xs.indent();
            xs.append("VAR id=\"X\" /");
            xs.unindent();
            xs.append("/MATH");
        }
    }

    private class Axis {
        private String name;
        private final int size;
        private Dimension z_size;
        public Value value;
        public DataSource datasource;
        public HexValue addr = null;
        private int header1;
        public int base;
        private final int[] header1a = new int[3];
        private byte header2;
        public boolean reciprocal = false;
        private final byte[] header3 = new byte[3];
        private int header4_size;
        private int[] header4;
        private int header5;
        public HexValue signature = null;
        private boolean isZ = false;

        public Axis(ByteBuffer b, String n, int s) throws ParserException {
            this.value = new Value(Map.this, b);
            this.datasource = new DataSource(Map.this, b);
            this.addr = new HexValue(b);
            if (!this.datasource.isEeprom()) {
                this.addr = null;
            }
            this.value.type = new ValueType(Map.this, b);
            this.header1 = b.getInt();
            this.base = b.getInt();
            if (!this.datasource.isEeprom()) {
                this.base = 10;
            }
            if (Map.this.kpv == 2) {
                Parse.buffer(b, this.header1a);
            }
            this.header2 = b.get();
            this.reciprocal = b.get() == 1;
            this.value.precision = b.get();
            Parse.buffer(b, this.header3);
            this.value.sign = b.get() == 1;
            this.header4_size = b.getInt();
            this.header4 = new int[this.header4_size / 4];
            Parse.buffer(b, this.header4);
            this.header5 = b.getInt();
            this.signature = new HexValue(b);
            this.value.limitPrecision(6);
            this.name = n;
            this.size = s;
        }

        public Axis(Value v, Map m) {
            this.value = v;
            this.datasource = new DataSource(Map.this);
            this.addr = m.extent[0];
            this.base = m.base;
            this.name = "z";
            this.size = 0;
            this.z_size = m.size;
            this.isZ = true;
        }

        public String toString() {
            String out = super.toString() + "\n";
            out = out + "\t   ds: " + String.valueOf(this.datasource) + "\n";
            out = out + "\t addr: " + String.valueOf(this.addr) + " " + String.valueOf(this.value.type) + "\n";
            out = out + "\t   h1: " + this.header1 + "\n";
            if (Map.this.kpv == 2) {
                out = out + "\t *h1a: " + Arrays.toString(this.header1a) + "\n";
            }
            out = out + "\t base: " + this.base + "\n";
            out = out + "\t   h2: " + this.header2 + " (short)\n";
            out = out + "\tflags: ";
            if (this.reciprocal) {
                out = out + "R";
            }
            if (this.value.sign) {
                out = out + "S";
            }
            out = out + "\n";
            out = out + "\t prec: " + this.value.precision + " (byte)\n";
            out = out + "\t   h3: " + Arrays.toString(this.header3) + "\n";
            out = out + "\th4_sz: " + this.header4_size + "\n";
            out = out + "\t   h4: " + Arrays.toString(this.header4) + "\n";
            out = out + "\t   h5: " + this.header5 + "\n";
            if (this.signature != null && this.signature.v != -1) {
                out = out + "\t  sig: " + String.valueOf(this.signature) + "\n";
            }
            return out;
        }

        public String toXDF(XmlString xs) {
            int xsAt = xs.length();
            if (!this.isZ) {
                xs.append("XDFAXIS id=\"" + this.name + "\" uniqueid=\"0x0\"");
            } else {
                xs.append("XDFAXIS id=\"" + this.name + "\"");
            }
            xs.indent();
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            if (this.datasource.isOrdinal()) {
                m.put("mmedelementsizebits", 16);
                m.put("mmedmajorstridebits", -32);
                xs.append("EMBEDDEDDATA", m);
                xs.append("units", this.value.units);
                xs.append("indexcount", this.size);
                if (this.value.precision != 2) {
                    xs.append("decimalpl", this.value.precision);
                }
                xs.append("outputtype", this.value.outputtypeXDF(this.base));
                xs.append("datatype", 0);
                xs.append("unittype", 0);
                xs.append("DALINK index=\"0\" /");
                this.genLabelsXDF(xs);
            } else {
                int flags;
                int n = flags = this.value.sign ? 1 : 0;
                if (this.value.type.isLE()) {
                    flags |= 2;
                }
                if (flags != 0) {
                    m.put("mmedtypeflags", String.format("0x%02X", flags));
                }
                m.put("mmedaddress", String.format("0x%X", this.addr.v));
                m.put("mmedelementsizebits", this.value.type.width() * 8);
                if (this.isZ) {
                    m.put("mmedrowcount", this.z_size.y);
                    if (this.z_size.x > 1) {
                        m.put("mmedcolcount", this.z_size.x);
                    }
                } else {
                    m.put("mmedmajorstridebits", this.value.type.width() * 8);
                }
                xs.append("EMBEDDEDDATA", m);
                xs.append("units", this.value.units);
                if (!this.isZ) {
                    xs.append("indexcount", this.size);
                }
                if (this.value.precision != 2 || this.isZ) {
                    xs.append("decimalpl", this.value.precision);
                }
                if (this.isZ) {
                    xs.append("min", "0.000000");
                    xs.append("max", "255.000000");
                    if (this.value.precision != 0) {
                        xs.append("outputtype", 1);
                    }
                }
                xs.append("outputtype", this.value.outputtypeXDF(this.base));
                if (!this.isZ) {
                    xs.append("embedinfo type=\"1\" /");
                }
                if (!this.isZ) {
                    xs.append("datatype", 0);
                    xs.append("unittype", 0);
                    xs.append("DALINK index=\"0\" /");
                }
                this.value.doMathXDF(xs);
            }
            xs.unindent();
            xs.append("/XDFAXIS");
            return xs.subSequence(xsAt, xs.length()).toString();
        }

        private void genLabelsXDF(XmlString xs) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (int i = 0; i < this.size; ++i) {
                m.put("index", i);
                if (this.size == 1) {
                    // empty if block
                }
                if (i == 0 && this.value.precision == 0) {
                    m.put("value", "");
                } else {
                    m.put("value", String.format("%." + this.value.precision + "f", this.value.convert(i)));
                }
                xs.append("LABEL", m);
            }
            this.value.doMathXDF(xs, "X");
        }
    }

    private class DataSource
    extends Enm {
        private final String[] l = new String[]{"1,2,3", "EEPROM", "EEPROM, add", "EEPROM, subtract", "Free editable"};

        public DataSource(Map map, ByteBuffer b) {
            super(map, b);
            this.legend = this.l;
        }

        public DataSource(Map map) {
            super(map, 1);
            this.legend = this.l;
        }

        public boolean isEeprom() {
            return this.enm > 0 && this.enm < 4;
        }

        public boolean isOrdinal() {
            return this.enm == 0 || this.enm == 4;
        }
    }

    private class Enm
    implements Comparable<Object> {
        protected int enm;
        public String[] legend;

        public Enm(Map map, ByteBuffer b) {
            this.enm = b.getInt();
        }

        public Enm(Map map, int enm) {
            this.enm = enm;
        }

        public String toString() {
            if (this.enm < 0 || this.enm > this.legend.length - 1) {
                return String.format("(len %d) %x", this.legend.length, this.enm);
            }
            return this.legend[this.enm];
        }

        @Override
        public int compareTo(Object o) {
            return Integer.valueOf(this.enm).compareTo(((Enm)o).enm);
        }
    }
}

