/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.util;

import java.lang.reflect.Method;
import java.net.URI;
import org.nyet.ecuxplot.MessageDialog;

public class BrowserLaunch {
    private static final String errMsg = "Error attempting to launch web browser";

    public static void openURL(String url) {
        try {
            Class<?> Desktop2 = Class.forName("java.awt.Desktop");
            Method isDesktopSupported = Desktop2.getDeclaredMethod("isDesktopSupported", new Class[0]);
            if (((Boolean)isDesktopSupported.invoke(null, new Object[0])).booleanValue()) {
                Method getDesktop = Desktop2.getDeclaredMethod("getDesktop", new Class[0]);
                Method browse = Desktop2.getDeclaredMethod("browse", URI.class);
                Object desktop = getDesktop.invoke(null, new Object[0]);
                browse.invoke(desktop, new URI(url));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BrowserLaunch.fallback(url);
    }

    private static void fallback(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url).start();
            } else {
                String[] browsers = new String[]{"firefox", "iceweasel", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int i = 0; i < browsers.length && browser == null; ++i) {
                    if (new ProcessBuilder("which", browsers[i]).start().waitFor() != 0) continue;
                    browser = browsers[i];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                new ProcessBuilder(browser, url).start();
            }
        }
        catch (Exception e) {
            MessageDialog.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }
}

