/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.LookupTranslator;

public class XmlString
implements CharSequence,
Appendable {
    private final StringBuffer buf = new StringBuffer();
    private int ShiftWidth = 2;
    private int Indent = 0;
    private static final String EOL = "\n";
    private final LookupTranslator lt;

    public XmlString() {
        HashMap<CharSequence, CharSequence> sb = new HashMap<CharSequence, CharSequence>(){
            private static final long serialVersionUID = 1L;
            {
                for (int i = 0; i < 128; i = (int)((char)(i + 1))) {
                    this.put(String.format("%c", i + 128), "&#" + (i + 128) + ";");
                }
            }
        };
        this.lt = new LookupTranslator((Map<CharSequence, CharSequence>)sb);
    }

    public XmlString(int i) {
        this();
        this.indent(i);
    }

    public XmlString(String s) {
        this();
        this.append(s);
    }

    public XmlString(int i, String s) {
        this();
        this.indent(i);
        this.append(s);
    }

    @Override
    public String toString() {
        return this.buf.toString();
    }

    @Override
    public char charAt(int index) {
        return this.buf.charAt(index);
    }

    @Override
    public int length() {
        return this.buf.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buf.subSequence(start, end);
    }

    private String escape(String s) {
        return this.lt.translate(StringEscapeUtils.escapeXml11(s.trim())).replaceAll("\r", "&#013;").replaceAll(EOL, "&#010;");
    }

    private Appendable tagIt(String tag, Object value) {
        tag = this.escape(tag);
        String v = this.escape(value.toString());
        return this.append(String.format("%s>%s</%s", tag, v, tag));
    }

    @Override
    public Appendable append(char c) {
        return this.buf.append(c);
    }

    @Override
    public Appendable append(CharSequence cs, int start, int end) {
        return this.append(cs.subSequence(start, end));
    }

    @Override
    public Appendable append(CharSequence cs) {
        return this.append(cs.toString());
    }

    public Appendable append(String s) {
        this.doIndent();
        return this.buf.append("<" + s + ">\n");
    }

    public Appendable append(String tag, Object value) {
        if (tag.length() <= 0) {
            return this.buf;
        }
        if (value == null) {
            return this.append(this.escape(tag));
        }
        if (value.toString().length() <= 0) {
            return this.buf;
        }
        return this.tagIt(tag, value);
    }

    public Appendable append(String tag, Map<String, Object> attrs) {
        this.doIndent();
        this.buf.append(String.format("<%s", this.escape(tag)));
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String k = this.escape(e.getKey());
            String v = this.escape(e.getValue().toString());
            this.buf.append(String.format(" %s=\"%s\"", k, v));
        }
        return this.buf.append(" />\n");
    }

    private Appendable doIndent() {
        if (this.Indent > 0) {
            this.buf.append(String.format("%" + this.ShiftWidth * this.Indent + "s", " "));
        }
        return this.buf;
    }

    public int shiftWidth() {
        return this.ShiftWidth;
    }

    public void shiftWidth(int sw) {
        this.ShiftWidth = sw;
    }

    public int indent() {
        return this.Indent++;
    }

    public int indent(int i) {
        int ret = this.Indent;
        this.Indent += i;
        return ret;
    }

    public int unindent() {
        return this.Indent--;
    }
}

