/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.nyet.ecuxplot.ECUxPlot;
import org.nyet.ecuxplot.Preset;
import org.nyet.util.Strings;

public class ECUxPreset
extends Preset {
    private static boolean detectOldPrefs(Preferences prefs) {
        String[] names = null;
        boolean ret = false;
        try {
            names = prefs.childrenNames();
        }
        catch (Exception e) {
            return false;
        }
        for (String s : names) {
            Preferences n = prefs.node(s);
            try {
                if (!n.nodeExists("ykeys") && !n.nodeExists("ykeys2")) continue;
                n.removeNode();
                ret = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret) {
            ECUxPreset.createDefaultECUxPresets();
            JOptionPane.showMessageDialog(null, "Old presets detected. Resetting to default.");
        }
        return ret;
    }

    public static Preferences getPreferencesStatic() {
        Preferences p = Preferences.userNodeForPackage(ECUxPlot.class).node("presets");
        ECUxPreset.detectOldPrefs(p);
        return p;
    }

    @Override
    public Preferences getPreferences() {
        return ECUxPreset.getPreferencesStatic();
    }

    public static void createDefaultECUxPresets() {
        new ECUxPreset((Comparable<?>)((Object)"Power"), (Comparable<?>)((Object)"RPM"), (Comparable<?>[])new String[]{"WHP", "WTQ", "HP", "TQ"}, (Comparable<?>[])new String[]{"BoostPressureDesired (PSI)", "BoostPressureActual (PSI)"});
        new ECUxPreset((Comparable<?>)((Object)"Timing"), (Comparable<?>)((Object)"RPM"), (Comparable<?>[])new String[]{"EngineLoad"}, (Comparable<?>[])new String[]{"IgnitionTimingAngleOverall", "IgnitionTimingAngleOverallDesired"}, true);
        new ECUxPreset((Comparable<?>)((Object)"Fueling"), (Comparable<?>)((Object)"RPM"), (Comparable<?>[])new String[]{"Zeitronix AFR", "Sim AFR"}, (Comparable<?>[])new String[]{"Zeitronix Boost (PSI)", "BoostPressureDesired (PSI)", "BoostPressureActual (PSI)"});
        new ECUxPreset((Comparable<?>)((Object)"Compressor Map"), (Comparable<?>)((Object)"Turbo Flow"), (Comparable<?>)((Object)"BoostActual PR"));
        new ECUxPreset((Comparable<?>)((Object)"Spool Rate"), (Comparable<?>)((Object)"BoostPressureActual (PSI)"), (Comparable<?>)((Object)"Boost Spool Rate (RPM)"), (Comparable<?>)((Object)"Boost Spool Rate (time)"));
    }

    public ECUxPreset(Comparable<?> name) {
        super(name);
    }

    public ECUxPreset(Comparable<?> name, Comparable<?> xkey, Comparable<?>[] ykeys) {
        this(name, xkey, ykeys, new Comparable[0]);
    }

    public ECUxPreset(Comparable<?> name, Comparable<?> xkey, Comparable<?> ykey) {
        this(name, xkey, new Comparable[]{ykey}, new Comparable[0]);
    }

    public ECUxPreset(Comparable<?> name, Comparable<?> xkey, Comparable<?> ykey, Comparable<?> ykey2) {
        this(name, xkey, new Comparable[]{ykey}, new Comparable[]{ykey2});
    }

    public ECUxPreset(Comparable<?> name, Comparable<?> xkey, Comparable<?>[] ykeys, Comparable<?>[] ykeys2) {
        this(name, xkey, ykeys, ykeys2, false);
    }

    public ECUxPreset(Comparable<?> name, Comparable<?> xkey, Comparable<?>[] ykeys, Comparable<?>[] ykeys2, boolean scatter) {
        super(name);
        this.xkey(xkey);
        this.ykeys(0, ykeys);
        this.ykeys(1, ykeys2);
        this.scatter(scatter);
    }

    public String tag() {
        return this.prefs.get("tag", this.prefs.name());
    }

    public Comparable<?> xkey() {
        return this.prefs.get("xkey", null);
    }

    public Comparable<?>[] ykeys(int which) {
        return this.getArray((Comparable<?>)((Object)(which == 0 ? "ykeys0" : "ykeys1")));
    }

    public Boolean scatter() {
        return this.prefs.getBoolean("scatter", false);
    }

    public void tag(String tag) {
        this.prefs.put("tag", tag);
    }

    public void xkey(Comparable<?> xkey) {
        this.prefs.put("xkey", xkey.toString());
    }

    public void ykeys(int which, Comparable<?>[] ykeys) {
        this.putArray((Comparable<?>)((Object)(which == 0 ? "ykeys0" : "ykeys1")), ykeys);
    }

    public void scatter(Boolean scatter) {
        this.prefs.putBoolean("scatter", scatter);
    }

    @Override
    public String toString() {
        return this.prefs.name() + ": \"" + String.valueOf(this.xkey()) + "\" vs \"" + Strings.join(", ", this.ykeys(0)) + "\" and \"" + Strings.join(", ", this.ykeys(1)) + "\"";
    }

    public static String[] getPresets() {
        String[] ret = null;
        for (int i = 0; i < 2; ++i) {
            try {
                ret = ECUxPreset.getPreferencesStatic().childrenNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ECUxPreset.createDefaultECUxPresets();
        }
        return new String[0];
    }
}

