/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.nyet.ecuxplot.ECUxChartFactory;
import org.nyet.ecuxplot.ECUxChartPanel;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.ECUxPlot;
import org.nyet.ecuxplot.FATS;
import org.nyet.ecuxplot.FATSDataset;

public class FATSChartFrame
extends ChartFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final FATSDataset dataset;
    private final ECUxPlot plotFrame;
    private final JTextField start;
    private final JTextField end;
    private final FATS fats;
    private JCheckBox useMphCheckbox;
    private JLabel startLabel;
    private JLabel endLabel;
    private JTextField rpmPerMphField;
    private JLabel rpmPerMphLabel;

    public static FATSChartFrame createFATSChartFrame(TreeMap<String, ECUxDataset> fileDatasets, ECUxPlot plotFrame) {
        FATS fats = plotFrame.fats;
        FATSDataset dataset = new FATSDataset(fileDatasets, fats);
        JFreeChart chart = ECUxChartFactory.createFATSChart(dataset);
        return new FATSChartFrame(chart, dataset, plotFrame, fats);
    }

    public FATSChartFrame(JFreeChart chart, FATSDataset dataset, ECUxPlot plotFrame, FATS fats) {
        super("FATS Time", chart);
        this.dataset = dataset;
        this.plotFrame = plotFrame;
        this.fats = fats;
        CategoryPlot plot = chart.getCategoryPlot();
        plot.getRangeAxis().setLabel("seconds");
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("##.##")));
        renderer.setBaseItemLabelsVisible(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        ECUxChartPanel chartPanel = new ECUxChartPanel(chart);
        chartPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        chartPanel.setDomainZoomable(false);
        chartPanel.setRangeZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        panel.add((Component)((Object)chartPanel), "Center");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 3));
        controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 2));
        this.startLabel = new JLabel();
        this.endLabel = new JLabel();
        if (this.fats.useMph()) {
            this.start = new JTextField("" + this.fats.startMph(), 3);
            this.end = new JTextField("" + this.fats.endMph(), 3);
            this.startLabel.setText("Start MPH:");
            this.endLabel.setText("End MPH:");
        } else {
            this.start = new JTextField("" + this.fats.start(), 3);
            this.end = new JTextField("" + this.fats.end(), 3);
            this.startLabel.setText("Start RPM:");
            this.endLabel.setText("End RPM:");
        }
        inputPanel.add(this.startLabel);
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        inputPanel.add(this.start);
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        inputPanel.add(new JLabel(" to "));
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        inputPanel.add(this.end);
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        inputPanel.add(this.endLabel);
        inputPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.rpmPerMphLabel = new JLabel("RPM/MPH:");
        this.rpmPerMphField = new JTextField("" + this.plotFrame.env.c.rpm_per_mph(), 4);
        inputPanel.add(this.rpmPerMphLabel);
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        inputPanel.add(this.rpmPerMphField);
        controlPanel.add(inputPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.useMphCheckbox = new JCheckBox("Use MPH");
        this.useMphCheckbox.setSelected(this.fats.useMph());
        this.useMphCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FATSChartFrame.this.fats.useMph(FATSChartFrame.this.useMphCheckbox.isSelected());
                FATSChartFrame.this.updateLabelsAndValues(FATSChartFrame.this.startLabel, FATSChartFrame.this.endLabel, FATSChartFrame.this.start, FATSChartFrame.this.end);
                FATSChartFrame.this.updateRpmPerMphVisibility();
            }
        });
        buttonPanel.add(this.useMphCheckbox);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton apply = new JButton("Apply");
        apply.addActionListener(this);
        this.getRootPane().setDefaultButton(apply);
        buttonPanel.add(apply);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton defaults = new JButton("Defaults");
        defaults.addActionListener(this);
        buttonPanel.add(defaults);
        controlPanel.add(buttonPanel);
        panel.add((Component)controlPanel, "Last");
        this.setContentPane(panel);
        this.setPreferredSize(this.windowSize());
        this.restoreLocation();
        this.updateRpmPerMphVisibility();
    }

    private void restoreLocation() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        Dimension s = this.windowSize();
        Point pl = this.plotFrame.getLocation();
        Point l = this.windowLocation();
        l.translate(pl.x, pl.y);
        if (l.x < 0) {
            l.x = 0;
        }
        if (l.y < 0) {
            l.y = 0;
        }
        if (l.x + s.width > d.width - s.width) {
            l.x = d.width - s.width;
        }
        if (l.y + s.height > d.height - s.width) {
            l.y = d.height - s.height;
        }
        super.setLocation(l);
    }

    public void setDatasets(TreeMap<String, ECUxDataset> fileDatasets) {
        this.dataset.clear();
        for (ECUxDataset data : fileDatasets.values()) {
            this.setDataset(data);
        }
    }

    public void setDataset(ECUxDataset data) {
        this.dataset.setValue(data);
    }

    public void clearDataset() {
        this.dataset.clear();
    }

    public void refreshFromFATS() {
        this.dataset.refreshFromFATS();
        if (this.fats.useMph()) {
            this.start.setText("" + this.fats.startMph());
            this.end.setText("" + this.fats.endMph());
        } else {
            this.start.setText("" + this.fats.start());
            this.end.setText("" + this.fats.end());
        }
        this.getChartPanel().getChart().setTitle(this.dataset.getTitle());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Apply")) {
            if (this.fats.useMph()) {
                this.fats.startMph(Double.valueOf(this.start.getText()));
                this.fats.endMph(Double.valueOf(this.end.getText()));
                if (this.rpmPerMphField != null && this.rpmPerMphField.isVisible()) {
                    this.plotFrame.env.c.rpm_per_mph(Double.valueOf(this.rpmPerMphField.getText()));
                }
            } else {
                this.fats.start(Integer.valueOf(this.start.getText()));
                this.fats.end(Integer.valueOf(this.end.getText()));
            }
            this.dataset.refreshFromFATS();
        } else if (event.getActionCommand().equals("Defaults")) {
            this.fats.useMph(false);
            this.fats.start(4200);
            this.fats.end(6500);
            this.dataset.refreshFromFATS();
            this.start.setText("4200");
            this.end.setText("6500");
            this.useMphCheckbox.setSelected(false);
            this.updateRpmPerMphVisibility();
        }
        this.getChartPanel().getChart().setTitle(this.dataset.getTitle());
    }

    private void updateLabelsAndValues(JLabel startLabel, JLabel endLabel, JTextField start, JTextField end) {
        if (this.fats.useMph()) {
            startLabel.setText("Start MPH:");
            endLabel.setText("End MPH:");
            start.setText("" + this.fats.startMph());
            end.setText("" + this.fats.endMph());
        } else {
            startLabel.setText("Start RPM:");
            endLabel.setText("End RPM:");
            start.setText("" + this.fats.start());
            end.setText("" + this.fats.end());
        }
    }

    private void updateRpmPerMphVisibility() {
        if (this.rpmPerMphField != null && this.rpmPerMphLabel != null) {
            boolean shouldShow = this.fats.useMph() && this.dataset.needsRpmPerMphConversion();
            this.rpmPerMphField.setVisible(shouldShow);
            this.rpmPerMphLabel.setVisible(shouldShow);
            if (shouldShow) {
                this.rpmPerMphField.setText("" + this.plotFrame.env.c.rpm_per_mph());
            }
        }
    }

    private Dimension windowSize() {
        return new Dimension(ECUxPlot.getPreferences().getInt("FATSWindowWidth", 300), ECUxPlot.getPreferences().getInt("FATSWindowHeight", 400));
    }

    private void putWindowSize() {
        ECUxPlot.getPreferences().putInt("FATSWindowWidth", this.getWidth());
        ECUxPlot.getPreferences().putInt("FATSWindowHeight", this.getHeight());
    }

    private Point windowLocation() {
        return new Point(ECUxPlot.getPreferences().getInt("FATSWindowX", this.plotFrame.getWidth()), ECUxPlot.getPreferences().getInt("FATSWindowY", 0));
    }

    private void putWindowLocation() {
        Point l = this.getLocation();
        Point pl = this.plotFrame.getLocation();
        l.translate(-pl.x, -pl.y);
        ECUxPlot.getPreferences().putInt("FATSWindowX", l.x);
        ECUxPlot.getPreferences().putInt("FATSWindowY", l.y);
    }

    public void dispose() {
        this.putWindowSize();
        this.putWindowLocation();
        this.plotFrame.prefs.putBoolean("showfats", false);
        this.plotFrame.optionsMenu.updateFATSCheckbox();
        super.dispose();
    }

    public void saveChartAsPNG(File f) throws IOException {
        ChartUtilities.saveChartAsPNG((File)f, (JFreeChart)this.getChartPanel().getChart(), (int)this.getWidth(), (int)this.getHeight());
    }

    public void saveChartAsPNG(String filename) throws IOException {
        this.saveChartAsPNG(new File(filename));
    }
}

