/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.TreeMap;
import org.jfree.data.category.DefaultCategoryDataset;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.FATS;
import org.nyet.util.Files;

public class FATSDataset
extends DefaultCategoryDataset {
    private static final long serialVersionUID = 1L;
    private int start = 4200;
    private int end = 6500;
    private final TreeMap<String, ECUxDataset> fileDatasets;
    private final FATS fats;

    public FATSDataset(TreeMap<String, ECUxDataset> fileDatasets, FATS fats) {
        this.fileDatasets = fileDatasets;
        this.fats = fats;
        this.updateFromFATS();
        this.rebuild();
    }

    private void updateFromFATS() {
        if (this.fats.useMph()) {
            boolean hasVehicleSpeed = this.hasVehicleSpeedData();
            if (hasVehicleSpeed) {
                this.start = (int)Math.round(this.fats.startMph());
                this.end = (int)Math.round(this.fats.endMph());
            } else if (!this.fileDatasets.isEmpty()) {
                ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
                double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
                this.start = this.fats.mphToRpm(this.fats.startMph(), rpmPerMph);
                this.end = this.fats.mphToRpm(this.fats.endMph(), rpmPerMph);
            }
        } else {
            this.start = this.fats.start();
            this.end = this.fats.end();
        }
    }

    boolean hasVehicleSpeedData() {
        for (ECUxDataset dataset : this.fileDatasets.values()) {
            if (dataset.get((Comparable<?>)((Object)"VehicleSpeed")) == null) continue;
            return true;
        }
        return false;
    }

    boolean needsRpmPerMphConversion() {
        for (ECUxDataset dataset : this.fileDatasets.values()) {
            if (dataset.get((Comparable<?>)((Object)"VehicleSpeed")) != null) continue;
            return true;
        }
        return false;
    }

    private void rebuild() {
        for (ECUxDataset data : this.fileDatasets.values()) {
            this.setValue(data);
        }
    }

    public void setValue(ECUxDataset data, int series, double value) {
        String xkey = Files.stem(data.getFileId());
        String ykey = "Run " + (series + 1);
        super.setValue(value, (Comparable)((Object)xkey), (Comparable)((Object)ykey));
    }

    public void removeValue(ECUxDataset data, int series) {
        String xkey = Files.stem(data.getFileId());
        String ykey = "Run " + (series + 1);
        super.removeValue((Comparable)((Object)xkey), (Comparable)((Object)ykey));
    }

    public void setValue(ECUxDataset data) {
        try {
            this.removeRow((Comparable)((Object)Files.stem(data.getFileId())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < data.getRanges().size(); ++i) {
            this.setValue(data, i);
        }
    }

    public void setValue(ECUxDataset data, int series) {
        try {
            double value = this.fats.useMph() ? data.calcFATSBySpeed(series, this.fats.startMph(), this.fats.endMph()) : data.calcFATS(series, this.start, this.end);
            this.setValue(data, series, value);
        }
        catch (Exception e) {
            this.removeValue(data, series);
        }
    }

    public void removeValue(ECUxDataset data) {
        for (int i = 0; i < data.getRanges().size(); ++i) {
            this.removeValue(data, i);
        }
    }

    public void setStart(int start) {
        if (this.fats.useMph()) {
            if (!this.fileDatasets.isEmpty()) {
                ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
                double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
                this.fats.startMph(this.fats.rpmToMph(start, rpmPerMph));
            }
        } else {
            this.fats.start(start);
        }
        this.updateFromFATS();
        this.rebuild();
    }

    public void setEnd(int end) {
        if (this.fats.useMph()) {
            if (!this.fileDatasets.isEmpty()) {
                ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
                double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
                this.fats.endMph(this.fats.rpmToMph(end, rpmPerMph));
            }
        } else {
            this.fats.end(end);
        }
        this.updateFromFATS();
        this.rebuild();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void refreshFromFATS() {
        this.updateFromFATS();
        this.rebuild();
    }

    public String getTitle() {
        if (this.fats.useMph()) {
            if (this.hasVehicleSpeedData()) {
                return String.format("%d-%d MPH (VehicleSpeed)", Math.round(this.fats.startMph()), Math.round(this.fats.endMph()));
            }
            return String.format("%d-%d MPH (Calculated)", Math.round(this.fats.startMph()), Math.round(this.fats.endMph()));
        }
        return this.start + "-" + this.end + " RPM";
    }
}

