/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.nyet.ecuxplot.Constants;
import org.nyet.ecuxplot.FATS;
import org.nyet.ecuxplot.PreferencesEditor;

public class FATSEditor
extends PreferencesEditor {
    private static final long serialVersionUID = 1L;
    private final FATS s;
    public JTextField start;
    public JTextField end;
    public JCheckBox useMph;
    public JLabel startLabel;
    public JLabel endLabel;
    private static String[][] pairs = new String[][]{{"Start RPM", "start"}, {"End RPM", "end"}};
    private static int[] fieldSizes = new int[]{3, 3};

    @Override
    protected void Process(ActionEvent event) {
        if (this.useMph.isSelected()) {
            this.s.startMph(Double.valueOf(this.start.getText()));
            this.s.endMph(Double.valueOf(this.end.getText()));
        } else {
            this.s.start(Integer.valueOf(this.start.getText()));
            this.s.end(Integer.valueOf(this.end.getText()));
        }
        this.s.useMph(this.useMph.isSelected());
        super.Process(event);
    }

    public FATSEditor(Preferences prefs, FATS s, Constants c) {
        super(prefs.node("FATS"), pairs, fieldSizes);
        this.s = s;
        this.useMph = new JCheckBox("Use MPH instead of RPM");
        this.useMph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FATSEditor.this.updateLabels();
                FATSEditor.this.updateValues();
            }
        });
        Component[] components = this.getPrefsPanel().getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JLabel)) continue;
            if (i == 0) {
                this.startLabel = (JLabel)components[i];
                continue;
            }
            if (i != 2) continue;
            this.endLabel = (JLabel)components[i];
        }
        JPanel customPanel = new JPanel(new BorderLayout());
        JPanel mphPanel = new JPanel(new FlowLayout(0));
        mphPanel.add(this.useMph);
        customPanel.add((Component)mphPanel, "North");
        customPanel.add((Component)this.getPrefsPanel(), "Center");
        this.remove(this.getPrefsPanel());
        this.add((Component)customPanel, "Center");
    }

    @Override
    public void updateDialog() {
        this.useMph.setSelected(this.s.useMph());
        this.updateLabels();
        this.updateValues();
    }

    private void updateLabels() {
        if (this.useMph.isSelected()) {
            this.startLabel.setText("Start MPH:");
            this.endLabel.setText("End MPH:");
        } else {
            this.startLabel.setText("Start RPM:");
            this.endLabel.setText("End RPM:");
        }
    }

    private void updateValues() {
        if (this.useMph.isSelected()) {
            this.start.setText("" + this.s.startMph());
            this.end.setText("" + this.s.endMph());
        } else {
            this.start.setText("" + this.s.start());
            this.end.setText("" + this.s.end());
        }
    }
}

