/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealCommonSolver;
import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class EliminationSolver
extends RealCommonSolver {
    private char[] pivotIndex = null;

    public EliminationSolver() {
    }

    public EliminationSolver(int n, int n2) {
        super(new DenseMatrix(n, n2));
    }

    public EliminationSolver(DenseMatrix denseMatrix) {
        super(denseMatrix);
    }

    public EliminationSolver(RealContainer realContainer, int n, int n2) {
        super(new DenseMatrix(realContainer, n, n2));
    }

    public void attach(DenseMatrix denseMatrix) {
        super.attach(denseMatrix);
        this.pivotIndex = null;
    }

    protected void balance() {
        double d;
        int n = this.matrix.nRows;
        int n2 = this.matrix.nColumns;
        RealContainer realContainer = this.matrix.getContainer();
        int n3 = this.matrix.rowStep;
        int n4 = this.matrix.columnStep;
        double[] dArray = new double[n2];
        int n5 = 0;
        int n6 = this.matrix.startIndex;
        while (n5 < n2) {
            d = realContainer.normMax(n6, n3, n);
            dArray[n5] = d == 0.0 ? 1.0 : 1.0 / d;
            ++n5;
            n6 += n4;
        }
        DoublePointer doublePointer = new DoublePointer(dArray);
        double d2 = -1.0 / Math.log(16.0);
        if (this.balanceVector == null) {
            this.balanceVector = new double[n];
        }
        n5 = 0;
        n6 = this.matrix.startIndex;
        while (n5 < n) {
            d = realContainer.weightedNormSum(n6, n4, doublePointer, n2);
            if (d == 0.0) {
                d = 1.0;
            } else if ((d = RealMath.power(16.0, (int)Math.round(Math.log(d) * d2))) != 1.0) {
                realContainer.multiply(n6, n4, d, n2);
            }
            this.balanceVector[n5] = d;
            ++n5;
            n6 += n3;
        }
    }

    protected void doFactorize() {
        int n;
        RealContainer realContainer = this.matrix.getContainer();
        int n2 = this.matrix.nRows;
        int n3 = this.matrix.nColumns;
        int n4 = Math.min(n2, n3);
        int n5 = this.matrix.rowStep;
        int n6 = this.matrix.columnStep;
        int n7 = this.matrix.startIndex;
        double d = Math.max(this.matrix.relativeAccuracy() * 8.0, this.getReductionAccuracy());
        if (this.pivotIndex == null) {
            this.pivotIndex = new char[n4];
        }
        double[] dArray = new double[n4];
        DoublePointer doublePointer = new DoublePointer(dArray);
        int n8 = 0;
        int n9 = n = n7;
        int n10 = n;
        while (n8 < n3) {
            int n11 = this.range - 1;
            double d2 = -1.0;
            int n12 = this.range;
            int n13 = n9;
            int n14 = n10;
            while (n12 < n2) {
                double d3 = Math.abs(realContainer.add(n14, -realContainer.postProduct(n13, n6, n, n5, this.range)));
                if (d3 > d2) {
                    d2 = d3;
                    n11 = n12;
                }
                ++n12;
                n13 += n5;
                n14 += n5;
            }
            if ((n11 -= this.range) < 0 || realContainer.weightedNormSum(n, n5, doublePointer, this.range) >= Math.abs(realContainer.get(n10 + n11 * n5))) {
                this.prepareNullVector(n8);
            } else {
                if (n11 != 0) {
                    realContainer.swap(n9, n6, n9 + n11 * n5, n6, n3);
                }
                this.pivotIndex[this.range] = (char)n11;
                n11 = n2 - this.range - 1;
                if (n11 > 0) {
                    dArray[this.range] = realContainer.normalize(n10 + n5, n5, 1.0 / realContainer.get(n10), n11) / (double)n11 * d;
                }
                n11 = this.range + 1;
                n13 = n;
                n14 = n10;
                while (n11 < n3) {
                    realContainer.add(n14 += n6, -realContainer.postProduct(n9, n6, n13 += n6, n5, this.range));
                    ++n11;
                }
                if (n8 != this.range) {
                    realContainer.assign(n7 + this.range * n6, n5, n, n5, n2);
                }
                n10 += n5;
                n9 += n5;
                ++this.range;
                this.columnFactorized(n8);
            }
            ++n8;
            n10 += n6;
            n += n6;
        }
    }

    public void transform(DenseMatrix denseMatrix) {
        int n;
        this.ensureFactorized();
        this.ensureTransformable(denseMatrix);
        int n2 = denseMatrix.nRows;
        int n3 = denseMatrix.nColumns;
        int n4 = denseMatrix.rowStep;
        int n5 = denseMatrix.columnStep;
        int n6 = denseMatrix.startIndex;
        RealContainer realContainer = denseMatrix.getContainer();
        int n7 = this.matrix.rowStep;
        int n8 = this.matrix.columnStep;
        RealContainer realContainer2 = this.matrix.getContainer();
        RealPointer realPointer = realContainer2.getPointer();
        int n9 = 0;
        int n10 = n6;
        while (n9 < this.range) {
            n = this.pivotIndex[n9];
            if (n != 0) {
                realContainer.swap(n10, n5, n10 + n * n4, n5, n3);
            }
            ++n9;
            n10 += n4;
        }
        n9 = 1;
        n10 = n6;
        int n11 = this.matrix.startIndex;
        while (n9 < n2) {
            n10 += n4;
            int n12 = Math.min(n9, this.range);
            realPointer.reset(n11 += n7, n8);
            n = 0;
            int n13 = n6;
            int n14 = n10;
            while (n < n3) {
                realContainer.add(n14, -realContainer.postProduct(n13, n4, realPointer, n12));
                ++n;
                n13 += n5;
                n14 += n5;
            }
            ++n9;
        }
    }

    public void transform(RealVector realVector) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        realVector.ensureLength(n);
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep;
        RealContainer realContainer = this.matrix.getContainer();
        int n4 = 0;
        while (n4 < this.range) {
            char c = this.pivotIndex[n4];
            if (c != '\u0000') {
                realVector.swap(n4, n4 + c);
            }
            ++n4;
        }
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector.getPointer();
        n4 = 1;
        int n5 = this.matrix.startIndex;
        while (n4 < n) {
            realPointer2.next().add(-realContainer.postProduct(n5 += n2, n3, realPointer, Math.min(n4, this.range)));
            ++n4;
        }
    }

    public void transformT(RealVector realVector) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        realVector.ensureLength(n);
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep;
        RealContainer realContainer = this.matrix.getContainer();
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector.getPointer(n, -1);
        int n4 = n;
        int n5 = this.matrix.startIndex + n * n2;
        while (--n4 > 0) {
            realPointer2.next().add(realContainer.postProduct(n5 -= n2, n3, realPointer, Math.min(n4, this.range)));
        }
        n4 = this.range;
        while (n4-- > 0) {
            char c = this.pivotIndex[n4];
            if (c == '\u0000') continue;
            realVector.swap(n4, n4 + c);
        }
    }
}

