/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealCommonSolver;
import ru.sscc.matrix.solve.RealSquareSolver;
import ru.sscc.util.Reflection;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class ReflectionSolver
extends RealCommonSolver {
    private RealVector diagonal = null;

    public ReflectionSolver() {
    }

    public ReflectionSolver(int n, int n2) {
        super(new DenseMatrix(n, n2));
    }

    public ReflectionSolver(DenseMatrix denseMatrix) {
        super(denseMatrix);
    }

    public ReflectionSolver(RealContainer realContainer, int n, int n2) {
        super(new DenseMatrix(realContainer, n, n2));
    }

    public void attach(DenseMatrix denseMatrix) {
        super.attach(denseMatrix);
        this.diagonal = null;
    }

    protected void doBackSubstitution(RealVector realVector, RealVector realVector2) {
        RealContainer realContainer = this.matrix.getContainer();
        int n = this.matrix.rowStep;
        int n2 = this.matrix.columnStep;
        int n3 = this.range - 1;
        int n4 = this.matrix.startIndex + (n + n2) * n3;
        RealSquareSolver.forwardSubstitution(realContainer, n4, -n, -n2, this.diagonal.getPointer(n3, -1), realVector.getPointer(n3, -1), realVector2.getPointer(n3, -1), this.range);
    }

    protected void doFactorize() {
        RealContainer realContainer = this.matrix.getContainer();
        int n = this.matrix.nRows;
        int n2 = this.matrix.nColumns;
        int n3 = Math.min(n, n2);
        int n4 = this.matrix.rowStep;
        int n5 = this.matrix.columnStep;
        int n6 = this.matrix.startIndex;
        double d = Math.max(this.matrix.relativeAccuracy() * 8.0, this.getReductionAccuracy());
        d *= d;
        if (this.diagonal == null) {
            this.diagonal = new DoubleVector(n3);
        }
        Reflection reflection = new Reflection();
        int n7 = 0;
        int n8 = n6;
        while (n7 < n2) {
            double d2;
            if (this.range == n || (d2 = reflection.constructAndReflect(realContainer, n8, n4, n5, n - this.range, n2 - this.range, realContainer.preProduct(n8, -n4, n8, -n4, this.range) * d * (double)this.range)) == 0.0) {
                this.prepareNullVector(n7);
            } else {
                this.diagonal.set(this.range, d2);
                if (n7 != this.range) {
                    realContainer.assign(n6 + this.range * n5, n4, n6 + n7 * n5, n4, n);
                }
                n8 += n4;
                ++this.range;
                this.columnFactorized(n7);
            }
            ++n7;
            n8 += n5;
        }
    }

    public void transform(DenseMatrix denseMatrix) {
        this.ensureFactorized();
        this.ensureTransformable(denseMatrix);
        int n = denseMatrix.nRows;
        int n2 = denseMatrix.nColumns;
        int n3 = denseMatrix.rowStep;
        int n4 = denseMatrix.columnStep;
        RealContainer realContainer = denseMatrix.getContainer();
        int n5 = this.matrix.rowStep;
        int n6 = this.matrix.columnStep + n5;
        RealPointer realPointer = this.matrix.getContainer().getPointer();
        Reflection reflection = new Reflection();
        int n7 = 0;
        int n8 = denseMatrix.startIndex;
        int n9 = this.matrix.startIndex;
        while (n7 < this.range) {
            reflection.prepare(realPointer.reset(n9, n5), n - n7);
            reflection.reflect(realContainer, n8, n3, n4, n2);
            ++n7;
            n8 += n3;
            n9 += n6;
        }
    }

    public void transform(RealVector realVector) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        realVector.ensureLength(n);
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep + n2;
        RealPointer realPointer = this.matrix.getContainer().getPointer();
        RealPointer realPointer2 = realVector.getPointer();
        Reflection reflection = new Reflection();
        int n4 = 0;
        int n5 = this.matrix.startIndex;
        while (n4 < this.range) {
            reflection.prepare(realPointer.reset(n5, n2), n - n4);
            reflection.reflect(realPointer2);
            ++n4;
            n5 += n3;
            realPointer2.next();
        }
    }

    public void transformT(RealVector realVector) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        realVector.ensureLength(n);
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep + n2;
        RealPointer realPointer = this.matrix.getContainer().getPointer();
        RealPointer realPointer2 = realVector.getPointer(this.range - 1, 1);
        Reflection reflection = new Reflection();
        int n4 = this.range - 1;
        int n5 = this.matrix.startIndex + (this.range - 1) * n3;
        while (n4 >= 0) {
            reflection.prepare(realPointer.reset(n5, n2), n - n4);
            reflection.reflect(realPointer2);
            --n4;
            n5 -= n3;
            realPointer2.previous();
        }
    }
}

