/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.polynomial;

import ru.sscc.spline.base.SimpleMeshWorkspace;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;

public class PSplineWorkspace
extends SimpleMeshWorkspace {
    protected int derivative = 0;
    protected double[] weight = null;
    protected int maxDegree = 0;
    protected double scale;

    protected PSplineWorkspace(RealPointer realPointer, double d) {
        super(realPointer);
        this.scale = d;
    }

    protected PSplineWorkspace(RealPointer realPointer, double d, int n) {
        this(realPointer, d);
        if (n > 0) {
            this.weight = new double[n];
        }
        this.maxDegree = n;
    }

    public double calculate() {
        if (this.derivative == 0) {
            return RealMath.polynomial(this.data, this.cellPoint, this.dataCount - 1);
        }
        int n = this.dataCount - 1;
        double d = this.data.shift(n).get() * this.weight[n];
        while (n-- > 0) {
            d = d * this.cellPoint + this.data.previous().get() * this.weight[n];
        }
        return d;
    }

    public void setDerivative(int n) {
        if (n == this.derivative) {
            return;
        }
        this.derivative = n;
        if (n == 0 || n > this.maxDegree) {
            return;
        }
        double d = this.scale;
        int n2 = 2;
        while (n2 <= n) {
            d *= (double)n2 * this.scale;
            ++n2;
        }
        this.weight[0] = d;
        n2 = 1;
        while (n2 < this.maxDegree - n) {
            this.weight[n2] = d = d / (double)n2 * (double)(n + n2);
            ++n2;
        }
    }
}

