/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.BoundingBox;
import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.RealVectors;

public final class DoubleVectors
extends RealVectors {
    double[] vectors;

    public DoubleVectors(int n, int n2) {
        this(new double[n * n2], n, n2);
    }

    public DoubleVectors(double[] dArray, int n) {
        this(dArray, n, dArray.length / n);
    }

    public DoubleVectors(double[] dArray, int n, int n2) {
        super(n, n2);
        this.vectors = dArray;
    }

    public double add(int n, int n2, double d) {
        int n3 = this.pos(n) + n2;
        double d2 = this.vectors[n3] + d;
        this.vectors[n3] = d2;
        return d2;
    }

    public void assign(RealPointer realPointer, int n) {
        RealMath.assign(realPointer, this.vectors, this.pos(n), 1, this.dimension);
    }

    public BoundingBox boundingBox() {
        BoundingBox boundingBox = new BoundingBox(this.dimension);
        int n = 0;
        while (n < this.size) {
            boundingBox.enlargeBy(this.vectors, this.pos(n));
            ++n;
        }
        return boundingBox;
    }

    public double get(int n, int n2) {
        return this.vectors[this.pos(n) + n2];
    }

    public RealVector getComponent(int n) {
        return new DoubleVector(this.vectors, this.size, n, this.dimension);
    }

    public RealPointer getPointer(int n) {
        return new DoublePointer(this.vectors, this.pos(n), 1);
    }

    public RealVector getVector(int n) {
        return new DoubleVector(this.vectors, this.dimension, this.pos(n), 1);
    }

    public boolean inBox(int n, BoundingBox boundingBox) {
        return boundingBox.contains(this.vectors, this.pos(n));
    }

    public double mul(int n, int n2, double d) {
        int n3 = this.pos(n) + n2;
        double d2 = this.vectors[n3] * d;
        this.vectors[n3] = d2;
        return d2;
    }

    public int offset(int n) {
        return this.pos(n);
    }

    public double set(int n, int n2, double d) {
        double d2 = d;
        this.vectors[this.pos((int)n) + n2] = d2;
        return d2;
    }

    public double squaredDistance(int n, RealPointer realPointer) {
        return RealMath.squaredDistance(realPointer, this.vectors, this.pos(n), this.dimension);
    }
}

