/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.nyet.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataLogger {
    private static final Logger logger = LoggerFactory.getLogger(DataLogger.class);
    public static final String UNKNOWN = "UNKNOWN";
    private static Map<String, DataLoggerConfig> loggerConfigs = new HashMap<String, DataLoggerConfig>();
    private static Map<String, String[]> fieldCategories = new HashMap<String, String[]>();

    private static int parseXmlIntAttribute(Element element, String attributeName, int defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value != null && !value.isEmpty() && !value.equals("None")) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static String parseXmlStringAttribute(Element element, String attributeName, String defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value != null && !value.isEmpty() && !value.equals("None")) {
            return value;
        }
        return defaultValue;
    }

    private static boolean parseXmlBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value != null && !value.isEmpty()) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private static double parseXmlDoubleAttribute(Element element, String attributeName, double defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value != null && !value.isEmpty() && !value.equals("None")) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static SkipRegex[] parseSkipRegex(Element loggerElement) {
        NodeList skipRegexNodes = loggerElement.getElementsByTagName("skip_regex");
        if (skipRegexNodes.getLength() == 0) {
            return new SkipRegex[0];
        }
        NodeList itemNodes = ((Element)skipRegexNodes.item(0)).getElementsByTagName("item");
        SkipRegex[] skipRegexArray = new SkipRegex[itemNodes.getLength()];
        for (int i = 0; i < itemNodes.getLength(); ++i) {
            Element itemElement = (Element)itemNodes.item(i);
            String regex = itemElement.getAttribute("regex");
            int column = DataLogger.parseXmlIntAttribute(itemElement, "column", -1);
            skipRegexArray[i] = new SkipRegex(regex, column);
        }
        return skipRegexArray;
    }

    private static FieldTransformation parseFieldTransformation(Element loggerElement) {
        NodeList fieldTransformationNodes = loggerElement.getElementsByTagName("field_transformations");
        if (fieldTransformationNodes.getLength() == 0) {
            return new FieldTransformation(null, null, new String[0], false);
        }
        Element fieldTransformationElement = (Element)fieldTransformationNodes.item(0);
        String prepend = DataLogger.parseXmlStringAttribute(fieldTransformationElement, "prepend", null);
        String append = DataLogger.parseXmlStringAttribute(fieldTransformationElement, "append", null);
        boolean ifEmpty = DataLogger.parseXmlBooleanAttribute(fieldTransformationElement, "if_empty", false);
        String[] excludeFields = new String[]{};
        NodeList excludeFieldsNodes = fieldTransformationElement.getElementsByTagName("exclude_fields");
        if (excludeFieldsNodes.getLength() > 0) {
            NodeList itemNodes = ((Element)excludeFieldsNodes.item(0)).getElementsByTagName("item");
            excludeFields = new String[itemNodes.getLength()];
            for (int i = 0; i < itemNodes.getLength(); ++i) {
                excludeFields[i] = itemNodes.item(i).getTextContent();
            }
        }
        return new FieldTransformation(prepend, append, excludeFields, ifEmpty);
    }

    private static String parseUnitRegex(Element loggerElement) {
        String unitRegex = loggerElement.getAttribute("unit_regex");
        if (unitRegex == null || unitRegex.trim().isEmpty()) {
            return null;
        }
        return unitRegex.trim();
    }

    private static void loadLogDefinitions() {
        try {
            NodeList loggersNodes;
            int j;
            InputStream is = DataLogger.class.getResourceAsStream("loggers.xml");
            if (is == null) {
                logger.error("Error: loggers.xml not found - system cannot function without configuration");
                return;
            }
            logger.info("Loading loggers.xml...");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            is.close();
            NodeList fieldCategoriesNodes = document.getElementsByTagName("field_categories");
            if (fieldCategoriesNodes.getLength() > 0) {
                Element fieldCategoriesElement = (Element)fieldCategoriesNodes.item(0);
                NodeList childNodes = fieldCategoriesElement.getChildNodes();
                logger.debug("Found field categories section");
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    if (childNodes.item(i).getNodeType() != 1) continue;
                    Element categoryElement = (Element)childNodes.item(i);
                    String categoryName = categoryElement.getTagName();
                    NodeList fieldNodes = categoryElement.getElementsByTagName("item");
                    String[] fields = new String[fieldNodes.getLength()];
                    for (j = 0; j < fieldNodes.getLength(); ++j) {
                        fields[j] = fieldNodes.item(j).getTextContent();
                    }
                    fieldCategories.put(categoryName, fields);
                    logger.debug("Loaded field category '{}' with {} fields", (Object)categoryName, (Object)fields.length);
                }
            }
            if ((loggersNodes = document.getElementsByTagName("loggers")).getLength() > 0) {
                Element loggersElement = (Element)loggersNodes.item(0);
                NodeList childNodes = loggersElement.getChildNodes();
                logger.debug("Found loggers section");
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Element childElement;
                    String childTagName;
                    if (childNodes.item(i).getNodeType() != 1 || "field_categories".equals(childTagName = (childElement = (Element)childNodes.item(i)).getTagName()) || !"loggers".equals(childTagName)) continue;
                    NodeList nestedChildren = childElement.getChildNodes();
                    for (j = 0; j < nestedChildren.getLength(); ++j) {
                        String[] stringArray;
                        if (nestedChildren.item(j).getNodeType() != 1) continue;
                        Element loggerElement = (Element)nestedChildren.item(j);
                        String loggerName = loggerElement.getTagName();
                        String loggerType = loggerElement.getAttribute("type");
                        logger.debug("Found logger: {} = {}", (Object)loggerName, (Object)loggerType);
                        CommentSignature[] commentSigs = DataLogger.collectCommentSignatures(loggerElement);
                        FieldSignature[] fieldSigs = DataLogger.collectFieldSignatures(loggerElement);
                        String[][] loggerAliases = DataLogger.collectAliases(loggerElement);
                        double loggerTimeTicksPerSec = DataLogger.parseXmlDoubleAttribute(loggerElement, "time_ticks_per_sec", 1.0);
                        int loggerSkipLines = DataLogger.parseXmlIntAttribute(loggerElement, "skip_lines", 0);
                        String loggerHeaderFormat = DataLogger.parseXmlStringAttribute(loggerElement, "header_format", "");
                        if (loggerHeaderFormat.isEmpty()) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = "id";
                        } else {
                            stringArray = loggerHeaderFormat.split(",");
                        }
                        String[] headerFormatTokensArray = stringArray;
                        Strings.trimArray(headerFormatTokensArray);
                        SkipRegex[] skipRegexArray = DataLogger.parseSkipRegex(loggerElement);
                        FieldTransformation fieldTransformation = DataLogger.parseFieldTransformation(loggerElement);
                        String unitRegex = DataLogger.parseUnitRegex(loggerElement);
                        DetectionConfig detectionConfig = new DetectionConfig(loggerType, commentSigs, fieldSigs);
                        ParserConfig parserConfig = new ParserConfig(loggerAliases, loggerTimeTicksPerSec, loggerSkipLines, headerFormatTokensArray, skipRegexArray, fieldTransformation, unitRegex);
                        DataLoggerConfig config = new DataLoggerConfig(loggerName, detectionConfig, parserConfig);
                        loggerConfigs.put(loggerName, config);
                        logger.debug("Loaded logger '{}' with {} aliases", (Object)loggerName, (Object)loggerAliases.length);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error loading loggers.xml: {}", (Object)e.getMessage());
            logger.error("No logger definitions available - system cannot function without configuration");
        }
    }

    private static CommentSignature[] collectCommentSignatures(Element loggerElement) {
        NodeList commentNodes = loggerElement.getElementsByTagName("comment_signatures");
        if (commentNodes.getLength() == 0) {
            return new CommentSignature[0];
        }
        Element commentElement = (Element)commentNodes.item(0);
        NodeList signatureNodes = commentElement.getElementsByTagName("item");
        CommentSignature[] sigs = new CommentSignature[signatureNodes.getLength()];
        for (int i = 0; i < signatureNodes.getLength(); ++i) {
            Element sigElement = (Element)signatureNodes.item(i);
            String regex = sigElement.getAttribute("regex");
            String type = loggerElement.getAttribute("type");
            sigs[i] = new CommentSignature(regex, type);
        }
        return sigs;
    }

    private static FieldSignature[] collectFieldSignatures(Element loggerElement) {
        NodeList fieldNodes = loggerElement.getElementsByTagName("field_signatures");
        if (fieldNodes.getLength() == 0) {
            return new FieldSignature[0];
        }
        Element fieldElement = (Element)fieldNodes.item(0);
        NodeList signatureNodes = fieldElement.getElementsByTagName("item");
        FieldSignature[] sigs = new FieldSignature[signatureNodes.getLength()];
        for (int i = 0; i < signatureNodes.getLength(); ++i) {
            Element sigElement = (Element)signatureNodes.item(i);
            String regex = sigElement.getAttribute("regex");
            String columnIndexStr = sigElement.getAttribute("column_index");
            Integer columnIndex = null;
            if (columnIndexStr != null && !columnIndexStr.isEmpty()) {
                columnIndex = Integer.parseInt(columnIndexStr);
            }
            String type = loggerElement.getAttribute("type");
            sigs[i] = columnIndex != null ? new FieldSignature(regex, type, columnIndex) : new FieldSignature(regex, type);
        }
        return sigs;
    }

    private static String[][] collectAliases(Element loggerElement) {
        NodeList aliasNodes = loggerElement.getElementsByTagName("aliases");
        if (aliasNodes.getLength() == 0) {
            return new String[0][0];
        }
        Element aliasElement = (Element)aliasNodes.item(0);
        NodeList aliasList = aliasElement.getElementsByTagName("item");
        String[][] aliases = new String[aliasList.getLength()][2];
        for (int i = 0; i < aliasList.getLength(); ++i) {
            Element alias = (Element)aliasList.item(i);
            aliases[i][0] = alias.getAttribute("pattern");
            aliases[i][1] = alias.getAttribute("target");
        }
        return aliases;
    }

    public static String detectComment(String comment) {
        for (Map.Entry<String, DataLoggerConfig> entry : loggerConfigs.entrySet()) {
            String loggerName = entry.getKey();
            DataLoggerConfig config = entry.getValue();
            CommentSignature[] sigs = config.detection.commentSignatures;
            if (sigs == null) continue;
            for (CommentSignature sig : sigs) {
                if (!comment.matches(sig.regex)) continue;
                return loggerName;
            }
        }
        return UNKNOWN;
    }

    public static String detectField(String[] fields) {
        for (Map.Entry<String, DataLoggerConfig> entry : loggerConfigs.entrySet()) {
            String loggerName = entry.getKey();
            DataLoggerConfig config = entry.getValue();
            FieldSignature[] sigs = config.detection.fieldSignatures;
            if (sigs == null) continue;
            for (FieldSignature sig : sigs) {
                if (sig.columnIndex != null) {
                    if (sig.columnIndex >= fields.length || !fields[sig.columnIndex].matches(sig.regex)) continue;
                    return loggerName;
                }
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].matches(sig.regex)) continue;
                    return loggerName;
                }
            }
        }
        return UNKNOWN;
    }

    private static String[][] which(String loggerType) {
        DataLoggerConfig config = loggerConfigs.get(loggerType);
        if (config != null) {
            logger.debug("which('{}'): found config with {} aliases", (Object)loggerType, (Object)config.parser.aliases.length);
            return config.parser.aliases;
        }
        DataLoggerConfig defaultConfig = loggerConfigs.get("DEFAULT");
        if (defaultConfig != null) {
            logger.debug("which('{}'): using DEFAULT config with {} aliases", (Object)loggerType, (Object)defaultConfig.parser.aliases.length);
            return defaultConfig.parser.aliases;
        }
        logger.debug("which('{}'): returning empty aliases", (Object)loggerType);
        return new String[0][0];
    }

    public static void processAliases(String[] h, String loggerType) {
        logger.debug("processAliases called with loggerType='{}', will use aliases from which(loggerType)", (Object)loggerType);
        String[][] aliasesToUse = DataLogger.which(loggerType);
        logger.debug("which('{}') returned {} aliases", (Object)loggerType, (Object)aliasesToUse.length);
        DataLogger.processAliases(h, aliasesToUse);
    }

    public static void processAliases(String[] h) {
        DataLogger.processAliases(h, UNKNOWN);
    }

    public static void processAliases(String[] h, String[][] a) {
        for (int i = 0; i < h.length; ++i) {
            for (String[] s : a) {
                if (!h[i].matches(s[0]) || ArrayUtils.contains((Object[])h, (Object)s[1])) continue;
                h[i] = s[1];
            }
            if (i <= 0 || h[i].length() <= 0) continue;
            Object[] prev = Arrays.copyOfRange(h, 0, i);
            Object renamed = h[i];
            boolean rename = false;
            int j = 2;
            while (ArrayUtils.contains((Object[])prev, (Object)renamed)) {
                renamed = h[i] + " " + Integer.toString(j);
                rename = true;
                ++j;
            }
            if (!rename) continue;
            h[i] = renamed;
        }
    }

    public static DataLoggerConfig getConfig(String type) {
        DataLoggerConfig config = loggerConfigs.get(type);
        if (config == null) {
            DetectionConfig defaultDetection = new DetectionConfig(UNKNOWN, new CommentSignature[0], new FieldSignature[0]);
            ParserConfig defaultParser = new ParserConfig(new String[0][0], 1.0, 0, new String[]{"id"}, new SkipRegex[0], new FieldTransformation(null, null, new String[0], false), null);
            return new DataLoggerConfig(UNKNOWN, defaultDetection, defaultParser);
        }
        return config;
    }

    public static String[] fields(FieldCategory category) {
        return category.fields();
    }

    public static String[] pedal() {
        return DataLogger.fields(FieldCategory.PEDAL);
    }

    public static String[] throttle() {
        return DataLogger.fields(FieldCategory.THROTTLE);
    }

    public static String[] gear() {
        return DataLogger.fields(FieldCategory.GEAR);
    }

    public static boolean isUnknown(String type) {
        return type == null || UNKNOWN.equals(type);
    }

    static {
        DataLogger.loadLogDefinitions();
        logger.debug("DataLogger class loaded, logger definitions loaded from XML");
    }

    public static class SkipRegex {
        public final String regex;
        public final int column;

        public SkipRegex(String regex, int column) {
            this.regex = regex;
            this.column = column;
        }
    }

    public static class FieldTransformation {
        public final String prepend;
        public final String append;
        public final String[] excludeFields;
        public final boolean ifEmpty;

        public FieldTransformation(String prepend, String append, String[] excludeFields, boolean ifEmpty) {
            this.prepend = prepend;
            this.append = append;
            this.excludeFields = excludeFields;
            this.ifEmpty = ifEmpty;
        }
    }

    public static class CommentSignature {
        public final String regex;
        public final String type;

        public CommentSignature(String regex, String type) {
            this.regex = regex;
            this.type = type;
        }
    }

    public static class FieldSignature {
        public final String regex;
        public final String type;
        public final Integer columnIndex;

        public FieldSignature(String regex, String type) {
            this.regex = regex;
            this.type = type;
            this.columnIndex = null;
        }

        public FieldSignature(String regex, String type, int columnIndex) {
            this.regex = regex;
            this.type = type;
            this.columnIndex = columnIndex;
        }
    }

    public static class DetectionConfig {
        public final String type;
        public final CommentSignature[] commentSignatures;
        public final FieldSignature[] fieldSignatures;

        public DetectionConfig(String type, CommentSignature[] commentSignatures, FieldSignature[] fieldSignatures) {
            this.type = type;
            this.commentSignatures = commentSignatures;
            this.fieldSignatures = fieldSignatures;
        }
    }

    public static class ParserConfig {
        public final String[][] aliases;
        public final double timeTicksPerSec;
        public final int skipLines;
        public final String[] headerFormatTokens;
        public final SkipRegex[] skipRegex;
        public final FieldTransformation fieldTransformation;
        public final String unitRegex;

        public ParserConfig(String[][] aliases, double timeTicksPerSec, int skipLines, String[] headerFormatTokens, SkipRegex[] skipRegex, FieldTransformation fieldTransformation, String unitRegex) {
            this.aliases = aliases;
            this.timeTicksPerSec = timeTicksPerSec;
            this.skipLines = skipLines;
            this.headerFormatTokens = headerFormatTokens;
            this.skipRegex = skipRegex;
            this.fieldTransformation = fieldTransformation;
            this.unitRegex = unitRegex;
        }
    }

    public static class DataLoggerConfig {
        public final String type;
        public final DetectionConfig detection;
        public final ParserConfig parser;

        public DataLoggerConfig(String type, DetectionConfig detection, ParserConfig parser) {
            this.type = type;
            this.detection = detection;
            this.parser = parser;
        }

        public boolean hasToken(String token) {
            for (String formatToken : this.parser.headerFormatTokens) {
                if (!token.equals(formatToken)) continue;
                return true;
            }
            return false;
        }

        public String[] getHeaderFormatTokens() {
            return this.parser.headerFormatTokens;
        }

        public int getSkipLines() {
            return this.parser.skipLines;
        }

        public double getTimeTicksPerSec() {
            return this.parser.timeTicksPerSec;
        }

        public String[][] getAliases() {
            return this.parser.aliases;
        }

        public SkipRegex[] getSkipRegex() {
            return this.parser.skipRegex;
        }

        public String getType() {
            return this.detection.type;
        }

        public CommentSignature[] getCommentSignatures() {
            return this.detection.commentSignatures;
        }

        public FieldSignature[] getFieldSignatures() {
            return this.detection.fieldSignatures;
        }

        public void processAliases(String[] h) {
            DataLogger.processAliases(h, this.type);
        }

        public void applyFieldTransformations(String[] id, String[] id2) {
            FieldTransformation transformation = this.parser.fieldTransformation;
            if (transformation == null) {
                return;
            }
            for (int i = 0; i < id.length; ++i) {
                boolean isEmpty;
                if (this.isExcluded(id[i], transformation.excludeFields)) continue;
                boolean bl = isEmpty = id[i] == null || id[i].trim().isEmpty();
                if (transformation.ifEmpty && !isEmpty) continue;
                String fieldToTransform = id[i];
                if (transformation.ifEmpty && isEmpty && id2 != null && i < id2.length && id2[i] != null) {
                    fieldToTransform = id2[i];
                }
                if (transformation.prepend != null && !transformation.prepend.isEmpty()) {
                    id[i] = transformation.prepend + fieldToTransform;
                }
                if (transformation.append == null || transformation.append.isEmpty()) continue;
                id[i] = fieldToTransform + transformation.append;
            }
        }

        public String applyFieldTransformation(String fieldName) {
            FieldTransformation transformation = this.parser.fieldTransformation;
            if (transformation == null || fieldName == null || fieldName.isEmpty()) {
                return fieldName;
            }
            if (this.isExcluded(fieldName, transformation.excludeFields)) {
                return fieldName;
            }
            Object result = fieldName;
            if (transformation.prepend != null && !transformation.prepend.isEmpty()) {
                result = transformation.prepend + (String)result;
            }
            if (transformation.append != null && !transformation.append.isEmpty()) {
                result = (String)result + transformation.append;
            }
            return result;
        }

        private boolean isExcluded(String fieldName, String[] excludeFields) {
            if (excludeFields == null || excludeFields.length == 0) {
                return false;
            }
            for (String excludeField : excludeFields) {
                if (!fieldName.equals(excludeField)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum FieldCategory {
        PEDAL("pedal"),
        THROTTLE("throttle"),
        GEAR("gear");

        private final String categoryName;

        private FieldCategory(String categoryName) {
            this.categoryName = categoryName;
        }

        public String[] fields() {
            return fieldCategories.getOrDefault(this.categoryName, new String[0]);
        }
    }
}

