/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import com.opencsv.CSVReader;
import flanagan.interpolation.CubicSpline;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nyet.ecuxplot.DataLogger;
import org.nyet.ecuxplot.Env;
import org.nyet.ecuxplot.Filter;
import org.nyet.ecuxplot.Units;
import org.nyet.logfile.Dataset;
import org.nyet.util.DoubleArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECUxDataset
extends Dataset {
    private static final Logger logger = LoggerFactory.getLogger(ECUxDataset.class);
    private final Dataset.Column rpm;
    private Dataset.Column pedal;
    private Dataset.Column throttle;
    private Dataset.Column gear;
    private final Dataset.Column zboost;
    private final Env env;
    private final Filter filter;
    private double time_ticks_per_sec;
    public double samples_per_sec = 0.0;
    private CubicSpline[] splines;
    private String log_detected;

    @Override
    protected void detectLoggerType() throws Exception {
        if (!DataLogger.isUnknown(this.log_detected)) {
            logger.info("{}: already detected as {}", (Object)this.getFileId(), (Object)this.log_detected);
            return;
        }
        logger.debug("Starting detection for {}", (Object)this.getFileId());
        for (int lineNum = 0; lineNum < this.getComments().size(); ++lineNum) {
            String line = this.getComments().get(lineNum);
            logger.debug("Comment line {}: {}", (Object)lineNum, (Object)line);
            String t = DataLogger.detectComment(line);
            logger.debug("detectComment('{}') returned: '{}'", (Object)line, (Object)t);
            if (DataLogger.isUnknown(t)) continue;
            logger.info("Detected {} based on comment line {}: \"{}\"", new Object[]{t, lineNum, line});
            this.log_detected = t;
            return;
        }
        logger.debug("No logger type detected in comment lines, trying field detection");
        String t = this.detectFieldInstance();
        logger.debug("detectField() returned: '{}'", (Object)t);
        if (!DataLogger.isUnknown(t)) {
            logger.info("Detected {} based on field line");
            this.log_detected = t;
            return;
        }
        logger.debug("No logger type detected, using UNKNOWN");
        this.log_detected = "UNKNOWN";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectFieldInstance() {
        try {
            if (this.getFilePath() == null) {
                logger.debug("filePath not set yet, skipping field detection");
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(this.getFilePath()));){
                String t;
                block18: {
                    String line;
                    boolean foundFirstCsvLine = false;
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().length() == 0 || Dataset.IsLineComment(line)) continue;
                        String[] csvLine = Dataset.parseCSVLineWithFallback(line);
                        if (csvLine == null || csvLine.length == 0) {
                            String string = null;
                            return string;
                        }
                        boolean hasContent = false;
                        for (String field : csvLine) {
                            if (field == null || field.trim().length() <= 0) continue;
                            hasContent = true;
                            break;
                        }
                        if (!hasContent) continue;
                        boolean numericOrEmpty = this.allFieldsAreNumeric(csvLine, true);
                        if (!foundFirstCsvLine) {
                            if (numericOrEmpty) continue;
                            foundFirstCsvLine = true;
                        } else if (numericOrEmpty) {
                            String string = null;
                            return string;
                        }
                        if ((t = DataLogger.detectField(csvLine)) == "UNKNOWN") {
                            continue;
                        }
                        break block18;
                    }
                    return null;
                }
                String string = t;
                return string;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to read CSV line for detection: {}", (Object)e.getMessage());
        }
        return null;
    }

    private boolean allFieldsAreNumeric(String[] fields, boolean ignoreEmpty) {
        for (String field : fields) {
            if (ignoreEmpty && (field == null || field.trim().length() == 0)) continue;
            try {
                Float.parseFloat(field);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private String[] copyAndTrim(String[] source) {
        String[] result = Arrays.copyOf(source, source.length);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] == null) continue;
            result[i] = result[i].trim();
        }
        return result;
    }

    public String getLogDetected() {
        return this.log_detected;
    }

    public ECUxDataset(String filename, Env env, Filter filter, int verbose) throws Exception {
        super(filename, verbose);
        Dataset.Column baroPressure;
        this.env = env;
        this.filter = filter;
        this.pedal = this.get((Comparable<?>[])DataLogger.pedal());
        if (this.pedal != null && this.pedal.data.isZero()) {
            this.pedal = null;
        }
        this.throttle = this.get((Comparable<?>[])DataLogger.throttle());
        if (this.throttle != null && this.throttle.data.isZero()) {
            this.throttle = null;
        }
        this.gear = this.get((Comparable<?>[])DataLogger.gear());
        if (this.gear != null && this.gear.data.isZero()) {
            this.gear = null;
        }
        this.zboost = this.get((Comparable<?>)((Object)"Zeitronix Boost"));
        Dataset.Column time = this.get((Comparable<?>)((Object)"TIME"));
        if (time != null) {
            for (int i = 1; i < time.data.size(); ++i) {
                double rate;
                double delta = time.data.get(i) - time.data.get(i - 1);
                if (!(delta > 0.0) || !((rate = 1.0 / delta) > this.samples_per_sec)) continue;
                this.samples_per_sec = rate;
            }
        }
        if ((baroPressure = this.get((Comparable<?>)((Object)"BaroPressure"))) != null && baroPressure.data.size() > 0 && baroPressure.data.get(0) < 600.0) {
            for (Dataset.Column column : this.getColumns()) {
                if (column.getUnits() == null || !column.getUnits().toLowerCase().equals("mbar")) continue;
                for (int i = 1; i < column.data.size(); ++i) {
                    column.data.set(i, column.data.get(i) * 2.0);
                }
            }
        }
        this.rpm = this.get((Comparable<?>)((Object)"RPM"));
        this.buildRanges();
    }

    private int MAW() {
        return (int)Math.floor(this.samples_per_sec / 10.0 * (double)this.filter.HPTQMAW());
    }

    private int AccelMAW() {
        return (int)Math.floor(this.samples_per_sec / 10.0 * (double)this.filter.accelMAW());
    }

    private String[] ParseUnits(String[] id, int verbose) {
        int i;
        String[] u = new String[id.length];
        for (i = 0; i < id.length; ++i) {
            Pattern unitsRegEx = Pattern.compile("([\\S\\s]+)\\(([\\S\\s].*)\\)");
            Matcher matcher = unitsRegEx.matcher(id[i]);
            if (!matcher.find()) continue;
            id[i] = matcher.group(1).trim();
            u[i] = matcher.group(2).trim();
        }
        for (i = 0; i < id.length; ++i) {
            logger.trace("pu: '{}' [{}]", (Object)id[i], (Object)u[i]);
        }
        return u;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void ParseHeaders(CSVReader reader, int verbose) throws Exception {
        void var18_31;
        String[] id = null;
        String[] u = new String[]{};
        String[] id2 = null;
        String logType = this.log_detected;
        logger.debug("ParseHeaders starting for {}, currently {} (verbose={})", (Object)logType, (Object)verbose);
        DataLogger.DataLoggerConfig config = DataLogger.getConfig(logType);
        if (config == null) {
            logger.error("No configuration found for logger type: {}", (Object)logType);
            return;
        }
        this.time_ticks_per_sec = config.getTimeTicksPerSec();
        int skipLines = config.getSkipLines();
        DataLogger.SkipRegex[] skipRegex = config.getSkipRegex();
        boolean do_skip = skipLines > 0 || skipRegex.length > 0;
        boolean found = false;
        int skipped = 0;
        String[] matchedLine = null;
        while (do_skip && !found && skipped < skipLines) {
            String[] line = reader.readNext();
            if (line == null) {
                logger.error("Reached end of file while skipping lines for {}", (Object)logType);
                break;
            }
            if (line.length == 0 || line.length == 1 && (line[0] == null || line[0].trim().isEmpty())) {
                logger.debug("{} {}: Skipped empty line", (Object)logType, (Object)skipped);
                continue;
            }
            if (skipRegex.length > 0) {
                for (DataLogger.SkipRegex skipRegex2 : skipRegex) {
                    String cellValue;
                    int match = 0;
                    if (skipRegex2.column == -1) {
                        for (int i2 = 0; i2 < line.length; ++i2) {
                            String cellValue2 = line[i2];
                            if (cellValue2 == null || !cellValue2.matches(skipRegex2.regex)) continue;
                            logger.debug("{}: Found skip_regex match '{}' in column {}: '{}'", new Object[]{logType, skipRegex2.regex, i2, cellValue2});
                            match = 1;
                            break;
                        }
                    } else if (line.length > skipRegex2.column && (cellValue = line[skipRegex2.column]) != null && cellValue.matches(skipRegex2.regex)) {
                        logger.debug("{}: Found skip_regex match '{}' in column {}: '{}'", new Object[]{logType, skipRegex2.regex, skipRegex2.column, cellValue});
                        match = 1;
                    }
                    if (match == 0) continue;
                    found = true;
                    matchedLine = line;
                    break;
                }
            }
            logger.debug("{} {}/{}: Skipped {}", new Object[]{logType, ++skipped, skipLines, line});
        }
        String[] formatTokens = config.getHeaderFormatTokens();
        logger.debug("Processing header format for {}: {}", (Object)logType, (Object)formatTokens);
        String[][] headerLines = new String[formatTokens.length][];
        int lineNum = 0;
        if (matchedLine != null) {
            headerLines[0] = matchedLine;
            lineNum = 1;
            logger.debug("Using matched line as headerLines[0]: {} fields", (Object)matchedLine.length);
        }
        while (lineNum < formatTokens.length && (headerLines[lineNum] = reader.readNext()) != null) {
            logger.debug("Read headerLines {}/{}: {} fields", new Object[]{lineNum + 1, formatTokens.length, headerLines[lineNum].length});
            ++lineNum;
        }
        if (lineNum < formatTokens.length) {
            logger.error("Expected {} lines but only found {}", (Object)formatTokens.length, (Object)lineNum);
            logger.error("Skipping tokens: {}", (Object)Arrays.toString(Arrays.copyOfRange(formatTokens, lineNum, formatTokens.length)));
        }
        block20: for (int i3 = 0; i3 < lineNum; ++i3) {
            switch (formatTokens[i3]) {
                case "id": {
                    id = this.copyAndTrim(headerLines[i3]);
                    if (!config.hasToken("id2")) {
                        id2 = this.copyAndTrim(headerLines[i3]);
                    }
                    logger.debug("Using {} for id: {} fields", (Object)id, (Object)headerLines[i3].length);
                    continue block20;
                }
                case "u": {
                    if (u != null && !this.allFieldsAreNumeric(headerLines[i3], true)) {
                        u = this.copyAndTrim(headerLines[i3]);
                        logger.debug("Second 'u' line contains non-numeric strings, overwriting first 'u': {} fields", (Object)headerLines[i3].length);
                        continue block20;
                    }
                    if (u == null) {
                        u = this.copyAndTrim(headerLines[i3]);
                        logger.debug("Using {} for units: {} fields", (Object)u, (Object)headerLines[i3].length);
                        continue block20;
                    }
                    logger.debug("Second 'u' line doesn't contain non-numeric strings, keeping first 'u'");
                    continue block20;
                }
                case "id2": {
                    id2 = this.copyAndTrim(headerLines[i3]);
                    logger.debug("Using {} for aliases: {} fields", (Object)id2, (Object)headerLines[i3].length);
                    continue block20;
                }
                default: {
                    logger.error("Unknown token '{}' at position {}", (Object)formatTokens[i3], (Object)i3);
                }
            }
        }
        String i3 = logType;
        int n = -1;
        switch (switch (i3.hashCode()) {
            case 2628604 -> {
                if (!i3.equals("VCDS")) yield false;
            }
        }) {
            case 0: {
                for (int i4 = 0; i4 < id.length; ++i4) {
                    String g;
                    String string = g = id2 != null && i4 < id2.length ? id2[i4] : null;
                    if (id2 != null && i4 < id2.length) {
                        id2[i4] = id[i4];
                    }
                    if (u != null && i4 < u.length) {
                        if (id[i4] != null && id[i4].matches("^(TIME|Zeit|Time|STAMP|MARKE)$")) {
                            id[i4] = "TIME";
                            u[i4] = "s";
                        } else if ((id[i4] == null || id[i4].trim().isEmpty()) && u[i4] != null && u[i4].matches("^(STAMP|MARKE)$")) {
                            id[i4] = "TIME";
                            u[i4] = "s";
                        }
                    }
                    if (g != null && g.matches("^Group 24.*") && id[i4].equals("Accelerator position")) {
                        id[i4] = "AcceleratorPedalPosition (G024)";
                    }
                    logger.debug("VCDS field {}: '{}' (unit: '{}')", new Object[]{i4, id[i4], u != null && i4 < u.length ? u[i4] : "N/A"});
                }
                break;
            }
        }
        if (config.parser.unitRegex != null) {
            void var18_27;
            logger.debug("Applying unit_regex: '{}'", (Object)config.parser.unitRegex);
            Pattern unitRegexPattern = Pattern.compile(config.parser.unitRegex);
            if (u == null || u.length == 0) {
                u = new String[id.length];
            }
            if (id2 == null) {
                id2 = new String[id.length];
            }
            boolean bl = false;
            while (var18_27 < id.length) {
                if (id[var18_27] != null) {
                    Matcher matcher = unitRegexPattern.matcher(id[var18_27]);
                    if (matcher.find()) {
                        String originalField = id[var18_27];
                        id[var18_27] = matcher.group(1).trim();
                        u[var18_27] = matcher.group(2).trim();
                        if (matcher.groupCount() >= 3 && matcher.group(3) != null) {
                            id2[var18_27] = matcher.group(3).trim();
                        }
                        logger.debug("Unit regex matched field {}: '{}' -> id='{}', unit='{}', id2='{}'", new Object[]{(int)var18_27, originalField, id[var18_27], u[var18_27], id2[var18_27]});
                    } else {
                        logger.debug("Unit regex did not match field {}: '{}'", (Object)((int)var18_27), (Object)id[var18_27]);
                    }
                }
                ++var18_27;
            }
        }
        config.processAliases(id);
        if (!DataLogger.isUnknown(logType)) {
            boolean bl;
            String[] loggerHeaderFormatTokens = config.getHeaderFormatTokens();
            boolean bl2 = false;
            for (String token : loggerHeaderFormatTokens) {
                if (!"u".equals(token)) continue;
                bl = true;
                break;
            }
            if (loggerHeaderFormatTokens.length == 0 || !bl) {
                u = this.ParseUnits(id, verbose);
            }
        }
        u = Units.processUnits(id, u);
        config.applyFieldTransformations(id, id2);
        for (int i5 = 0; i5 < id.length; ++i5) {
            if (id2 != null && i5 < id2.length) {
                logger.debug("Final field {}: '{}' (original: '{}') [{}]", new Object[]{i5, id[i5], id2[i5], u[i5]});
                continue;
            }
            logger.debug("Final field {}: '{}' [{}]", new Object[]{i5, id[i5], u[i5]});
        }
        Dataset.DatasetId[] ids = new Dataset.DatasetId[id.length];
        boolean bl = false;
        while (var18_31 < id.length) {
            ids[var18_31] = new Dataset.DatasetId(id[var18_31]);
            if (id2 != null && var18_31 < id2.length) {
                ids[var18_31].id2 = id2[var18_31];
            }
            if (u != null && var18_31 < u.length) {
                ids[var18_31].unit = u[var18_31];
            }
            ids[var18_31].type = this.log_detected;
            ++var18_31;
        }
        this.setIds(ids);
    }

    private DoubleArray drag(DoubleArray v) {
        double rho = 1.293;
        DoubleArray windDrag = v.pow(3.0).mult(0.6465 * this.env.c.Cd() * this.env.c.FA());
        DoubleArray rollingDrag = v.mult(this.env.c.rolling_drag() * this.env.c.mass() * 9.80665);
        return windDrag.add(rollingDrag);
    }

    private DoubleArray toPSI(DoubleArray abs) {
        Dataset.Column ambient = this.get((Comparable<?>)((Object)"BaroPressure"));
        if (ambient == null) {
            return abs.add(-1013.25).div(68.94744825494008);
        }
        return abs.sub(ambient.data).div(68.94744825494008);
    }

    private static DoubleArray toCelcius(DoubleArray f) {
        return f.add(-32.0).mult(0.5555555555555556);
    }

    private static DoubleArray toFahrenheit(DoubleArray c) {
        return c.mult(1.8).add(32.0);
    }

    public Dataset.Column get(Comparable<?>[] id) {
        for (Comparable<?> k : id) {
            Dataset.Column ret = null;
            try {
                ret = this._get(k);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Dataset.Column get(Comparable<?> id) {
        try {
            return this._get(id);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private Dataset.Column _get(Comparable<?> id) {
        Dataset.Column c;
        block162: {
            c = null;
            if (id.equals("Sample")) {
                double[] idx = new double[this.length()];
                for (int i = 0; i < this.length(); ++i) {
                    idx[i] = i;
                }
                DoubleArray a = new DoubleArray(idx);
                c = new Dataset.Column((Dataset)this, (Comparable<?>)((Object)"Sample"), "#", a);
            } else if (id.equals("TIME")) {
                DoubleArray a = super.get("TIME").data;
                c = new Dataset.Column((Dataset)this, (Comparable<?>)((Object)"TIME"), "s", a.div(this.time_ticks_per_sec));
            } else if (id.equals("RPM")) {
                if (this.samples_per_sec > 10.0) {
                    DoubleArray a = super.get("RPM").data.smooth();
                    c = new Dataset.Column((Dataset)this, id, "RPM", a);
                }
            } else if (id.equals("RPM - raw")) {
                c = new Dataset.Column((Dataset)this, id, "RPM", super.get("RPM").data);
            } else if (id.equals("Sim Load")) {
                DoubleArray a = super.get("MassAirFlow").data.mult(3.6);
                DoubleArray b = super.get("RPM").data.smooth();
                c = new Dataset.Column((Dataset)this, id, "%", a.div(b).div(0.001072));
            } else if (id.equals("Sim Load Corrected")) {
                DoubleArray a = this.get("Sim MAF").data.mult(3.6);
                DoubleArray b = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "%", a.div(b).div(0.001072));
            } else if (id.equals("MassAirFlow (kg/hr)")) {
                DoubleArray maf = super.get("MassAirFlow").data;
                c = new Dataset.Column((Dataset)this, id, "kg/hr", maf.mult(3.6));
            } else if (id.equals("Sim MAF")) {
                DoubleArray a = super.get("MassAirFlow").data.mult(this.env.f.MAF_correction()).add(this.env.f.MAF_offset());
                c = new Dataset.Column((Dataset)this, id, "g/sec", a);
            } else if (id.equals("MassAirFlow df/dt")) {
                DoubleArray maf = super.get("MassAirFlow").data;
                DoubleArray time = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "g/sec^s", maf.derivative(time).max(0.0));
            } else if (id.equals("Turbo Flow")) {
                DoubleArray a = this.get("Sim MAF").data;
                c = new Dataset.Column((Dataset)this, id, "m^3/sec", a.div(1225 * this.env.f.turbos()));
            } else if (id.equals("Turbo Flow (lb/min)")) {
                DoubleArray a = this.get("Sim MAF").data;
                c = new Dataset.Column((Dataset)this, id, "lb/min", a.div(7.55 * (double)this.env.f.turbos()));
            } else if (id.equals("Sim Fuel Mass")) {
                double gps_per_ccmin = 0.0114;
                double gps = this.env.f.injector() * 0.0114;
                double cylinders = this.env.f.cylinders();
                Dataset.Column bank1 = this.get((Comparable<?>)((Object)"EffInjectorDutyCycle"));
                Dataset.Column bank2 = this.get((Comparable<?>)((Object)"EffInjectorDutyCycleBank2"));
                DoubleArray duty = bank1.data;
                if (bank2 != null) {
                    duty = duty.add(bank2.data).div(2.0);
                }
                DoubleArray a = duty.mult(cylinders * gps / 100.0);
                c = new Dataset.Column((Dataset)this, id, "g/sec", a);
            } else if (id.equals("TargetAFRDriverRequest (AFR)")) {
                DoubleArray abs = super.get("TargetAFRDriverRequest").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioDesired (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioDesired").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioCurrent (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioCurrent").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioCurrentBank1 (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioCurrentBank1").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("AirFuelRatioCurrentBank2 (AFR)")) {
                DoubleArray abs = super.get("AirFuelRatioCurrentBank2").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("Lambda Bank 1 (AFR)")) {
                DoubleArray abs = super.get("Lambda Bank 1").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("Lambda Bank 2 (AFR)")) {
                DoubleArray abs = super.get("Lambda Bank 2").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("Sim AFR")) {
                DoubleArray a = this.get("Sim MAF").data;
                DoubleArray b = this.get("Sim Fuel Mass").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", a.div(b));
            } else if (id.equals("Sim lambda")) {
                DoubleArray a = this.get("Sim AFR").data.div(14.7);
                c = new Dataset.Column((Dataset)this, id, "lambda", a);
            } else if (id.equals("Sim lambda error")) {
                DoubleArray a = super.get("AirFuelRatioDesired").data;
                DoubleArray b = this.get("Sim lambda").data;
                c = new Dataset.Column((Dataset)this, id, "%", a.div(b).mult(-1.0).add(1.0).mult(100.0).max(-25.0).min(25.0));
            } else if (id.equals("FuelInjectorDutyCycle")) {
                DoubleArray a = super.get("FuelInjectorOnTime").data.div(60000.0);
                DoubleArray b = this.get("RPM").data.div(2.0);
                c = new Dataset.Column((Dataset)this, id, "%", a.mult(b).mult(100.0));
            } else if (id.equals("EffInjectorDutyCycle")) {
                DoubleArray a = super.get("EffInjectionTime").data.div(60000.0);
                DoubleArray b = this.get("RPM").data.div(2.0);
                c = new Dataset.Column((Dataset)this, id, "%", a.mult(b).mult(100.0));
            } else if (id.equals("EffInjectorDutyCycleBank2")) {
                DoubleArray a = super.get("EffInjectionTimeBank2").data.div(60000.0);
                DoubleArray b = this.get("RPM").data.div(2.0);
                c = new Dataset.Column((Dataset)this, id, "%", a.mult(b).mult(100.0));
            } else if (id.equals("Engine torque (ft-lb)")) {
                DoubleArray tq = this.get("Engine torque").data;
                DoubleArray value = tq.mult(1.356);
                c = new Dataset.Column((Dataset)this, id, "ft-lb", value);
            } else if (id.equals("Engine HP")) {
                DoubleArray tq = this.get("Engine torque (ft-lb)").data;
                DoubleArray rpm = this.get("RPM").data;
                DoubleArray value = tq.div(5252.0).mult(rpm);
                c = new Dataset.Column((Dataset)this, id, "HP", value);
            } else if (id.equals("VehicleSpeed (MPH)")) {
                Dataset.Column rawVehicleSpeed = this.get((Comparable<?>)((Object)"VehicleSpeed"));
                if (rawVehicleSpeed != null) {
                    DoubleArray a = rawVehicleSpeed.data.mult(1.609344);
                    c = new Dataset.Column((Dataset)this, id, "MPH", a);
                } else {
                    DoubleArray rpm = this.get("RPM").data;
                    DoubleArray calculatedMph = rpm.div(this.env.c.rpm_per_mph());
                    c = new Dataset.Column((Dataset)this, id, "MPH", calculatedMph);
                }
            } else if (id.equals("Calc Velocity")) {
                DoubleArray rpm = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "m/s", rpm.div(this.env.c.rpm_per_mph()).div(5.793638400000001));
            } else if (id.equals("Acceleration (RPM/s)")) {
                DoubleArray y = this.get("RPM").data;
                DoubleArray x = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "RPM/s", y.derivative(x, this.AccelMAW()).max(0.0));
            } else if (id.equals("Acceleration - raw (RPM/s)")) {
                DoubleArray y = this.get("RPM - raw").data;
                DoubleArray x = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "RPM/s", y.derivative(x));
            } else if (id.equals("Acceleration (m/s^2)")) {
                DoubleArray y = this.get("Calc Velocity").data;
                DoubleArray x = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "m/s^2", y.derivative(x, this.MAW()).max(0.0));
            } else if (id.equals("Acceleration (g)")) {
                DoubleArray a = this.get("Acceleration (m/s^2)").data;
                c = new Dataset.Column((Dataset)this, id, "g", a.div(9.80665));
            } else if (id.equals("WHP")) {
                DoubleArray a = this.get("Acceleration (m/s^2)").data;
                DoubleArray v = this.get("Calc Velocity").data;
                DoubleArray whp = a.mult(v).mult(this.env.c.mass()).add(this.drag(v));
                DoubleArray value = whp.mult(0.0013410220888438076);
                Object l = "HP";
                if (this.env.sae.enabled()) {
                    value = value.mult(this.env.sae.correction());
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value.movingAverage(this.MAW()));
            } else if (id.equals("HP")) {
                DoubleArray whp = this.get("WHP").data;
                DoubleArray value = whp.div(1.0 - this.env.c.driveline_loss()).add(this.env.c.static_loss());
                Object l = "HP";
                if (this.env.sae.enabled()) {
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value);
            } else if (id.equals("WTQ")) {
                DoubleArray whp = this.get("WHP").data;
                DoubleArray rpm = this.get("RPM").data;
                DoubleArray value = whp.mult(5252.0).div(rpm);
                Object l = "ft-lb";
                if (this.env.sae.enabled()) {
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value);
            } else if (id.equals("TQ")) {
                DoubleArray hp = this.get("HP").data;
                DoubleArray rpm = this.get("RPM").data;
                DoubleArray value = hp.mult(5252.0).div(rpm);
                Object l = "ft-lb";
                if (this.env.sae.enabled()) {
                    l = (String)l + " (SAE)";
                }
                c = new Dataset.Column((Dataset)this, id, (String)l, value);
            } else if (id.equals("Drag")) {
                DoubleArray v = this.get("Calc Velocity").data;
                DoubleArray drag = this.drag(v);
                c = new Dataset.Column((Dataset)this, id, "HP", drag.mult(0.0013410220888438076));
            } else if (id.equals("IntakeAirTemperature")) {
                c = super.get(id);
                if (c.getUnits().matches(".*C$")) {
                    c = new Dataset.Column((Dataset)this, id, "\u00b0F", ECUxDataset.toFahrenheit(c.data));
                }
            } else if (id.equals("IntakeAirTemperature (C)")) {
                c = super.get((Comparable<?>)((Object)"IntakeAirTemperature"));
                if (c.getUnits().matches(".*F$")) {
                    c = new Dataset.Column((Dataset)this, id, "\u00b0C", ECUxDataset.toCelcius(c.data));
                }
            } else if (id.equals("BoostPressureDesired (PSI)")) {
                c = super.get((Comparable<?>)((Object)"BoostPressureDesired"));
                if (!c.getUnits().matches("PSI")) {
                    c = new Dataset.Column((Dataset)this, id, "PSI", this.toPSI(c.data));
                }
            } else if (id.equals("BoostPressureDesired")) {
                Dataset.Column ecu;
                Dataset.Column delta = super.get((Comparable<?>)((Object)"BoostPressureDesiredDelta"));
                if (delta != null && (ecu = super.get((Comparable<?>)((Object)"ECUBoostPressureDesired"))) != null) {
                    c = new Dataset.Column((Dataset)this, id, "PSI", ecu.data.add(delta.data));
                }
            } else if (id.equals("BoostPressureActual (PSI)")) {
                c = super.get((Comparable<?>)((Object)"BoostPressureActual"));
                if (!c.getUnits().matches("PSI")) {
                    c = new Dataset.Column((Dataset)this, id, "PSI", this.toPSI(c.data));
                }
            } else if (id.equals("Zeitronix Boost (PSI)")) {
                DoubleArray boost = super.get("Zeitronix Boost").data;
                c = new Dataset.Column((Dataset)this, id, "PSI", boost.movingAverage(this.filter.ZeitMAW()));
            } else if (id.equals("Zeitronix Boost")) {
                DoubleArray boost = this.get("Zeitronix Boost (PSI)").data;
                c = new Dataset.Column((Dataset)this, id, "mBar", boost.mult(68.94744825494008).add(1013.25));
            } else if (id.equals("Zeitronix AFR (lambda)")) {
                DoubleArray abs = super.get("Zeitronix AFR").data;
                c = new Dataset.Column((Dataset)this, id, "lambda", abs.div(14.7));
            } else if (id.equals("Zeitronix Lambda (AFR)")) {
                DoubleArray abs = super.get("Zeitronix Lambda").data;
                c = new Dataset.Column((Dataset)this, id, "AFR", abs.mult(14.7));
            } else if (id.equals("BoostDesired PR")) {
                Dataset.Column act = super.get((Comparable<?>)((Object)"BoostPressureDesired"));
                try {
                    DoubleArray ambient = super.get("BaroPressure").data;
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(ambient));
                }
                catch (Exception e) {
                    if (act.getUnits().matches("PSI")) {
                        c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(14.7));
                        break block162;
                    }
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(1013.25));
                }
            } else if (id.equals("BoostActual PR")) {
                Dataset.Column act = super.get((Comparable<?>)((Object)"BoostPressureActual"));
                try {
                    DoubleArray ambient = super.get("BaroPressure").data;
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(ambient));
                }
                catch (Exception e) {
                    if (act.getUnits().matches("PSI")) {
                        c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(14.7));
                        break block162;
                    }
                    c = new Dataset.Column((Dataset)this, id, "PR", act.data.div(1013.25));
                }
            } else if (id.equals("Sim evtmod")) {
                DoubleArray tans = this.get("IntakeAirTemperature (C)").data;
                DoubleArray tmot = tans.ident(95.0);
                try {
                    tmot = this.get("CoolantTemperature").data;
                }
                catch (Exception value) {
                    // empty catch block
                }
                DoubleArray evtmod = tans.add(tmot.sub(tans).mult(0.02));
                c = new Dataset.Column((Dataset)this, id, "\u00b0C", evtmod);
            } else if (id.equals("Sim ftbr")) {
                DoubleArray tans = this.get("IntakeAirTemperature (C)").data;
                DoubleArray evtmod = this.get("Sim evtmod").data;
                DoubleArray fwft = tans.add(673.425).div(731.334);
                c = new Dataset.Column((Dataset)this, id, "", evtmod.ident(273.0).div(evtmod.add(273.0)).mult(fwft));
            } else if (id.equals("Sim BoostIATCorrection")) {
                DoubleArray ftbr = this.get("Sim ftbr").data;
                c = new Dataset.Column((Dataset)this, id, "", ftbr.inverse());
            } else if (id.equals("Sim BoostPressureDesired")) {
                DoubleArray ps;
                DoubleArray load;
                boolean SY_BDE = false;
                boolean SY_AGR = true;
                try {
                    load = super.get("EngineLoadRequested").data;
                }
                catch (Exception e) {
                    load = super.get("EngineLoadCorrected").data;
                }
                try {
                    ps = super.get("ME7L ps_w").data;
                }
                catch (Exception e) {
                    ps = super.get("BoostPressureActual").data;
                }
                DoubleArray ambient = ps.ident(1013.25);
                try {
                    ambient = super.get("BaroPressure").data;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DoubleArray fupsrl = load.ident(0.1037);
                try {
                    DoubleArray ftbr = this.get("Sim ftbr").data;
                    fupsrl = fupsrl.mult(ftbr);
                }
                catch (Exception ftbr) {
                    // empty catch block
                }
                DoubleArray pirg = ambient.mult(0.0690846286701209);
                load = load.max(0.0);
                DoubleArray rfges = ps.mult(1.106).sub(pirg).max(0.0).mult(fupsrl);
                load = load.add(rfges.mult(250.0).div(ps));
                DoubleArray boost = load.div(fupsrl);
                boost = boost.div(1.016);
                boost = boost.div(1.016);
                c = new Dataset.Column((Dataset)this, id, "mBar", boost.max(ambient));
            } else if (id.equals("Boost Spool Rate (RPM)")) {
                DoubleArray abs = super.get("BoostPressureActual").data.smooth();
                DoubleArray rpm = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "mBar/RPM", abs.derivative(rpm).max(0.0));
            } else if (id.equals("Boost Spool Rate Zeit (RPM)")) {
                DoubleArray boost = this.get("Zeitronix Boost").data.smooth();
                DoubleArray rpm = this.get("RPM").data.movingAverage(this.filter.ZeitMAW()).smooth();
                c = new Dataset.Column((Dataset)this, id, "mBar/RPM", boost.derivative(rpm).max(0.0));
            } else if (id.equals("Boost Spool Rate (time)")) {
                DoubleArray abs = this.get("BoostPressureActual (PSI)").data.smooth();
                DoubleArray time = this.get("TIME").data;
                c = new Dataset.Column((Dataset)this, id, "PSI/sec", abs.derivative(time, this.MAW()).max(0.0));
            } else if (id.equals("ps_w error")) {
                DoubleArray abs = super.get("BoostPressureActual").data.max(900.0);
                DoubleArray ps_w = super.get("ME7L ps_w").data.max(900.0);
                c = new Dataset.Column((Dataset)this, id, "lambda", ps_w.div(abs));
            } else if (id.equals("LDR error")) {
                DoubleArray set = super.get("BoostPressureDesired").data;
                DoubleArray out = super.get("BoostPressureActual").data;
                c = new Dataset.Column((Dataset)this, id, "100mBar", set.sub(out).div(100.0));
            } else if (id.equals("LDR de/dt")) {
                DoubleArray set = super.get("BoostPressureDesired").data;
                DoubleArray out = super.get("BoostPressureActual").data;
                DoubleArray t = this.get("TIME").data;
                DoubleArray o = set.sub(out).derivative(t, this.MAW());
                c = new Dataset.Column((Dataset)this, id, "100mBar", o.mult(this.env.pid.time_constant).div(100.0));
            } else if (id.equals("LDR I e dt")) {
                DoubleArray set = super.get("BoostPressureDesired").data;
                DoubleArray out = super.get("BoostPressureActual").data;
                DoubleArray t = this.get("TIME").data;
                DoubleArray o = set.sub(out).integral(t, 0.0, this.env.pid.I_limit / this.env.pid.I * 100.0);
                c = new Dataset.Column((Dataset)this, id, "100mBar", o.div(this.env.pid.time_constant).div(100.0));
            } else if (id.equals("LDR PID")) {
                DoubleArray.TransferFunction fP = new DoubleArray.TransferFunction(){

                    @Override
                    public final double f(double x, double y) {
                        if (Math.abs(x) < ECUxDataset.this.env.pid.P_deadband / 100.0) {
                            return 0.0;
                        }
                        return x * ECUxDataset.this.env.pid.P;
                    }
                };
                DoubleArray.TransferFunction fD = new DoubleArray.TransferFunction(){

                    @Override
                    public final double f(double x, double y) {
                        if ((y = Math.abs(y)) < 3.0) {
                            return x * ECUxDataset.this.env.pid.D[0];
                        }
                        if (y < 5.0) {
                            return x * ECUxDataset.this.env.pid.D[1];
                        }
                        if (y < 7.0) {
                            return x * ECUxDataset.this.env.pid.D[2];
                        }
                        return x * ECUxDataset.this.env.pid.D[3];
                    }
                };
                DoubleArray E = this.get("LDR error").data;
                DoubleArray P = E.func(fP);
                DoubleArray I = this.get("LDR I e dt").data.mult(this.env.pid.I);
                DoubleArray D = this.get("LDR de/dt").data.func(fD, E);
                c = new Dataset.Column((Dataset)this, id, "%", P.add(I).add(D).max(0.0).min(95.0));
            } else if (id.equals("Sim pspvds")) {
                DoubleArray ps_w = super.get("ME7L ps_w").data;
                DoubleArray pvdkds = super.get("BoostPressureActual").data;
                c = new Dataset.Column((Dataset)this, id, "", ps_w.div(pvdkds));
            } else if (id.equals("IgnitionTimingAngleOverallDesired")) {
                DoubleArray averetard = null;
                int count = 0;
                for (int i = 0; i < 8; ++i) {
                    Dataset.Column retard = this.get((Comparable<?>)((Object)("IgnitionRetardCyl" + i)));
                    if (retard == null) continue;
                    averetard = averetard == null ? retard.data : averetard.add(retard.data);
                    ++count;
                }
                DoubleArray out = this.get("IgnitionTimingAngleOverall").data;
                if (count > 0) {
                    out = out.add(averetard.div(count).abs());
                }
                c = new Dataset.Column((Dataset)this, id, "\u00b0", out);
            } else if (id.equals("Sim LoadSpecified correction")) {
                DoubleArray cs = super.get("EngineLoadCorrected").data;
                DoubleArray s = super.get("EngineLoadSpecified").data;
                c = new Dataset.Column((Dataset)this, id, "K", cs.div(s));
            }
        }
        if (c == null && id.toString().endsWith(" (ms)")) {
            String s = id.toString();
            Dataset.Column t = this.get((Comparable<?>)((Object)(s = s.substring(0, s.length() - 5))));
            if (t != null) {
                DoubleArray r = this.get("RPM").data;
                c = new Dataset.Column((Dataset)this, id, "(ms)", t.data.div(r.mult(0.006)));
            }
        }
        if (c != null) {
            this.getColumns().add(c);
            return c;
        }
        return super.get(id);
    }

    @Override
    protected boolean dataValid(int i) {
        Dataset.Column boostDesired;
        Dataset.Column boostActual;
        Dataset.Column accel;
        boolean ret = true;
        if (this.filter == null) {
            return ret;
        }
        if (!this.filter.enabled()) {
            return ret;
        }
        ArrayList<CallSite> reasons = new ArrayList<CallSite>();
        if (this.filter.gear() >= 0 && this.gear != null && Math.round(this.gear.data.get(i)) != (long)this.filter.gear()) {
            reasons.add((CallSite)((Object)("gear " + Math.round(this.gear.data.get(i)) + "!=" + this.filter.gear())));
            ret = false;
        }
        if (this.pedal != null && this.pedal.data.get(i) < (double)this.filter.minPedal()) {
            reasons.add((CallSite)((Object)("pedal " + this.pedal.data.get(i) + "<" + this.filter.minPedal())));
            ret = false;
        }
        if (this.throttle != null && this.throttle.data.get(i) < (double)this.filter.minThrottle()) {
            reasons.add((CallSite)((Object)("throttle " + this.throttle.data.get(i) + "<" + this.filter.minThrottle())));
            ret = false;
        }
        if (this.filter.minAcceleration() > 0 && (accel = this.get((Comparable<?>)((Object)"Acceleration (RPM/s)"))) != null && accel.data.get(i) < (double)this.filter.minAcceleration()) {
            reasons.add((CallSite)((Object)("acceleration " + accel.data.get(i) + "<" + this.filter.minAcceleration() + " RPM/s")));
            ret = false;
        }
        if (this.zboost != null && this.zboost.data.get(i) < 0.0) {
            reasons.add((CallSite)((Object)("zboost " + this.zboost.data.get(i) + "<0")));
            ret = false;
        }
        if ((boostActual = this.get((Comparable<?>)((Object)"BoostPressureActual"))) != null && boostActual.data.get(i) < 1000.0) {
            reasons.add((CallSite)((Object)("boost actual " + boostActual.data.get(i) + "<1000 mBar (vacuum)")));
            ret = false;
        }
        if ((boostDesired = this.get((Comparable<?>)((Object)"BoostPressureDesired"))) != null && boostDesired.data.get(i) < 1000.0) {
            reasons.add((CallSite)((Object)("boost desired " + boostDesired.data.get(i) + "<1000 mBar (vacuum)")));
            ret = false;
        }
        if (this.rpm != null) {
            if (this.rpm.data.get(i) < (double)this.filter.minRPM()) {
                reasons.add((CallSite)((Object)("rpm " + this.rpm.data.get(i) + "<" + this.filter.minRPM())));
                ret = false;
            }
            if (this.rpm.data.get(i) > (double)this.filter.maxRPM()) {
                reasons.add((CallSite)((Object)("rpm " + this.rpm.data.get(i) + ">" + this.filter.maxRPM())));
                ret = false;
            }
            if (i > 0 && this.rpm.data.size() > i + 2 && this.rpm.data.get(i - 1) - this.rpm.data.get(i + 1) > (double)this.filter.monotonicRPMfuzz()) {
                reasons.add((CallSite)((Object)("rpm delta " + this.rpm.data.get(i - 1) + "-" + this.rpm.data.get(i + 1) + ">" + this.filter.monotonicRPMfuzz())));
                ret = false;
            }
        }
        if (!ret) {
            this.lastFilterReasons = reasons;
            logger.trace("Filter rejected data point {}: {}", (Object)i, (Object)String.join((CharSequence)", ", reasons));
        }
        return ret;
    }

    @Override
    protected boolean rangeValid(Dataset.Range r) {
        boolean ret = true;
        if (this.filter == null) {
            return ret;
        }
        if (!this.filter.enabled()) {
            return ret;
        }
        ArrayList<CallSite> reasons = new ArrayList<CallSite>();
        if (r.size() < this.filter.minPoints()) {
            reasons.add((CallSite)((Object)("points " + r.size() + "<" + this.filter.minPoints())));
            ret = false;
        }
        if (this.rpm != null && this.rpm.data.get(r.end) < this.rpm.data.get(r.start) + (double)this.filter.minRPMRange()) {
            reasons.add((CallSite)((Object)("RPM Range " + this.rpm.data.get(r.end) + "<" + this.rpm.data.get(r.start) + "+" + this.filter.minRPMRange())));
            ret = false;
        }
        if (!ret) {
            this.lastFilterReasons = reasons;
            logger.trace("Filter rejected range {}: {}", (Object)r, (Object)String.join((CharSequence)", ", reasons));
        }
        return ret;
    }

    private static final PrintStream nullStdout() {
        PrintStream original = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }));
        return original;
    }

    @Override
    public void buildRanges() {
        super.buildRanges();
        ArrayList<Dataset.Range> ranges = this.getRanges();
        this.splines = new CubicSpline[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            this.splines[i] = null;
            Dataset.Range r = ranges.get(i);
            double[] rpm = this.getData((Comparable<?>)((Object)"RPM"), r);
            double[] time = this.getData((Comparable<?>)((Object)"TIME"), r);
            if (rpm == null || time == null || time.length != rpm.length || rpm.length < 3) continue;
            PrintStream original = null;
            try {
                original = ECUxDataset.nullStdout();
                this.splines[i] = new CubicSpline(rpm, time);
                System.setOut(original);
                original = null;
                continue;
            }
            catch (Exception e) {
                if (original != null) {
                    System.setOut(original);
                }
                logger.warn("CubicSpline:", (Throwable)e);
            }
        }
    }

    public double calcFATS(int run, int RPMStart, int RPMEnd) throws Exception {
        return this.calcFATSRPM(run, RPMStart, RPMEnd);
    }

    public double calcFATSBySpeed(int run, double speedStart, double speedEnd) throws Exception {
        return this.calcFATSMPH(run, speedStart, speedEnd);
    }

    private double calcFATSRPM(int run, int RPMStart, int RPMEnd) throws Exception {
        ArrayList<Dataset.Range> ranges = this.getRanges();
        if (run < 0 || run >= ranges.size()) {
            throw new Exception("FATS run " + run + " not found (available: 0-" + (ranges.size() - 1) + ")");
        }
        if (this.splines[run] == null) {
            throw new Exception("FATS run " + run + " interpolation failed - check filter settings");
        }
        Dataset.Range r = ranges.get(run);
        logger.trace("FATS RPM calculation: run={}, range={}-{}", new Object[]{run, r.start, r.end});
        logger.trace("FATS RPM calculation: {} RPM -> {} RPM", (Object)RPMStart, (Object)RPMEnd);
        double et = this.splines[run].interpolate((double)RPMEnd) - this.splines[run].interpolate((double)RPMStart);
        if (et <= 0.0) {
            throw new Exception("FATS RPM calculation failed: timeEnd <= timeStart for RPM range " + RPMStart + "-" + RPMEnd);
        }
        return et;
    }

    private double calcFATSMPH(int run, double speedStart, double speedEnd) throws Exception {
        ArrayList<Dataset.Range> ranges = this.getRanges();
        if (run < 0 || run >= ranges.size()) {
            throw new Exception("FATS run " + run + " not found (available: 0-" + (ranges.size() - 1) + ")");
        }
        if (this.splines[run] == null) {
            throw new Exception("FATS run " + run + " interpolation failed - check filter settings");
        }
        Dataset.Range r = ranges.get(run);
        logger.trace("FATS MPH calculation: run={}, range={}-{}", new Object[]{run, r.start, r.end});
        double rpmPerMph = this.env.c.rpm_per_mph();
        int rpmStart = (int)Math.round(speedStart * rpmPerMph);
        int rpmEnd = (int)Math.round(speedEnd * rpmPerMph);
        logger.trace("FATS MPH->RPM conversion: {} mph -> {} RPM, {} mph -> {} RPM", new Object[]{speedStart, rpmStart, speedEnd, rpmEnd});
        return this.calcFATSRPM(run, rpmStart, rpmEnd);
    }

    public double[] calcFATS(int RPMStart, int RPMEnd) {
        ArrayList<Dataset.Range> ranges = this.getRanges();
        double[] out = new double[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            try {
                out[i] = this.calcFATS(i, RPMStart, RPMEnd);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Env getEnv() {
        return this.env;
    }

    @Override
    public boolean useId2() {
        return this.env.prefs.getBoolean("altnames", false);
    }
}

