/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.util.TreeMap;
import org.jfree.data.category.DefaultCategoryDataset;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.ecuxplot.FATS;
import org.nyet.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FATSDataset
extends DefaultCategoryDataset {
    private static final Logger logger = LoggerFactory.getLogger(FATSDataset.class);
    private static final long serialVersionUID = 1L;
    private int start = 4200;
    private int end = 6500;
    private final TreeMap<String, ECUxDataset> fileDatasets;
    private final FATS fats;

    public FATSDataset(TreeMap<String, ECUxDataset> fileDatasets, FATS fats) {
        this.fileDatasets = fileDatasets;
        this.fats = fats;
        this.updateFromFATS();
        this.rebuild();
    }

    private void updateFromFATS() {
        if (this.fats.useMph()) {
            if (!this.fileDatasets.isEmpty()) {
                ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
                double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
                this.start = this.fats.mphToRpm(this.fats.startMph(), rpmPerMph);
                this.end = this.fats.mphToRpm(this.fats.endMph(), rpmPerMph);
            }
        } else {
            this.start = this.fats.start();
            this.end = this.fats.end();
        }
    }

    boolean hasVehicleSpeedData() {
        for (ECUxDataset dataset : this.fileDatasets.values()) {
            if (dataset.get((Comparable<?>)((Object)"VehicleSpeed")) == null) continue;
            return true;
        }
        return false;
    }

    boolean needsRpmPerMphConversion() {
        for (ECUxDataset dataset : this.fileDatasets.values()) {
            if (dataset.get((Comparable<?>)((Object)"VehicleSpeed")) != null) continue;
            return true;
        }
        return false;
    }

    private void rebuild() {
        this.clear();
        for (ECUxDataset data : this.fileDatasets.values()) {
            this.setValue(data);
        }
    }

    public void setValue(ECUxDataset data, int series, double value) {
        String xkey = "Run " + (series + 1);
        String ykey = Files.stem(data.getFileId());
        super.setValue(value, (Comparable)((Object)xkey), (Comparable)((Object)ykey));
    }

    public void removeValue(ECUxDataset data, int series) {
        String xkey = "Run " + (series + 1);
        String ykey = Files.stem(data.getFileId());
        super.removeValue((Comparable)((Object)xkey), (Comparable)((Object)ykey));
    }

    private void logFATSSummary(ECUxDataset data, int series, double value, int rpmStart, int rpmEnd) {
        double endMph;
        double startMph;
        String filename = Files.stem(data.getFileId());
        String runNumber = "run " + (series + 1);
        if (this.fats.useMph()) {
            startMph = this.fats.startMph();
            endMph = this.fats.endMph();
        } else {
            ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
            double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
            startMph = (double)rpmStart / rpmPerMph;
            endMph = (double)rpmEnd / rpmPerMph;
        }
        String message = String.format("FATS: %s %s, %d (%.0fmph) - %d (%.0fmph) = %.1f seconds", filename, runNumber, rpmStart, startMph, rpmEnd, endMph, value);
        logger.info(message);
    }

    public void setValue(ECUxDataset data) {
        try {
            this.removeColumn((Comparable)((Object)Files.stem(data.getFileId())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < data.getRanges().size(); ++i) {
            this.setValue(data, i);
        }
    }

    public void setValue(ECUxDataset data, int series) {
        if (!data.getFilter().enabled()) {
            logger.info("FATS calculation skipped for {} run {}: filter disabled", (Object)Files.stem(data.getFileId()), (Object)series);
            this.removeValue(data, series);
            return;
        }
        try {
            double value = this.fats.useMph() ? data.calcFATSBySpeed(series, this.fats.startMph(), this.fats.endMph()) : data.calcFATS(series, this.start, this.end);
            this.setValue(data, series, value);
            this.logFATSSummary(data, series, value, this.start, this.end);
        }
        catch (Exception e) {
            logger.warn("FATS calculation failed for {} run {}: {}", new Object[]{Files.stem(data.getFileId()), series, e.getMessage()});
            this.removeValue(data, series);
        }
    }

    public void setStart(int start) {
        if (this.fats.useMph()) {
            if (!this.fileDatasets.isEmpty()) {
                ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
                double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
                this.fats.startMph(this.fats.rpmToMph(start, rpmPerMph));
            }
        } else {
            this.fats.start(start);
        }
        this.updateFromFATS();
        this.rebuild();
    }

    public void setEnd(int end) {
        if (this.fats.useMph()) {
            if (!this.fileDatasets.isEmpty()) {
                ECUxDataset firstDataset = this.fileDatasets.values().iterator().next();
                double rpmPerMph = firstDataset.getEnv().c.rpm_per_mph();
                this.fats.endMph(this.fats.rpmToMph(end, rpmPerMph));
            }
        } else {
            this.fats.end(end);
        }
        this.updateFromFATS();
        this.rebuild();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void refreshFromFATS() {
        this.updateFromFATS();
        this.rebuild();
    }

    public String getTitle() {
        if (this.fats.useMph()) {
            if (this.hasVehicleSpeedData()) {
                return String.format("%d-%d MPH (VehicleSpeed)", Math.round(this.fats.startMph()), Math.round(this.fats.endMph()));
            }
            return String.format("%d-%d MPH (Calculated)", Math.round(this.fats.startMph()), Math.round(this.fats.endMph()));
        }
        return this.start + "-" + this.end + " RPM";
    }
}

