/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.ecuxplot;

import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.nyet.ecuxplot.Fueling;
import org.nyet.ecuxplot.PreferencesEditor;

public class FuelingEditor
extends PreferencesEditor {
    private static final long serialVersionUID = 1L;
    private final Fueling fueling;
    public JTextField MAF;
    public JLabel MAFCorrection;
    public JTextField injector;
    public JTextField MAF_offset;
    public JTextField cylinders;
    public JTextField turbos;
    private static final String[][] pairs = new String[][]{{"MAF diameter (mm)", "MAF"}, {"MAF correction (%)", "MAFCorrection"}, {"Injector size (cc/min)", "injector"}, {"MAF offset (g/sec)", "MAF_offset"}, {"Cylinders", "cylinders"}, {"Turbos", "turbos"}};
    private static final int[] fieldSizes = new int[]{6, 0, 6, 6, 6, 6};

    @Override
    protected void Process(ActionEvent event) {
        this.fueling.MAF(Double.valueOf(this.MAF.getText()));
        this.updateMAFCorrection();
        this.fueling.injector(Double.valueOf(this.injector.getText()));
        this.fueling.MAF_offset(Double.valueOf(this.MAF_offset.getText()));
        this.fueling.cylinders(Integer.valueOf(this.cylinders.getText()));
        this.fueling.turbos(Integer.valueOf(this.turbos.getText()));
        super.Process(event);
    }

    public FuelingEditor(Preferences prefs, Fueling f) {
        super(prefs.node("fueling"), pairs, fieldSizes);
        this.fueling = f;
    }

    private String getMAFCorrection() {
        return String.format("%.1f", this.fueling.MAF_correction() * 100.0);
    }

    private void updateMAFCorrection() {
        this.MAFCorrection.setText(this.getMAFCorrection());
    }

    @Override
    public void updateDialog() {
        this.MAF.setText("" + this.fueling.MAF());
        this.updateMAFCorrection();
        this.injector.setText("" + this.fueling.injector());
        this.MAF_offset.setText("" + this.fueling.MAF_offset());
        this.cylinders.setText("" + this.fueling.cylinders());
        this.turbos.setText("" + this.fueling.turbos());
    }
}

