/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.mappack;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.nyet.mappack.HexValue;
import org.nyet.mappack.Parse;
import org.nyet.mappack.ParserException;

public class Folder
implements Comparable<Object> {
    public int id;
    private final int kpv;
    private final HexValue header;
    public String name;
    private final byte[] header1 = new byte[2];
    private final HexValue header2;
    private final byte[] header3 = new byte[15];

    public Folder(ByteBuffer b, int kpv) throws ParserException {
        this.kpv = kpv;
        this.id = b.getInt();
        this.header = new HexValue(b);
        this.name = Parse.string(b);
        Parse.buffer(b, this.header1);
        this.header2 = new HexValue(b);
        if (kpv == 2) {
            Parse.buffer(b, this.header3);
        }
    }

    private String toStringDump() {
        String out = "     id: " + this.id + "\n";
        out = out + " header: " + String.valueOf(this.header) + "\n";
        out = out + "   name: " + this.name + "\n";
        out = out + "header1: " + Arrays.toString(this.header1) + "\n";
        out = out + "header2: " + String.valueOf(this.header2) + "\n";
        if (this.kpv == 2) {
            out = out + "header3: " + Arrays.toString(this.header3) + "\n";
        }
        return out;
    }

    public String toString(int format) {
        switch (format) {
            case 0: {
                return this.toStringDump();
            }
        }
        return "";
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Object o) {
        if (this.name.equals(o.toString())) {
            return 0;
        }
        if (this.name.equals("My maps")) {
            return -1;
        }
        if (o.toString().equals("My maps")) {
            return 1;
        }
        return this.name.compareTo(o.toString());
    }
}

