/*
 * Decompiled with CFR 0.152.
 */
package org.nyet.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class Locate {
    public static URL getUrlOfClass(Class<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String className = c.getName();
        String resourceName = className.replace('.', '/') + ".class";
        ClassLoader classLoader = c.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        URL url = classLoader.getResource(resourceName);
        return url;
    }

    public static File getClassLocation(Class<? extends Object> c) throws IOException, FileNotFoundException {
        URL url;
        String szUrl;
        if (c == null) {
            throw new NullPointerException();
        }
        String className = c.getName();
        String resourceName = className.replace('.', '/') + ".class";
        ClassLoader classLoader = c.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((szUrl = (url = classLoader.getResource(resourceName)).toString()).startsWith("jar:file:")) {
            try {
                szUrl = szUrl.substring("jar:".length(), szUrl.lastIndexOf("!"));
                URI uri = new URI(szUrl);
                return new File(uri);
            }
            catch (URISyntaxException e) {
                throw new IOException(e.toString());
            }
        }
        if (szUrl.startsWith("file:")) {
            try {
                szUrl = szUrl.substring(0, szUrl.length() - resourceName.length());
                URI uri = new URI(szUrl);
                return new File(uri);
            }
            catch (URISyntaxException e) {
                throw new IOException(e.toString());
            }
        }
        throw new FileNotFoundException(szUrl);
    }

    public static File getClassDirectory(Class<? extends Object> c) throws IOException, FileNotFoundException {
        File dir = Locate.getClassLocation(c);
        if (dir.isDirectory()) {
            return dir;
        }
        return dir.getParentFile();
    }

    public static File getClassDirectory(Object o) throws IOException, FileNotFoundException {
        return Locate.getClassDirectory(o.getClass());
    }

    public static File getDataDirectory(String app) {
        Object dir = System.getProperty("user.home");
        if (System.getProperty("os.name").startsWith("Windows")) {
            dir = (String)dir + File.separator + "Application Data";
        } else {
            app = "." + (String)app;
        }
        return new File((String)dir, (String)app);
    }
}

