/*
 * Decompiled with CFR 0.152.
 */
package test.java;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nyet.ecuxplot.ECUxDataset;
import org.nyet.logfile.Dataset;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LoggerDetectionTest {
    private static int testsRun = 0;
    private static int testsPassed = 0;
    private static int testsFailed = 0;
    private static int fileTestsFailed = 0;

    public static void main(String[] args) {
        boolean detectionOnly;
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Logger ecuxLogger = (Logger)LoggerFactory.getLogger((String)"org.nyet.ecuxplot");
        rootLogger.setLevel(Level.INFO);
        ecuxLogger.setLevel(Level.INFO);
        boolean bl = detectionOnly = args.length > 0 && "detection".equals(args[0]);
        if (detectionOnly) {
            System.out.println("=== Logger Detection Only Tests ===");
        } else {
            System.out.println("=== Logger Detection Tests ===");
        }
        System.out.println();
        LoggerDetectionTest.testComprehensiveExpectations(detectionOnly);
        System.out.println();
        System.out.println("=== Test Results ===");
        System.out.println("Tests run: " + testsRun);
        System.out.println("Tests passed: " + testsPassed);
        System.out.println("Tests failed: " + testsFailed);
        if (testsFailed == 0) {
            System.out.println("\u2705 All tests passed!");
        } else {
            System.out.println("\u274c " + testsFailed + " tests failed!");
        }
    }

    private static void assertTest(String testName, boolean condition) {
        ++testsRun;
        if (condition) {
            ++testsPassed;
        } else {
            ++testsFailed;
            ++fileTestsFailed;
            System.out.println("  \u274c " + testName);
        }
    }

    private static void testComprehensiveExpectations(boolean detectionOnly) {
        if (detectionOnly) {
            System.out.println("Testing detection expectations from XML...");
        } else {
            System.out.println("Testing comprehensive expectations from XML...");
        }
        try {
            File xmlFile = new File("test-data/test-expectations.xml");
            if (!xmlFile.exists()) {
                LoggerDetectionTest.assertTest("XML expectations file exists", false);
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new FileInputStream(xmlFile));
            document.getDocumentElement().normalize();
            NodeList testCases = document.getElementsByTagName("test_case");
            for (int i = 0; i < testCases.getLength(); ++i) {
                Element testCase = (Element)testCases.item(i);
                String fileName = testCase.getAttribute("file");
                fileTestsFailed = 0;
                File testFile = new File("test-data/" + fileName);
                LoggerDetectionTest.assertTest("Test file exists: " + fileName, testFile.exists());
                if (!testFile.exists()) {
                    System.out.println("\u274c " + fileName);
                    continue;
                }
                try {
                    String expectedType = LoggerDetectionTest.getTextContent(testCase, "expected_type");
                    String actualType = LoggerDetectionTest.testDetectionOnly("test-data/" + fileName);
                    LoggerDetectionTest.assertTest("Detection for " + fileName + ": expected " + expectedType + ", got " + actualType, expectedType.equals(actualType));
                    if (!detectionOnly) {
                        ECUxDataset dataset = new ECUxDataset("test-data/" + fileName, null, null, 0);
                        LoggerDetectionTest.testExpectedIds(testCase, dataset, fileName);
                        LoggerDetectionTest.testExpectedId2s(testCase, dataset, fileName);
                        LoggerDetectionTest.testExpectedUnits(testCase, dataset, fileName);
                        LoggerDetectionTest.testSanityCheck(testCase, dataset, fileName);
                    }
                }
                catch (Exception e) {
                    if (detectionOnly) {
                        LoggerDetectionTest.assertTest("Can detect logger type for: " + fileName, false);
                    } else {
                        LoggerDetectionTest.assertTest("Can parse file: " + fileName, false);
                    }
                    System.out.println("  Error " + (detectionOnly ? "detecting" : "parsing") + " " + fileName + ": " + e.getMessage());
                }
                if (fileTestsFailed == 0) {
                    System.out.println("\u2705 " + fileName);
                    continue;
                }
                System.out.println("\u274c " + fileName);
                System.out.println("STOPPING AT FIRST FILE WITH ERRORS FOR DEBUGGING");
                System.exit(1);
            }
        }
        catch (Exception e) {
            LoggerDetectionTest.assertTest("Load XML expectations", false);
            System.out.println("  Error loading XML: " + e.getMessage());
        }
    }

    private static String testDetectionOnly(String filePath) throws Exception {
        ECUxDataset dataset = new ECUxDataset(filePath, null, null, 0);
        return dataset.getLogDetected();
    }

    private static void testExpectedIds(Element testCase, ECUxDataset dataset, String fileName) {
        NodeList expectedIds = testCase.getElementsByTagName("expected_ids");
        if (expectedIds.getLength() == 0) {
            return;
        }
        Element idsElement = (Element)expectedIds.item(0);
        NodeList idNodes = idsElement.getElementsByTagName("id");
        for (int i = 0; i < idNodes.getLength(); ++i) {
            Element idElement = (Element)idNodes.item(i);
            int index = Integer.parseInt(idElement.getAttribute("index"));
            String expectedId = idElement.getTextContent();
            if (index >= dataset.getIds().length) continue;
            String actualId = dataset.getIds()[index].id;
            LoggerDetectionTest.assertTest("ID[" + index + "] for " + fileName + ": expected '" + expectedId + "', got '" + actualId + "'", expectedId.equals(actualId));
        }
    }

    private static void testExpectedId2s(Element testCase, ECUxDataset dataset, String fileName) {
        NodeList expectedId2s = testCase.getElementsByTagName("expected_id2s");
        if (expectedId2s.getLength() == 0) {
            return;
        }
        Element id2sElement = (Element)expectedId2s.item(0);
        NodeList id2Nodes = id2sElement.getElementsByTagName("id2");
        for (int i = 0; i < id2Nodes.getLength(); ++i) {
            Element id2Element = (Element)id2Nodes.item(i);
            int index = Integer.parseInt(id2Element.getAttribute("index"));
            String expectedId2 = id2Element.getTextContent();
            if (index >= dataset.getIds().length) continue;
            String actualId2 = dataset.getIds()[index].id2;
            LoggerDetectionTest.assertTest("ID2[" + index + "] for " + fileName + ": expected '" + expectedId2 + "', got '" + actualId2 + "'", expectedId2.equals(actualId2));
        }
    }

    private static void testExpectedUnits(Element testCase, ECUxDataset dataset, String fileName) {
        NodeList expectedUnits = testCase.getElementsByTagName("expected_units");
        if (expectedUnits.getLength() == 0) {
            return;
        }
        Element unitsElement = (Element)expectedUnits.item(0);
        NodeList unitNodes = unitsElement.getElementsByTagName("unit");
        for (int i = 0; i < unitNodes.getLength(); ++i) {
            Element unitElement = (Element)unitNodes.item(i);
            int index = Integer.parseInt(unitElement.getAttribute("index"));
            String expectedUnit = unitElement.getTextContent();
            if (index >= dataset.getIds().length) continue;
            String actualUnit = dataset.getIds()[index].unit;
            LoggerDetectionTest.assertTest("Unit[" + index + "] for " + fileName + ": expected '" + expectedUnit + "', got '" + actualUnit + "'", expectedUnit.equals(actualUnit));
        }
    }

    private static void testSanityCheck(Element testCase, ECUxDataset dataset, String fileName) {
        NodeList sanityChecks = testCase.getElementsByTagName("sanity_check");
        if (sanityChecks.getLength() == 0) {
            return;
        }
        Element sanityElement = (Element)sanityChecks.item(0);
        int row = Integer.parseInt(sanityElement.getAttribute("row"));
        int col = Integer.parseInt(sanityElement.getAttribute("col"));
        String expectedValue = sanityElement.getTextContent();
        try {
            if (dataset.getColumns().size() > col) {
                Dataset.Column column = dataset.getColumns().get(col);
                if (column.data.size() > row) {
                    String actualValue = String.valueOf(column.data.get(row));
                    LoggerDetectionTest.assertTest("Sanity check [" + row + "," + col + "] for " + fileName + ": expected '" + expectedValue + "', got '" + actualValue + "'", expectedValue.equals(actualValue));
                }
            }
        }
        catch (Exception e) {
            LoggerDetectionTest.assertTest("Sanity check for " + fileName, false);
        }
    }

    private static String getTextContent(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return "";
    }
}

