/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.nyet.mappack.Map;
import org.nyet.mappack.Parser;
import org.nyet.mappack.Project;
import org.nyet.util.MMapFile;

public class mapdump {
    public static void main(String[] args) throws Exception {
        MapDumpOptions opts = new MapDumpOptions();
        try {
            opts.Parse(args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println(opts.Usage());
            return;
        }
        Parser mp = new Parser(opts.input);
        ArrayList<Parser> refs = new ArrayList<Parser>();
        ByteBuffer imagebuf = null;
        Object refsHeader = "";
        for (String s : opts.refs) {
            refs.add(new Parser(s));
            refsHeader = (String)refsHeader + ",\"" + s + "\"";
        }
        if (opts.image != null) {
            MMapFile mmap = new MMapFile(opts.image, ByteOrder.LITTLE_ENDIAN);
            imagebuf = mmap.getByteBuffer();
        }
        switch (opts.format) {
            case 1: {
                opts.output.print(Map.CSVHeader() + (String)refsHeader);
                opts.output.println();
                break;
            }
            case 2: {
                opts.output.print("XDF\n1.110000\n\n");
                break;
            }
            case 3: {
                Date date = new Date();
                opts.output.print("<!-- Written " + date.toString() + " -->\n");
                opts.output.print("<XDFFORMAT version=\"1.50\">\n");
                break;
            }
        }
        for (Project p : mp.projects) {
            opts.output.print(p.toString(opts.format, imagebuf));
            if (p.maps == null) continue;
            for (Map m : p.maps) {
                opts.output.print(m.toString(opts.format, imagebuf));
                if (opts.format != 1) continue;
                for (Parser pa : refs) {
                    ArrayList<Map> matches = pa.find(m);
                    if (matches.size() > 0) {
                        Map r = matches.get(0);
                        opts.output.print(",\"" + r.name + "\"");
                        continue;
                    }
                    opts.output.print(",\"\"");
                }
                opts.output.println();
            }
        }
        if (opts.format == 3) {
            opts.output.print("</XDFFORMAT>\n");
        }
    }

    private static class MapDumpOptions
    extends Options {
        private static final long serialVersionUID = 20150620L;
        String input = null;
        PrintStream output = System.out;
        String[] refs = new String[0];
        String image = null;
        int format = 1;

        public MapDumpOptions() {
            Option r = Option.builder("r").argName("maps.kp [...]").hasArg().hasArgs().desc("Annotate with descriptions from matching maps also in these mappacks (ignored if -x is used)").build();
            Option i = Option.builder("i").argName("image.bin").hasArg().desc("Generate min/max columns and image size based on this image").build();
            Option d = new Option("d", "Generate raw dump");
            Option o = new Option("o", "Generate old xdf (requires -i <image.bin>)");
            Option x = new Option("x", "Generate xml xdf (requires -i <image.bin>)");
            this.addOption(r);
            this.addOption(i);
            this.addOption(d);
            this.addOption(o);
            this.addOption(x);
        }

        public void Parse(String[] args) throws ParseException {
            String[] left;
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(this, args);
            if (line.hasOption('r')) {
                this.refs = line.getOptionValues("r");
            }
            if (line.hasOption('i')) {
                this.image = line.getOptionValue("i");
            }
            if (line.hasOption('d')) {
                this.format = 0;
            }
            if (line.hasOption('o')) {
                if (this.format != 1) {
                    throw new ParseException("Can only specify one of '-d', '-o', '-x'");
                }
                if (this.image == null) {
                    throw new ParseException("-o requires -i <image.bin> to detect image size");
                }
                this.format = 2;
            }
            if (line.hasOption('x')) {
                if (this.format != 1) {
                    throw new ParseException("Can only specify one of '-d', '-o', '-x'");
                }
                if (this.image == null) {
                    throw new ParseException("-x requires -i <image.bin> to detect image size");
                }
                this.format = 3;
            }
            if ((left = line.getArgs()).length <= 0) {
                throw new ParseException("You must specify an input filename");
            }
            this.input = left[0];
            if (left.length > 1) {
                try {
                    this.output = new PrintStream(left[1]);
                }
                catch (Exception e) {
                    throw new ParseException("Can't open '" + left[1] + "' for writing:\n  " + e.getMessage());
                }
            }
            if (left.length > 2) {
                throw new ParseException("Too many arguments");
            }
        }

        public String Usage() {
            StringWriter sw = new StringWriter();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printOptions(new PrintWriter(sw), 80, this, 1, 3);
            return "Usage: mapdump [options] maps.kp [outputfile]\nOptions:\n" + sw.getBuffer().toString();
        }
    }
}

