/*
 * Decompiled with CFR 0.152.
 */
package vec_math;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import vec_math.LinearSmoothing;

public class SavitzkyGolaySmoothing
extends LinearSmoothing {
    private static final double[] M2L2R2 = new double[]{-0.086, 0.343, 0.486, 0.343, -0.086};
    private static final double[] M2L3R1 = new double[]{-0.143, 0.171, 0.343, 0.371, 0.257};
    private static final double[] M2L4R0 = new double[]{0.086, -0.143, -0.086, 0.257, 0.886};
    private static final double[] M2L5R5 = new double[]{-0.084, 0.021, 0.103, 0.161, 0.196, 0.207, 0.196, 0.161, 0.103, 0.021, -0.084};
    private static final double[] M4L6R0D1 = new double[]{0.26876, -0.85585, 0.49695, 0.8628, -0.54272, -1.82409, 1.5942};
    private static final double[] M4L4R4 = new double[]{0.035, -0.128, 0.07, 0.315, 0.417, 0.315, 0.07, -0.128, 0.035};
    private static final double[] M4L5R5 = new double[]{0.042, -0.105, -0.023, 0.14, 0.28, 0.333, 0.28, 0.14, -0.023, -0.105, 0.042};
    protected int degree;
    protected int derivative;

    public SavitzkyGolaySmoothing() {
        this(2, 4, 0, 0);
    }

    public SavitzkyGolaySmoothing(int nl, int nr) {
        this(2, nl, nr, 0);
    }

    public SavitzkyGolaySmoothing(int deg, int nl, int nr, int der) {
        this.degree = deg;
        this.derivative = der;
        this.nk = -nl;
        this.nj = 0;
        boolean allowed = false;
        if (der != 0) {
            if (der == 1 && nl == 6 && nr == 0 && deg == 4) {
                allowed = true;
                this.cn = M4L6R0D1;
            } else {
                throw new IllegalArgumentException("Not implemented!");
            }
        }
        if (deg == 2 && nl == 2 && nr == 2) {
            allowed = true;
            this.cn = M2L2R2;
        }
        if (deg == 2 && nl == 3 && nr == 1) {
            allowed = true;
            this.cn = M2L3R1;
        }
        if (deg == 2 && nl == 4 && nr == 0) {
            allowed = true;
            this.cn = M2L4R0;
        }
        if (deg == 2 && nl == 5 && nr == 5) {
            allowed = true;
            this.cn = M2L5R5;
        }
        if (deg == 4 && nl == 4 && nr == 4) {
            allowed = true;
            this.cn = M4L4R4;
        }
        if (deg == 4 && nl == 5 && nr == 5) {
            allowed = true;
            this.cn = M4L5R5;
        }
        if (!allowed) {
            throw new IllegalArgumentException("Not implemented!");
        }
        this.setType();
    }

    public SavitzkyGolaySmoothing(InputStream coef) {
        if (coef != null) {
            this.calcInputCoeff(coef);
        }
    }

    @Override
    protected void setType() {
        this.type = 1;
    }

    protected void calcInputCoeff(InputStream instream) {
        try {
            int m;
            BufferedReader in = new BufferedReader(new InputStreamReader(instream));
            String line = in.readLine();
            if (!line.startsWith("#savitzky-golay")) {
                throw new IllegalArgumentException("wrong header in file!");
            }
            StringTokenizer breakup = new StringTokenizer(line);
            if (breakup.countTokens() != 4) {
                throw new IllegalArgumentException("wrong header arguments");
            }
            breakup.nextToken();
            int nl = Integer.parseInt(breakup.nextToken());
            int nr = Integer.parseInt(breakup.nextToken());
            this.degree = m = Integer.parseInt(breakup.nextToken());
            this.nk = -nl;
            this.cn = new double[nl + nr + 1];
            for (int i1 = 0; i1 != nl + nr + 1; ++i1) {
                this.cn[i1] = Double.valueOf(in.readLine().trim());
            }
            in.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("wrong file");
        }
    }

    public int getDegree() {
        return this.degree;
    }

    public int getDerivative() {
        return this.derivative;
    }
}

