/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealSquareSolver;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.SimplePointer;

public class CrautSolver
extends RealSquareSolver {
    private char[] pivotIndex = null;

    public CrautSolver() {
    }

    public CrautSolver(int n) {
        super(new DenseMatrix(n, n));
    }

    public CrautSolver(DenseMatrix denseMatrix) {
        super(denseMatrix);
    }

    public CrautSolver(RealContainer realContainer, int n) {
        super(new DenseMatrix(realContainer, n, n));
    }

    public void attach(DenseMatrix denseMatrix) {
        super.attach(denseMatrix);
        this.pivotIndex = null;
    }

    public void factorize() throws CalculatingException {
        int n;
        if (this.isFactorized()) {
            return;
        }
        this.matrix.lock();
        if (this.matrix.nRows == 0) {
            this.setFactorized(true);
            return;
        }
        RealContainer realContainer = this.matrix.getContainer();
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep;
        int n4 = this.matrix.nRows;
        double d = realContainer.relativeAccuracy() * 8.0;
        if (this.pivotIndex == null) {
            this.pivotIndex = new char[n4];
        }
        int n5 = n = this.matrix.startIndex;
        int n6 = n;
        int n7 = 0;
        while (n7 < n4) {
            double d2;
            int n8 = n7 - 1;
            double d3 = 0.0;
            int n9 = n7;
            int n10 = n5;
            int n11 = n6;
            while (n9 < n4) {
                d2 = realContainer.get(n11);
                double d4 = Math.abs(realContainer.add(n11, -realContainer.postProduct(n, n2, n10, n3, n7)));
                if (d4 > d3 && d4 > Math.abs(d2) * d) {
                    n8 = n9;
                    d3 = d4;
                }
                ++n9;
                n10 += n2;
                n11 += n2;
            }
            if ((n8 -= n7) < 0) {
                throw new CalculatingException("Ill-posed matrix");
            }
            if (n8 != 0) {
                realContainer.swap(n5, n3, n5 + n8 * n2, n3, n4);
            }
            this.pivotIndex[n7] = (char)n8;
            d2 = realContainer.get(n6);
            n9 = n7 + 1;
            n10 = n;
            n11 = n6;
            while (n9 < n4) {
                realContainer.set(n11 += n3, (realContainer.get(n11) - realContainer.postProduct(n10 += n3, n2, n5, n3, n7)) / d2);
                ++n9;
            }
            ++n7;
            n6 += n2 + n3;
            n += n3;
            n5 += n2;
        }
        this.setFactorized(true);
    }

    public void solve(RealVector realVector, RealVector realVector2) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        if (n == 0) {
            return;
        }
        realVector.ensureLength(n);
        realVector2.ensureLength(n);
        if (realVector != realVector2) {
            realVector2.assign(realVector, n);
        }
        int n2 = this.matrix.columnStep;
        int n3 = this.matrix.rowStep;
        int n4 = this.matrix.startIndex;
        RealContainer realContainer = this.matrix.getContainer();
        int n5 = 0;
        while (n5 < n) {
            char c = this.pivotIndex[n5];
            if (c != '\u0000') {
                realVector2.swap(n5, n5 + c);
            }
            ++n5;
        }
        RealPointer realPointer = realVector2.getPointer();
        RealSquareSolver.forwardSubstitution(realContainer, n4, n3, n2, realContainer.getPointer(n4, n3 + n2), realPointer, realPointer, n);
        realPointer.reset(n - 1, -1);
        RealSquareSolver.forwardSubstitution(realContainer, n4 += (n - 1) * (n3 + n2), -n3, -n2, new SimplePointer(1.0), realPointer, realPointer, n);
    }
}

