/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealCommonSolver;
import ru.sscc.util.Rotation;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class RotationSolver
extends RealCommonSolver {
    public RotationSolver() {
    }

    public RotationSolver(int n, int n2) {
        super(new DenseMatrix(n, n2));
    }

    public RotationSolver(DenseMatrix denseMatrix) {
        super(denseMatrix);
    }

    public RotationSolver(RealContainer realContainer, int n, int n2) {
        super(new DenseMatrix(realContainer, n, n2));
    }

    protected void doFactorize() {
        RealContainer realContainer = this.matrix.getContainer();
        int n = this.matrix.nRows;
        int n2 = this.matrix.nColumns;
        int n3 = Math.min(n, n2);
        int n4 = this.matrix.rowStep;
        int n5 = this.matrix.columnStep;
        int n6 = this.matrix.startIndex;
        double d = Math.max(this.matrix.relativeAccuracy() * 8.0, this.getReductionAccuracy());
        d *= d;
        Rotation rotation = new Rotation();
        int n7 = 0;
        int n8 = n6;
        while (n7 < n2) {
            if (this.range == n || realContainer.preProduct(n8, -n4, n8, -n4, this.range) * d * (double)this.range >= realContainer.postProduct(n8, n4, n8, n4, n - this.range)) {
                this.prepareNullVector(n7);
            } else {
                int n9 = this.range + 1;
                int n10 = n8;
                while (n9 < n) {
                    rotation.constructAndRotate(realContainer, n8, n5, n10 += n4, n5, n2 - n7);
                    ++n9;
                }
                if (n7 != this.range) {
                    realContainer.assign(n6 + this.range * n5, n4, n6 + n7 * n5, n4, n);
                }
                n8 += n4;
                ++this.range;
                this.columnFactorized(n7);
            }
            ++n7;
            n8 += n5;
        }
    }

    public void transform(DenseMatrix denseMatrix) {
        this.ensureFactorized();
        this.ensureTransformable(denseMatrix);
        int n = denseMatrix.nRows;
        int n2 = denseMatrix.nColumns;
        int n3 = denseMatrix.rowStep;
        int n4 = denseMatrix.columnStep;
        RealContainer realContainer = denseMatrix.getContainer();
        int n5 = this.matrix.rowStep;
        int n6 = this.matrix.columnStep + n5;
        RealContainer realContainer2 = this.matrix.getContainer();
        Rotation rotation = new Rotation();
        int n7 = 0;
        int n8 = denseMatrix.startIndex;
        int n9 = this.matrix.startIndex;
        while (n7 < this.range) {
            int n10 = n7 + 1;
            int n11 = n8;
            int n12 = n9;
            while (n10 < n) {
                rotation.construct(realContainer2.get(n12 += n5));
                rotation.rotate(realContainer, n8, n4, n11 += n3, n4, n2);
                ++n10;
            }
            ++n7;
            n8 += n3;
            n9 += n6;
        }
    }

    public void transform(RealVector realVector) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        realVector.ensureLength(n);
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep + n2;
        RealContainer realContainer = this.matrix.getContainer();
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector.getPointer();
        Rotation rotation = new Rotation();
        int n4 = 0;
        int n5 = this.matrix.startIndex;
        while (n4 < this.range) {
            int n6 = n4 + 1;
            int n7 = n5;
            realPointer2.reset(n6, 1);
            while (n6 < n) {
                rotation.construct(realContainer.get(n7 += n2));
                rotation.rotate(realPointer, realPointer2);
                ++n6;
                realPointer2.next();
            }
            ++n4;
            n5 += n3;
            realPointer.next();
        }
    }

    public void transformT(RealVector realVector) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        realVector.ensureLength(n);
        int n2 = this.matrix.rowStep;
        int n3 = this.matrix.columnStep;
        RealContainer realContainer = this.matrix.getContainer();
        RealPointer realPointer = realVector.getPointer(this.range - 1, -1);
        RealPointer realPointer2 = realVector.getPointer();
        Rotation rotation = new Rotation();
        int n4 = this.range - 1;
        int n5 = this.matrix.startIndex + n * n2 + (this.range - 1) * n3;
        while (n4 >= 0) {
            int n6 = n - 1;
            int n7 = n5;
            realPointer2.reset(n6, -1);
            while (n6 > n4) {
                rotation.construct(realContainer.get(n7 -= n2));
                rotation.rotate(realPointer2, realPointer);
                --n6;
                realPointer2.next();
            }
            --n4;
            n5 -= n3;
            realPointer.next();
        }
    }
}

