/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util;

import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;

public final class Reflection {
    private double gamma;
    private RealPointer v;
    private int count;

    public double construct(RealPointer realPointer, int n, double d) {
        this.v = (RealPointer)realPointer.clone();
        this.count = n;
        double d2 = RealMath.innerProduct(realPointer, this.v, n);
        if (d2 <= Math.max(d, 0.0)) {
            this.gamma = 0.0;
            return 0.0;
        }
        d2 = (double)(realPointer.get() < 0.0 ? -1 : 1) * Math.sqrt(d2);
        RealMath.multiply(realPointer, 1.0 / d2, n);
        realPointer.add(1.0);
        this.gamma = 1.0 / realPointer.get();
        return -d2;
    }

    public double constructAndReflect(RealContainer realContainer, int n, int n2, int n3, int n4, int n5, double d) {
        double d2 = this.construct(realContainer.getPointer(n, n2), n4, d);
        if (d2 != 0.0 && n5-- > 1) {
            int n6 = n;
            while (n5-- > 0) {
                realContainer.addVector(n += n3, n2, n6, n2, -this.gamma * realContainer.postProduct(n, n2, n6, n2, n4), n4);
            }
        }
        return d2;
    }

    public void prepare(RealPointer realPointer, int n) {
        this.v = (RealPointer)realPointer.clone();
        this.count = n;
        this.gamma = 1.0 / realPointer.get();
    }

    public void reflect(RealContainer realContainer, int n, int n2, int n3, int n4) {
        RealPointer realPointer = realContainer.getPointer();
        while (n4-- > 0) {
            this.reflect(realPointer.reset(n, n2));
            n += n3;
        }
    }

    public void reflect(RealPointer realPointer) {
        RealMath.addVector(realPointer, this.v, -this.gamma * RealMath.innerProduct(realPointer, this.v, this.count), this.count);
    }
}

