/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import java.io.Serializable;
import ru.sscc.util.data.DoubleIRefVector;
import ru.sscc.util.data.DoubleSRefVector;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.FloatIRefVector;
import ru.sscc.util.data.FloatSRefVector;
import ru.sscc.util.data.FloatVector;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;

public abstract class RealVector
implements Serializable {
    public final int length;
    protected int index;
    protected final int step;

    protected RealVector(int n, int n2, int n3) {
        this.length = n;
        this.index = n2;
        this.step = n3;
    }

    public abstract double add(int var1, double var2);

    public final void addVector(RealVector realVector, double d) {
        realVector.ensureLength(this.length);
        RealMath.addVector(this.getPointer(), realVector.getPointer(), d, this.length);
    }

    public final void addVector(RealVector realVector, double d, int n) {
        this.ensureLength(n);
        realVector.ensureLength(n);
        RealMath.addVector(this.getPointer(), realVector.getPointer(), d, n);
    }

    public final void assign(double d) {
        RealMath.assign(this.getPointer(), d, this.length);
    }

    public final void assign(double d, int n) {
        this.ensureLength(n);
        RealMath.assign(this.getPointer(), d, n);
    }

    public final void assign(RealVector realVector) {
        realVector.ensureLength(this.length);
        RealMath.assign(this.getPointer(), realVector.getPointer(), this.length);
    }

    public final void assign(RealVector realVector, double d) {
        realVector.ensureLength(this.length);
        RealMath.assign(this.getPointer(), realVector.getPointer(), d, this.length);
    }

    public final void assign(RealVector realVector, double d, int n) {
        this.ensureLength(n);
        realVector.ensureLength(n);
        RealMath.assign(this.getPointer(), realVector.getPointer(), d, n);
    }

    public final void assign(RealVector realVector, int n) {
        this.ensureLength(n);
        realVector.ensureLength(n);
        RealMath.assign(this.getPointer(), realVector.getPointer(), n);
    }

    public static RealVector by(Object object) {
        return object == null ? null : (object instanceof double[] ? new DoubleVector((double[])object) : (object instanceof float[] ? new FloatVector((float[])object) : (object instanceof RealContainer ? ((RealContainer)object).getVector() : (RealVector)object)));
    }

    public static RealVector by(Object object, Object object2) {
        return object instanceof double[] ? (object2 instanceof int[] ? new DoubleIRefVector((double[])object, (int[])object2) : new DoubleSRefVector((double[])object, (short[])object2)) : (object2 instanceof int[] ? new FloatIRefVector((float[])object, (int[])object2) : new FloatSRefVector((float[])object, (short[])object2));
    }

    public final void ensureLength(int n) {
        if (this.length < n) {
            throw new IllegalArgumentException("Vector length is less than " + n);
        }
    }

    public abstract double get(int var1);

    public abstract RealPointer getPointer();

    public final RealPointer getPointer(int n, int n2) {
        return this.getPointer().reset(n, n2);
    }

    protected final int inc(int n) {
        return n * this.step;
    }

    public final int indexOfNormMax() {
        return RealMath.indexOfNormMax(this.getPointer(), this.length);
    }

    public final int indexOfNormMax(int n) {
        this.ensureLength(n);
        return RealMath.indexOfNormMax(this.getPointer(), n);
    }

    public final double innerProduct(RealVector realVector) {
        realVector.ensureLength(this.length);
        return RealMath.innerProduct(this.getPointer(), realVector.getPointer(), this.length);
    }

    public final double innerProduct(RealVector realVector, int n) {
        this.ensureLength(n);
        realVector.ensureLength(n);
        return RealMath.innerProduct(this.getPointer(), realVector.getPointer(), n);
    }

    public abstract double mul(int var1, double var2);

    public final void multiply(double d) {
        RealMath.multiply(this.getPointer(), d, this.length);
    }

    public final void multiply(double d, int n) {
        this.ensureLength(n);
        RealMath.multiply(this.getPointer(), d, n);
    }

    public final double norm() {
        return RealMath.norm(this.getPointer(), this.length);
    }

    public final double norm(int n) {
        this.ensureLength(n);
        return RealMath.norm(this.getPointer(), n);
    }

    public final double normMax() {
        return RealMath.normMax(this.getPointer(), this.length);
    }

    public final double normMax(int n) {
        this.ensureLength(n);
        return RealMath.normMax(this.getPointer(), n);
    }

    public final double normSum() {
        return RealMath.normSum(this.getPointer(), this.length);
    }

    public final double normSum(int n) {
        this.ensureLength(n);
        return RealMath.normSum(this.getPointer(), n);
    }

    protected final int pos(int n) {
        return this.index + n * this.step;
    }

    public abstract double set(int var1, double var2);

    public abstract RealVector subvector(int var1, int var2, int var3);

    public final void swap(int n, int n2) {
        double d = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, d);
    }

    public final double weightedNorm(RealVector realVector) {
        if (realVector == null) {
            return RealMath.norm(this.getPointer(), this.length);
        }
        realVector.ensureLength(this.length);
        return RealMath.weightedNorm(this.getPointer(), realVector.getPointer(), this.length);
    }

    public final double weightedNorm(RealVector realVector, int n) {
        this.ensureLength(n);
        if (realVector == null) {
            return RealMath.norm(this.getPointer(), n);
        }
        realVector.ensureLength(n);
        return RealMath.weightedNorm(this.getPointer(), realVector.getPointer(), n);
    }

    public final double weightedNormMax(RealVector realVector) {
        if (realVector == null) {
            return RealMath.normMax(this.getPointer(), this.length);
        }
        realVector.ensureLength(this.length);
        return RealMath.weightedNormMax(this.getPointer(), realVector.getPointer(), this.length);
    }

    public final double weightedNormMax(RealVector realVector, int n) {
        this.ensureLength(n);
        if (realVector == null) {
            return RealMath.normMax(this.getPointer(), n);
        }
        realVector.ensureLength(n);
        return RealMath.weightedNormMax(this.getPointer(), realVector.getPointer(), n);
    }

    public final double weightedNormSum(RealVector realVector) {
        if (realVector == null) {
            return RealMath.normSum(this.getPointer(), this.length);
        }
        realVector.ensureLength(this.length);
        return RealMath.weightedNormSum(this.getPointer(), realVector.getPointer(), this.length);
    }

    public final double weightedNormSum(RealVector realVector, int n) {
        this.ensureLength(n);
        if (realVector == null) {
            return RealMath.normSum(this.getPointer(), n);
        }
        realVector.ensureLength(n);
        return RealMath.weightedNormSum(this.getPointer(), realVector.getPointer(), n);
    }

    public final double weightedProduct(RealVector realVector, RealVector realVector2) {
        realVector.ensureLength(this.length);
        if (realVector2 == null) {
            return RealMath.innerProduct(this.getPointer(), realVector.getPointer(), this.length);
        }
        realVector2.ensureLength(this.length);
        return RealMath.weightedProduct(this.getPointer(), realVector.getPointer(), realVector2.getPointer(), this.length);
    }

    public final double weightedProduct(RealVector realVector, RealVector realVector2, int n) {
        this.ensureLength(n);
        realVector.ensureLength(n);
        if (realVector2 == null) {
            return RealMath.innerProduct(this.getPointer(), realVector.getPointer(), n);
        }
        realVector2.ensureLength(n);
        return RealMath.weightedProduct(this.getPointer(), realVector.getPointer(), realVector2.getPointer(), n);
    }
}

